/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.harms.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.quality.harms.dao.QualityHarmFormsMapper;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmFormsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.service.QualityHarmFormsService;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQualityHarmFormsService")
public class QualityHarmFormsServiceImpl
implements QualityHarmFormsService {
    @Resource
    protected QualityHarmFormsMapper qualityHarmFormsMapper;
    @Resource
    protected QualityHarmMaterialsService qualityHarmMaterialsService;
    @Resource
    protected QualityHarmMaterialsItemService qualityHarmMaterialsItemService;

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    public void addObj(QualityHarmForms t) {
        this.qualityHarmFormsMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    public void deleteObjById(String id) {
        this.qualityHarmFormsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    public void modifyObj(QualityHarmForms t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.qualityHarmFormsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"qualityHarmForms"}, keyGenerator="redisKeyGenerator")
    public QualityHarmForms queryObjById(String id) {
        return this.qualityHarmFormsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"qualityHarmForms"}, keyGenerator="redisKeyGenerator")
    public List<QualityHarmForms> queryAllObjByExample(QualityHarmFormsExample example) {
        return this.qualityHarmFormsMapper.selectByExample(example);
    }

    @Cacheable(value={"qualityHarmForms"}, keyGenerator="redisKeyGenerator")
    public PageView<QualityHarmForms> queryObjByPage(QualityHarmFormsExample example) {
        PageView<QualityHarmForms> pageView = example.getPageView();
        pageView.setQueryResult(this.qualityHarmFormsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    @Transactional
    public void modifyForms(QualityHarmForms qualityHarmForms) {
        QualityHarmForms form = new QualityHarmForms();
        form.setId(qualityHarmForms.getId());
        form.setUpdateTime(new Date());
        form.setOtherReportCode(qualityHarmForms.getOtherReportCode());
        this.qualityHarmFormsMapper.updateByPrimaryKeySelective(form);
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria().andIdEqualTo(qualityHarmForms.getHarmMaterialItemId());
        List materialsItems = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)materialsItems)) {
            throw new CommonException("\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        QualityHarmMaterialsItem item = new QualityHarmMaterialsItem();
        item.setId(qualityHarmForms.getHarmMaterialItemId());
        item.setOtherReportCode(form.getOtherReportCode());
        this.qualityHarmMaterialsItemService.modifyObj(item);
    }

    @Transactional
    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    public void addAll(List<QualityHarmForms> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.qualityHarmFormsMapper.insertSelective((QualityHarmForms)item);
        });
    }

    @CacheEvict(value={"qualityHarmForms"}, allEntries=true)
    public void deleteByExample(QualityHarmFormsExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.qualityHarmFormsMapper.deleteByExample(arg0);
    }
}

