/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.harms.service.impl;

import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.harms.dao.QualityHarmMaterialsMapper;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.im.HarmMaterialImTemplet;
import com.els.base.quality.harms.service.QualityHarmFormsService;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQualityHarmMaterialsService")
public class QualityHarmMaterialsServiceImpl
implements QualityHarmMaterialsService {
    private static final String IM_CODE = "QUALITY_HARM_MATERIAL";
    @Resource
    protected QualityHarmMaterialsMapper qualityHarmMaterialsMapper;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private QualityHarmMaterialsItemService qualityHarmMaterialsItemService;
    @Resource
    private QualityHarmFormsService qualityHarmFormsService;

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void addObj(QualityHarmMaterials t) {
        this.qualityHarmMaterialsMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void deleteObjById(String id) {
        this.qualityHarmMaterialsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void modifyObj(QualityHarmMaterials t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.qualityHarmMaterialsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"qualityHarmMaterials"}, keyGenerator="redisKeyGenerator")
    public QualityHarmMaterials queryObjById(String id) {
        return this.qualityHarmMaterialsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"qualityHarmMaterials"}, keyGenerator="redisKeyGenerator")
    public List<QualityHarmMaterials> queryAllObjByExample(QualityHarmMaterialsExample example) {
        return this.qualityHarmMaterialsMapper.selectByExample(example);
    }

    @Cacheable(value={"qualityHarmMaterials"}, keyGenerator="redisKeyGenerator")
    public PageView<QualityHarmMaterials> queryObjByPage(QualityHarmMaterialsExample example) {
        PageView<QualityHarmMaterials> pageView = example.getPageView();
        pageView.setQueryResult(this.qualityHarmMaterialsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void delete(List<QualityHarmMaterials> data, com.els.base.auth.entity.User user) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u5220\u9664\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setIsEnable(Constant.NO_INT);
        qhm.setUpdateTime(new Date());
        qhm.setPurUserId(user.getId());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void abolish(List<QualityHarmMaterials> data, final com.els.base.auth.entity.User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u4f5c\u5e9f\u5355\u636e!");
        }
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        example.clear();
        example.createCriteria().andIdIn(ids).andBillStatusIn(billStatusList);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u56de\u7b7e\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u9a73\u56de\u6216\u5df2\u4f5c\u5e9f\u7684\u5355\u636e,\u65e0\u6cd5\u4f5c\u5e9f\u5355\u636e");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials materials = new QualityHarmMaterials();
        materials.setBillStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        materials.setReportCheckStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatusDesc());
        materials.setUpdateTime(new Date());
        materials.setPurUserId(loginUser.getId());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(materials, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u4f5c\u5e9f", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(loginUser, templet, (QualityHarmMaterials)list.get(0));
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void sendToSup(List<QualityHarmMaterials> data, final com.els.base.auth.entity.User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u91cd\u590d\u53d1\u9001\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setSendStatus(Constant.YES_INT);
        qhm.setUpdateTime(new Date());
        qhm.setPurSendTime(new Date());
        qhm.setPurCommitTime(new Date());
        qhm.setPurUserId(loginUser.getId());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u53d1\u9001", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(loginUser, templet, (QualityHarmMaterials)list.get(0));
                }
            });
        }
    }

    private Map<String, List<QualityHarmMaterials>> groupHamrMaterial(List<QualityHarmMaterials> list) {
        if (null == list) {
            return null;
        }
        HashMap<String, List<QualityHarmMaterials>> groupMap = new HashMap<String, List<QualityHarmMaterials>>();
        for (QualityHarmMaterials qhm : list) {
            String supCompanySrmCode = qhm.getSupCompanySrmCode();
            ArrayList<QualityHarmMaterials> materials = (ArrayList<QualityHarmMaterials>)groupMap.get(supCompanySrmCode);
            if (null == materials) {
                materials = new ArrayList<QualityHarmMaterials>();
            }
            materials.add(qhm);
            groupMap.put(supCompanySrmCode, materials);
        }
        return groupMap;
    }

    private HarmMaterialImTemplet constructImInfo(int role, String operate, List<QualityHarmMaterials> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u5217\u8868\u4e3a\u7a7a,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        }
        HarmMaterialImTemplet tem = new HarmMaterialImTemplet();
        if (role == 1) {
            tem.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getPurCompanyName())) {
                tem.setCompanyName(list.get(0).getPurCompanyName());
            } else {
                tem.setCompanyName("");
            }
        } else {
            tem.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getSupCompanyName())) {
                tem.setCompanyName(list.get(0).getSupCompanyName());
            } else {
                tem.setCompanyName("");
            }
        }
        Assert.isNotBlank((String)operate, (String)"\u6ca1\u6709\u4f20\u5165\u64cd\u4f5c\u5b57\u6bb5,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        tem.setOperate(operate);
        tem.setOtherInfo("\u4e86\u65b0\u7684\u6709\u5bb3\u7269\u8d28\u62a5\u544a\u5355\u636e,\u5355\u636e\u53f7\u5305\u62ec\uff1a");
        ArrayList<String> noList = new ArrayList<String>();
        for (QualityHarmMaterials item : list) {
            noList.add(item.getHarmBillNo());
        }
        String billData = StringUtils.join(noList, (String)",");
        tem.setBillList(billData);
        return tem;
    }

    public void sendMessagesToSup(com.els.base.auth.entity.User loginUser, HarmMaterialImTemplet templet, QualityHarmMaterials data) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    public void sendMessagesToPur(QualityHarmMaterials data, HarmMaterialImTemplet templet) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(data.getSupUserId()).addReceiverId(data.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void sendToPur(List<QualityHarmMaterials> data, com.els.base.auth.entity.User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            QualityHarmMaterialsItemExample itemExample = new QualityHarmMaterialsItemExample();
            itemExample.createCriteria().andHarmMaterialIdEqualTo(item.getId());
            List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)itemExample);
            if (CollectionUtils.isEmpty((Collection)itemList)) {
                throw new CommonException("id\u4e3a" + item.getId() + "\u7684\u884c\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u56de\u7b7e\u5355\u636e!");
            }
            for (QualityHarmMaterialsItem it : itemList) {
                if (StringUtils.isEmpty((String)it.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7\u4e3a" + it.getHarmBillNo() + ",\u5176\u4e2d\u884c'" + it.getCheckReportName() + "'\u6ca1\u6709\u63d0\u4ea4\u5fc5\u586b\u7684\u9644\u4ef6,\u65e0\u6cd5\u56de\u7b7e\u5355\u636e!");
                }
                if (!"[]".equals(it.getAttachment())) continue;
                throw new CommonException("\u5355\u636e\u53f7\u4e3a" + it.getHarmBillNo() + ",\u5176\u4e2d\u884c'" + it.getCheckReportName() + "'\u6ca1\u6709\u63d0\u4ea4\u5fc5\u586b\u7684\u9644\u4ef6,\u65e0\u6cd5\u56de\u7b7e\u5355\u636e!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u56de\u7b7e\u5355\u636e!");
        }
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        example.clear();
        example.createCriteria().andIdIn(ids).andBillStatusIn(billStatusList);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u53ea\u6709\u672a\u56de\u7b7e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u56de\u7b7e\u5355\u636e,\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u56de\u7b7e\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u9a73\u56de\u7684\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        qhm.setReportCheckStatus(BillStatusEnum.STATUS_SIGNED.getBillStatusDesc());
        qhm.setSupSignTime(new Date());
        qhm.setSupCommitTime(new Date());
        qhm.setUpdateTime(new Date());
        qhm.setSupUserId(loginUser.getId());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(2, "\u56de\u7b7e", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToPur((QualityHarmMaterials)list.get(0), templet);
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void audit(List<QualityHarmMaterials> data, final com.els.base.auth.entity.User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (QualityHarmMaterials materials : data) {
            Assert.isNotBlank((String)materials.getId(), (String)"\u4f20\u9012\u5230\u7684\u53c2\u6570\u5217\u8868\u5b58\u5728id\u4e3a\u7a7a");
            ids.add(materials.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u5ba1\u6838\u5355\u636e!");
        }
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        example.clear();
        example.createCriteria().andIdIn(ids).andBillStatusIn(billStatusList);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u53ea\u6709\u5df2\u56de\u7b7e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5ba1\u6838,\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u56de\u7b7e\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u9a73\u56de\u7684\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setBillStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        qhm.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatusDesc());
        qhm.setApproveTime(new Date());
        qhm.setApproveUsername(loginUser.getNickName());
        qhm.setUpdateTime(new Date());
        qhm.setPurUserId(loginUser.getId());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
        this.addToHarmForms(data);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u5ba1\u6838", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(loginUser, templet, (QualityHarmMaterials)list.get(0));
                }
            });
        }
    }

    private void addToHarmForms(List<QualityHarmMaterials> data) {
        if (data == null) {
            return;
        }
        for (QualityHarmMaterials qhm : data) {
            QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
            example.createCriteria().andHarmMaterialIdEqualTo(qhm.getId());
            List items = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)example);
            QualityHarmMaterialsExample example2 = new QualityHarmMaterialsExample();
            example2.createCriteria().andIdEqualTo(qhm.getId());
            List<QualityHarmMaterials> harmMaterials = this.qualityHarmMaterialsMapper.selectByExample(example2);
            for (QualityHarmMaterials qh : harmMaterials) {
                for (QualityHarmMaterialsItem item : items) {
                    QualityHarmForms form = new QualityHarmForms();
                    form.setProjectId(item.getProjectId());
                    form.setHarmMaterialId(item.getHarmMaterialId());
                    form.setHarmMaterialItemId(item.getId());
                    form.setReportCode(item.getReportCode());
                    form.setRemark(item.getItemSupRemark());
                    form.setPurCompanyId(qh.getPurCompanyId());
                    form.setPurCompanySrmCode(qh.getPurCompanySrmCode());
                    form.setPurCompanyName(qh.getPurCompanyName());
                    form.setPurCompanyFullName(qh.getPurCompanyFullName());
                    form.setSupCompanyId(qh.getSupCompanyId());
                    form.setSupCompanyName(qh.getSupCompanyName());
                    form.setSupCompanyFullName(qh.getSupCompanyFullName());
                    form.setSupCompanySapCode(qh.getSupCompanySapCode());
                    form.setSupCompanySrmCode(qh.getSupCompanySrmCode());
                    form.setMaterialCode(qh.getMaterialCode());
                    form.setMaterialDesc(qh.getMaterialDesc());
                    form.setOtherReportCode(item.getOtherReportCode());
                    form.setCheckReportName(item.getCheckReportName());
                    form.setCheckTime(item.getCheckTime());
                    form.setAttachment(item.getAttachment());
                    form.setCreateTime(new Date());
                    this.qualityHarmFormsService.addObj(form);
                }
            }
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void reject(List<QualityHarmMaterials> data, final com.els.base.auth.entity.User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (QualityHarmMaterials qhm : data) {
            Assert.isNotBlank((String)qhm.getId(), (String)"\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            ids.add(qhm.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u9a73\u56de!");
        }
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        example.clear();
        example.createCriteria().andIdIn(ids).andBillStatusIn(billStatusList);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u53ea\u6709\u5df2\u56de\u7b7e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u9a73\u56de,\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u56de\u7b7e\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u4f5c\u5e9f\u6216\u5df2\u9a73\u56de\u7684\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials materials = new QualityHarmMaterials();
        materials.setBillStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        materials.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatusDesc());
        materials.setApproveTime(new Date());
        materials.setApproveUsername(loginUser.getNickName());
        materials.setUpdateTime(new Date());
        materials.setPurUserId(loginUser.getId());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(materials, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u9a73\u56de", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(loginUser, templet, (QualityHarmMaterials)list.get(0));
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void updateBillAttachmentInfo(QualityHarmMaterialsVO vo) {
        Assert.isNotNull((Object)vo, (String)"\u4f20\u9012\u6570\u636e\u4e3a\u7a7a");
        Assert.isNotBlank((String)vo.getId(), (String)"\u4f20\u9012\u7684\u5355\u636eid\u4e3a\u7a7a");
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdEqualTo(vo.getId()).andBillStatusIn(billStatusList);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u53ea\u6709\u672a\u56de\u7b7e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u4fee\u6539\u9644\u4ef6\u4fe1\u606f!");
        }
        List<QualityHarmMaterialsItem> itemList = vo.getItemList();
        if (CollectionUtils.isEmpty(itemList)) {
            throw new CommonException("\u884c\u9879\u6570\u636e\u4e3a\u7a7a!");
        }
        for (QualityHarmMaterialsItem item : itemList) {
            Assert.isNotBlank((String)item.getAttachment(), (String)("'" + item.getCheckReportName() + "'\u5fc5\u987b\u63d0\u4ea4\u7684\u9644\u4ef6\u4f20\u9012\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isNotNull((Object)item.getCheckTime(), (String)("'" + item.getCheckReportName() + "'\u7684\u68c0\u6d4b\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            if (!"[]".equals(item.getAttachment())) continue;
            throw new CommonException("'" + item.getCheckReportName() + "'\u5fc5\u987b\u63d0\u4ea4\u7684\u9644\u4ef6\u4f20\u9012\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.qualityHarmMaterialsItemService.deleteByDetailId(vo.getId());
        for (QualityHarmMaterialsItem item : itemList) {
            item.setCreateTime(new Date());
            item.setHarmMaterialId(vo.getId());
            item.setHarmBillNo(vo.getHarmBillNo());
            item.setProjectId(vo.getProjectId());
            this.qualityHarmMaterialsItemService.addObj(item);
        }
    }

    @Transactional
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void addAll(List<QualityHarmMaterials> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.qualityHarmMaterialsMapper.insertSelective((QualityHarmMaterials)item);
        });
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void deleteByExample(QualityHarmMaterialsExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.qualityHarmMaterialsMapper.deleteByExample(arg0);
    }
}

