/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.harms.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.harms.command.CreateHarmsCmd;
import com.els.base.quality.harms.command.ModifyHarmsCmd;
import com.els.base.quality.harms.common.HarmsInvorker;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
@Controller
@RequestMapping(value={"qualityHarmMaterials"})
public class QualityHarmMaterialsController {
    @Resource
    private HarmsInvorker Invorker;
    @Resource
    protected QualityHarmMaterialsService qualityHarmMaterialsService;
    @Resource
    protected QualityHarmMaterialsItemService qualityHarmMaterialsItemService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QualityHarmMaterialsVO qualityHarmMaterialsVO) {
        CreateHarmsCmd cmd = new CreateHarmsCmd(qualityHarmMaterialsVO);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.Invorker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QualityHarmMaterialsVO vo) {
        Assert.isNotBlank((String)vo.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyHarmsCmd cmd = new ModifyHarmsCmd(vo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.Invorker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
    @RequestMapping(value={"service/pur/delete"})
    @ResponseBody
    public ResponseResult<String> delete(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.delete(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/pur/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.abolish(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u5355\u636e")
    @RequestMapping(value={"service/pur/sendToSup"})
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.sendToSup(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u56de\u7b7e\u5355\u636e")
    @RequestMapping(value={"service/pur/sendToPur"})
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.sendToPur(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5ba1\u6838\u5355\u636e")
    @RequestMapping(value={"service/pur/audit"})
    @ResponseBody
    public ResponseResult<String> audit(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.audit(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u9a73\u56de\u5355\u636e")
    @RequestMapping(value={"service/pur/reject"})
    @ResponseBody
    public ResponseResult<String> reject(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.reject(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"service/sup/updateBillAttachmentInfo"})
    @ResponseBody
    public ResponseResult<String> updateBillAttachmentInfo(@RequestBody QualityHarmMaterialsVO vo) {
        this.qualityHarmMaterialsService.updateBillAttachmentInfo(vo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6709\u5bb3\u7269\u8d28\u62a5\u544a(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QualityHarmMaterials", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QualityHarmMaterials>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.setPageView((PageView<QualityHarmMaterials>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        QualityHarmMaterialsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.qualityHarmMaterialsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6709\u5bb3\u7269\u8d28\u62a5\u544a(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QualityHarmMaterials", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QualityHarmMaterials>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.setPageView((PageView<QualityHarmMaterials>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        Company company = CompanyUtils.currentCompany();
        QualityHarmMaterialsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.qualityHarmMaterialsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u636e\u8be6\u60c5(\u91c7\u8d2d\u65b9)")
    @RequestMapping(value={"service/pur/findDetailById"})
    @ResponseBody
    public ResponseResult<QualityHarmMaterialsVO> findDetailByIdForPur(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        }
        QualityHarmMaterials data = (QualityHarmMaterials)this.qualityHarmMaterialsService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u6839\u636eid\u67e5\u627e\u7684\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        QualityHarmMaterialsVO vo = new QualityHarmMaterialsVO();
        BeanUtils.copyProperties((Object)data, (Object)vo);
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria().andHarmMaterialIdEqualTo(id);
        List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)example);
        if (BillStatusEnum.STATUS_UN_SIGN.getBillStatus().equals(vo.getBillStatus()) && CollectionUtils.isNotEmpty((Collection)itemList)) {
            for (QualityHarmMaterialsItem item : itemList) {
                item.setAttachment(null);
                item.setCheckTime(null);
                item.setItemSupRemark(null);
            }
        }
        vo.setItemList(itemList);
        return ResponseResult.success((Object)vo);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u636e\u8be6\u60c5(\u4f9b\u5e94\u5546\u65b9)")
    @RequestMapping(value={"service/sup/findDetailById"})
    @ResponseBody
    public ResponseResult<QualityHarmMaterialsVO> findDetailById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        }
        QualityHarmMaterials data = (QualityHarmMaterials)this.qualityHarmMaterialsService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u6839\u636eid\u67e5\u627e\u7684\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        QualityHarmMaterialsVO vo = new QualityHarmMaterialsVO();
        BeanUtils.copyProperties((Object)data, (Object)vo);
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria().andHarmMaterialIdEqualTo(id);
        List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)example);
        vo.setItemList(itemList);
        return ResponseResult.success((Object)vo);
    }
}

