/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.inspection.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.quality.bill.service.UnQualifiedBillService;
import com.els.base.quality.inspection.dao.InspectionMapper;
import com.els.base.quality.inspection.entity.Inspection;
import com.els.base.quality.inspection.entity.InspectionExample;
import com.els.base.quality.inspection.service.InspectionService;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInspectionService")
public class InspectionServiceImpl
implements InspectionService {
    Logger LOGGER = LoggerFactory.getLogger(InspectionServiceImpl.class);
    @Resource
    protected InspectionMapper inspectionMapper;
    @Resource
    protected UnQualifiedBillService billService;
    @Resource
    protected CompanyService companyService;

    @CacheEvict(value={"inspection"}, allEntries=true)
    public void addObj(Inspection t) {
        this.inspectionMapper.insertSelective(t);
    }

    @CacheEvict(value={"inspection"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inspectionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inspection"}, allEntries=true)
    public void modifyObj(Inspection t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inspectionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"inspection"}, keyGenerator="redisKeyGenerator")
    public Inspection queryObjById(String id) {
        return this.inspectionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"inspection"}, keyGenerator="redisKeyGenerator")
    public List<Inspection> queryAllObjByExample(InspectionExample example) {
        return this.inspectionMapper.selectByExample(example);
    }

    @Cacheable(value={"inspection"}, keyGenerator="redisKeyGenerator")
    public PageView<Inspection> queryObjByPage(InspectionExample example) {
        this.LOGGER.info("\u67e5\u8be2\u63a5\u53e3------------------");
        PageView<Inspection> pageView = example.getPageView();
        pageView.setQueryResult(this.inspectionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"inspection"}, allEntries=true)
    public int importInspectionFromSAP(List<Inspection> list, StringBuilder builder) {
        int errorCount = 0;
        builder.append("\u5f00\u59cb\u5904\u7406\u6570\u636e").append("\r\n");
        if (list == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        builder.append("\u63a5\u6536\u5230\u4e0d\u5408\u683c\u68c0\u9a8c\u6279\u6b21\u6570\u636e" + list.size() + "\u6761").append("\r\n");
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        builder.append("\u5f00\u59cb\u5904\u7406\u6570\u636e").append("\r\n");
        for (Inspection item : list) {
            try {
                InspectionExample inspectionExample = new InspectionExample();
                InspectionExample.Criteria criteria = inspectionExample.createCriteria();
                criteria.andInspectionLotEqualTo(item.getInspectionLot());
                int count = this.inspectionMapper.countByExample(inspectionExample);
                if (count > 0) {
                    Inspection inspection = this.inspectionMapper.selectByExample(inspectionExample).get(0);
                    criteria.andIdEqualTo(inspection.getId());
                    item.setUpdateTime(new Date());
                    item.setUpdateUserId("Webservice");
                    item.setUpdateUserName("Webservice");
                    this.inspectionMapper.updateByExampleSelective(item, inspectionExample);
                    continue;
                }
                item.setProjectId(projectId);
                item.setCompanyId(companyId);
                item.setCreateTime(new Date());
                item.setCreateUserId(item.getInspectionUser());
                item.setCreateUserName(item.getInspectionUser());
                item.setUpdateTime(new Date());
                item.setUpdateUserId(item.getInspectionUser());
                item.setUpdateUserName(item.getInspectionUser());
                this.inspectionMapper.insertSelective(item);
                try {
                    this.billService.createUnQualifiedBill(item);
                }
                catch (CommonException ee) {
                    builder.append("\u4e0d\u5408\u683c\u68c0\u9a8c\u6279\u6b21\u751f\u6210\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\u636e\u5931\u8d25,\u9519\u8bef\u539f\u56e0:" + ee.getMessage()).append("\r\n");
                }
                catch (Exception ee) {
                    builder.append("\u4e0d\u5408\u683c\u68c0\u9a8c\u6279\u6b21\u751f\u6210\u4e0d\u5408\u683c\u54c1\u5904\u7f6e\u5355\u636e\u5931\u8d25,\u9519\u8bef\u539f\u56e0:" + ee.getMessage()).append("\r\n");
                }
            }
            catch (Exception e) {
                ++errorCount;
                builder.append("\u68c0\u9a8c\u6279\u6b21:" + item.getInspectionLot() + "\u6570\u636e\u4fdd\u5b58\u5931\u8d25").append("\r\n");
                try {
                    builder.append("\u68c0\u9a8c\u6279\u6b21\u4fe1\u606f").append("\r\n");
                    builder.append(JsonUtils.writeValueAsString((Object)item)).append("\r\n");
                }
                catch (JsonProcessingException e1) {
                    e1.printStackTrace();
                }
                builder.append("\u9519\u8bef\u539f\u56e0:" + e.getMessage()).append("\r\n");
            }
        }
        builder.append("\u5904\u7406\u6210\u529f\u6761\u6570 " + (list.size() - errorCount) + "\u6761").append("\r\n");
        builder.append("\u5904\u7406\u5931\u8d25\u6761\u6570 " + errorCount + "\u6761").append("\r\n");
        builder.append("\u6570\u636e\u5904\u7406\u5b8c\u6210").append("\r\n");
        return errorCount;
    }

    @Cacheable(value={"inspection"}, keyGenerator="redisKeyGenerator")
    public Boolean isExists(Inspection entity) {
        InspectionExample inspectionExample = new InspectionExample();
        InspectionExample.Criteria criteria = inspectionExample.createCriteria();
        criteria.andInspectionLotEqualTo(entity.getInspectionLot());
        int count = this.inspectionMapper.countByExample(inspectionExample);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Transactional
    @CacheEvict(value={"inspection"}, allEntries=true)
    public void addAll(List<Inspection> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.inspectionMapper.insertSelective((Inspection)item);
        });
    }

    @CacheEvict(value={"inspection"}, allEntries=true)
    public void deleteByExample(InspectionExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.inspectionMapper.deleteByExample(arg0);
    }
}

