/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.ncr.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.ncr.dao.NcrMapper;
import com.els.base.quality.ncr.entity.Ncr;
import com.els.base.quality.ncr.entity.NcrExample;
import com.els.base.quality.ncr.service.NcrService;
import com.els.base.quality.ncr.utils.NcrStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultNcrService")
public class NcrServiceImpl
implements NcrService {
    @Resource
    protected NcrMapper ncrMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyUserRefService companyUserRefService;

    @CacheEvict(value={"ncr"}, allEntries=true)
    public void addObj(Ncr t) {
        this.ncrMapper.insertSelective(t);
    }

    @CacheEvict(value={"ncr"}, allEntries=true)
    public void deleteObjById(String id) {
        this.ncrMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"ncr"}, allEntries=true)
    public void modifyObj(Ncr t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.ncrMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"ncr"}, keyGenerator="redisKeyGenerator")
    public Ncr queryObjById(String id) {
        return this.ncrMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"ncr"}, keyGenerator="redisKeyGenerator")
    public List<Ncr> queryAllObjByExample(NcrExample example) {
        return this.ncrMapper.selectByExample(example);
    }

    @Cacheable(value={"ncr"}, keyGenerator="redisKeyGenerator")
    public PageView<Ncr> queryObjByPage(NcrExample example) {
        PageView<Ncr> pageView = example.getPageView();
        pageView.setQueryResult(this.ncrMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void importNcrFromQMS(List<Ncr> list, StringBuilder builder) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                if (this.isExists(ncritem).booleanValue()) {
                    ncritem.setUpdateUserId("WebService");
                    ncritem.setUpdateUserName("WebService");
                    ncritem.setUpdateTime(now);
                    continue;
                }
                CompanyExample supCompanyExample = new CompanyExample();
                supCompanyExample.createCriteria().andCompanyNameEqualTo(ncritem.getSupCompanyName());
                List supCompanyList = this.companyService.queryAllObjByExample((IExample)supCompanyExample);
                if (CollectionUtils.isNotEmpty((Collection)supCompanyList)) {
                    ncritem.setSupCompanyCode(((Company)supCompanyList.get(0)).getCompanyCode());
                    ncritem.setSupCompanySapCode(((Company)supCompanyList.get(0)).getCompanySapCode());
                }
                ncritem.setStatus(NcrStatusEnum.STATUS_NEW.getValue());
                ncritem.setProjectId(projectId);
                ncritem.setCompanyId(companyId);
                ncritem.setCreateUserId("WebService");
                ncritem.setUpdateUserId("WebService");
                ncritem.setCreateUserName("WebService");
                ncritem.setUpdateUserName("WebService");
                ncritem.setCreateTime(now);
                ncritem.setUpdateTime(now);
                this.addObj(ncritem);
            }
            catch (CommonException ee) {
                builder.append("\u6570\u636e\u5bfc\u5165\u5931\u8d25").append("\r\n");
                builder.append("\u5355\u636e\u53f7\u7801" + ncritem.getNcrNumber()).append("\r\n");
                builder.append(ee.getMessage()).append("\r\n");
            }
        }
    }

    @CacheEvict(value={"ncr"}, allEntries=true)
    @Cacheable(value={"inspection"}, keyGenerator="redisKeyGenerator")
    public Boolean isExists(Ncr ncr) {
        NcrExample inspectionExample = new NcrExample();
        NcrExample.Criteria criteria = inspectionExample.createCriteria();
        criteria.andNcrQmsIdEqualTo(ncr.getNcrQmsId());
        criteria.andNcrNumberEqualTo(ncr.getNcrNumber());
        int count = this.ncrMapper.countByExample(inspectionExample);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void importNcr(String projectId, String companyId, User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setProjectId(projectId);
                ncritem.setCompanyId(companyId);
                ncritem.setCreateUserId(user.getId());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setCreateUserName(user.getNickName());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setCreateTime(now);
                ncritem.setUpdateTime(now);
                ncritem.setPurCompanyName("\u5357\u4eac\u5eb7\u5c3c\u673a\u7535\u8f68\u9053\u4ea4\u901a");
                ncritem.setPurCompanySapCode("50000000");
                ncritem.setStatus(NcrStatusEnum.STATUS_NEW.getValue());
                this.addObj(ncritem);
            }
            catch (CommonException ee) {
                throw new CommonException("\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff01" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void addNcr(String projectId, String currentCompanyId, com.els.base.auth.entity.User loginUser, Ncr ncr) {
        Date now = new Date();
        ncr.setProjectId(projectId);
        ncr.setCompanyId(currentCompanyId);
        ncr.setCreateUserId(loginUser.getId());
        ncr.setUpdateUserId(loginUser.getId());
        ncr.setCreateUserName(loginUser.getNickName());
        ncr.setUpdateUserName(loginUser.getNickName());
        ncr.setCreateTime(now);
        ncr.setUpdateTime(now);
        ncr.setPurCompanyName("\u5357\u4eac\u5eb7\u5c3c\u673a\u7535\u8f68\u9053\u4ea4\u901a");
        ncr.setPurCompanySapCode("50000000");
        ncr.setStatus(NcrStatusEnum.STATUS_NEW.getValue());
        this.addObj(ncr);
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void pushedToBuyer(User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
                this.modifyObj(ncritem);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void pushedToSuppler(User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setStatus(NcrStatusEnum.STATUS_PUBLIC.getValue());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
                ncritem.setSendStatus(Constant.YES_INT);
                this.modifyObj(ncritem);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void supplerResponse(User user, Ncr entity) {
        Date now = new Date();
        Ncr ncr = this.queryObjById(entity.getId());
        ncr.setCauseAnalysis(entity.getCauseAnalysis());
        ncr.setCorrectiveAnalysis(entity.getCorrectiveAnalysis());
        ncr.setCompletionDate(entity.getCompletionDate());
        ncr.setStatus(NcrStatusEnum.STATUS_CONFIRM.getValue());
        ncr.setSupplierResponseTime(new Date());
        entity.setUpdateUserId(user.getId());
        entity.setUpdateUserName(user.getNickName());
        entity.setUpdateTime(now);
        this.modifyObj(ncr);
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void acceptToSuppler(String projectId, String companyId, User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setStatus(NcrStatusEnum.STATUS_APPROVE.getValue());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
                this.modifyObj(ncritem);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void refuseToSuppler(String projectId, String companyId, User user, List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Ncr ncritem : list) {
            try {
                ncritem.setStatus(NcrStatusEnum.STATUS_REFUSED.getValue());
                ncritem.setUpdateUserId(user.getId());
                ncritem.setUpdateUserName(user.getNickName());
                ncritem.setUpdateTime(now);
                this.modifyObj(ncritem);
            }
            catch (CommonException ee) {
                throw new CommonException("\u63a8\u9001\u5931\u8d25\uff1a" + ee.getMessage());
            }
        }
    }

    @Override
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void addAttachment(User user, Ncr ncr) {
        Date now = new Date();
        ncr.setUpdateUserId(user.getId());
        ncr.setUpdateUserName(user.getNickName());
        ncr.setUpdateTime(now);
        this.modifyObj(ncr);
    }

    @Override
    @Cacheable(value={"ncr"}, keyGenerator="redisKeyGenerator")
    public int countByExample(NcrExample ncrExample) {
        int countByExample = this.ncrMapper.countByExample(ncrExample);
        return countByExample;
    }

    @Transactional
    @CacheEvict(value={"ncr"}, allEntries=true)
    public void addAll(List<Ncr> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.ncrMapper.insertSelective((Ncr)item);
        });
    }

    @CacheEvict(value={"ncr"}, allEntries=true)
    public void deleteByExample(NcrExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.ncrMapper.deleteByExample(arg0);
    }

    @Override
    public void outTimeReply() {
        List<Ncr> ncrList = this.ncrMapper.selectOutTimeReplyData();
        Map<String, List<Ncr>> listMap = ncrList.stream().collect(Collectors.groupingBy(Ncr::getSupCompanySapCode));
        for (Map.Entry<String, List<Ncr>> entry : listMap.entrySet()) {
            List<Ncr> value = entry.getValue();
            List ncrNumberList = value.stream().map(Ncr::getNcrNumber).collect(Collectors.toList());
            String ncrNumber = StringUtils.join(ncrNumberList, (String)",");
            CompanyExample example = new CompanyExample();
            example.createCriteria().andCompanySapCodeEqualTo(entry.getKey());
            List companyList = this.companyService.queryAllObjByExample((IExample)example);
            User user = this.companyUserRefService.queryMainUserOfCompany(((Company)companyList.get(0)).getId());
            Ncr ncr = new Ncr();
            ncr.setNcrNumber(ncrNumber);
            ncr.setSupUserId(user.getId());
            ncr.setSupCompanyCode(((Company)companyList.get(0)).getCompanyCode());
            Message message = Message.init((Object)ncr).setCompanyCode(entry.getKey()).setSenderId("1").addReceiverId(user.getId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(NcrStatusEnum.NCR_OUT_TIME_REPLY.getDesc());
            MessageSendUtils.sendMessage((Message)message);
        }
    }
}

