/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.ncr.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.ncr.entity.Ncr;
import com.els.base.quality.ncr.entity.NcrExample;
import com.els.base.quality.ncr.service.NcrService;
import com.els.base.quality.ncr.utils.MultipleDateConverter;
import com.els.base.quality.ncr.utils.NcrStatusEnum;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="NCR\u6570\u636e\u8868")
@Controller
@RequestMapping(value={"ncr"})
public class NcrController {
    private static final NcrController titleAndModelKeys = null;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected NcrService ncrService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaNCR\u6570\u636e\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Ncr ncr) {
        this.ncrService.addObj(ncr);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u589encr")
    @RequestMapping(value={"service/add"})
    @ResponseBody
    public ResponseResult<String> add(@RequestBody Ncr ncr) {
        Assert.isNotBlank((String)ncr.getNcrQmsId(), (String)"QMS\u7cfb\u7edf\u7684NCRID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getNcrNumber(), (String)"NCR\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getNcrReport(), (String)"NCR\u62a5\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)ncr.getOpenTime(), (String)"\u5f00\u7acb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getIsClose(), (String)"\u662f\u5426\u5173\u95ed\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getMaterialCode(), (String)"\u7269\u6599\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getMaterialName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getMapNo(), (String)"\u56fe\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)ncr.getQuantity(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getUnqualifiedDescription(), (String)"\u4e0d\u5408\u683c\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getUnqualifiedType(), (String)"\u4e0d\u5408\u683c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getPurCompanyName(), (String)"\u8d23\u4efb\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getProject(), (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getResponsible(), (String)"\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getDisposalWay(), (String)"\u5904\u7406\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getDisposalUser(), (String)"\u5f53\u524d\u5904\u7f6e\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546sapcode\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ncr.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.ncrService.addNcr(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), ncr);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91NCR\u6570\u636e\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Ncr ncr) {
        Assert.isNotBlank((String)ncr.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.ncrService.modifyObj(ncr);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664NCR\u6570\u636e\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.ncrService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664NCR\u6570\u636e\u8868")
    @RequestMapping(value={"service/deleteByIdArray"})
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5355\u636e!");
        }
        for (String id : list) {
            Ncr entity = (Ncr)this.ncrService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getStatus().equals(NcrStatusEnum.STATUS_NEW.getValue())) {
                this.ncrService.deleteObjById(id);
                continue;
            }
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u72b6\u6001\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664!");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2NCR\u6570\u636e\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Ncr", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Ncr>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        NcrExample example = new NcrExample();
        example.setPageView((PageView<Ncr>)new PageView(pageNo, pageSize));
        NcrExample.Criteria criteria = example.createCriteria();
        ArrayList<String> companyCodeArray = new ArrayList<String>();
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            for (Company company : companyList) {
                companyCodeArray.add(company.getCompanySapCode());
            }
            criteria.andSupCompanySapCodeIn(companyCodeArray);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.ncrService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u63a8\u9001\u5230\u91c7\u8d2d\u5458")
    @RequestMapping(value={"service/pushedToBuyer"})
    @ResponseBody
    public ResponseResult<String> pushedToBuyer(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u5355\u636e");
        }
        ArrayList<Ncr> NcrArray = new ArrayList<Ncr>();
        for (String id : list) {
            Ncr entity = (Ncr)this.ncrService.queryObjById(id);
            if (entity == null) continue;
            if (entity.getStatus().equals(NcrStatusEnum.STATUS_NEW.getValue())) {
                NcrArray.add(entity);
                continue;
            }
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u72b6\u6001\u5355\u636e\u624d\u53ef\u4ee5\u63a8\u9001!");
        }
        this.ncrService.pushedToBuyer((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u5230\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/pushedToSuppler"})
    @ResponseBody
    public ResponseResult<String> pushedToSuppler(@RequestBody List<Ncr> NcrArray) {
        if (CollectionUtils.isEmpty(NcrArray)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u5355\u636e");
        }
        for (Ncr item : NcrArray) {
            Ncr entity = (Ncr)this.ncrService.queryObjById(item.getId());
            if (entity == null) continue;
            if (entity.getStatus().equals(NcrStatusEnum.STATUS_NEW.getValue())) {
                if (StringUtils.isEmpty((String)item.getRectificationType())) {
                    throw new CommonException("\u5355\u636e\uff1a" + item.getNcrNumber() + "\u5904\u7406\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u5e03!");
                }
                if (!Constant.YES_INT.equals(entity.getSendStatus())) continue;
                throw new CommonException("\u5355\u636e\uff1a" + item.getNcrNumber() + "\u5df2\u7ecf\u53d1\u9001\u8fc7\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u9001!");
            }
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u72b6\u6001\u5355\u636e\u624d\u53ef\u4ee5\u53d1\u9001!");
        }
        this.ncrService.pushedToSuppler((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2NCR\u6570\u636e\u8868 \u4f9b\u5e94\u5546")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Ncr", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupplerByPage"})
    @ResponseBody
    public ResponseResult<PageView<Ncr>> findSupplerByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        NcrExample example = new NcrExample();
        example.setPageView((PageView<Ncr>)new PageView(pageNo, pageSize));
        NcrExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        criteria.andSendStatusEqualTo(Constant.YES_INT);
        criteria.andStatusNotEqualTo(NcrStatusEnum.STATUS_NEW.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView pageData = this.ncrService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/supplerResponse"})
    @ResponseBody
    public ResponseResult<String> supplerResponse(@RequestBody Ncr NcrEntity) {
        this.ncrService.supplerResponse((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), NcrEntity);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="NCR\u8d85\u671f\u672a\u56de\u590d\u9884\u8b66")
    @RequestMapping(value={"service/outTimeReply"})
    @ResponseBody
    public ResponseResult<String> outTimeReply() {
        this.ncrService.outTimeReply();
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u786e\u8ba4NCR\u5355\u636e")
    @RequestMapping(value={"service/supplierAcceptBill"})
    @ResponseBody
    public ResponseResult<String> supplierAcceptBill(@RequestBody List<Ncr> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u786e\u8ba4\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (Ncr item : list) {
            if (StringUtils.isEmpty((String)item.getCauseAnalysis())) {
                throw new CommonException("\u5355\u636e\uff1a" + item.getNcrNumber() + "\u539f\u56e0\u5206\u6790\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!");
            }
            if (StringUtils.isEmpty((String)item.getCorrectiveAnalysis())) {
                throw new CommonException("\u5355\u636e\uff1a" + item.getNcrNumber() + "\u7ea0\u6b63\u63aa\u65bd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!");
            }
            Assert.isNotNull((Object)item.getCompletionDate(), (String)("\u5355\u636e\uff1a" + item.getNcrNumber() + "\u5b8c\u6210\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u786e\u8ba4!"));
            item.setSupplierResponseTime(new Date());
            item.setStatus(NcrStatusEnum.STATUS_CONFIRM.getValue());
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            this.ncrService.supplerResponse((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), item);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody Ncr ncr) {
        if (StringUtils.isBlank((String)ncr.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.ncrService.addAttachment((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), ncr);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u540c\u610f\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/acceptToSuppler"})
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<Ncr> NcrArray) {
        if (CollectionUtils.isEmpty(NcrArray)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5355\u636e");
        }
        this.ncrService.acceptToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u62d2\u7edd\u4f9b\u5e94\u5546\u56de\u590d")
    @RequestMapping(value={"service/refuseToSuppler"})
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<Ncr> NcrArray) {
        if (CollectionUtils.isEmpty(NcrArray)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5355\u636e");
        }
        this.ncrService.refuseToSuppler(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), NcrArray);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165NCR\u5355\u636e Excel", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importNcrFromExcel"})
    public ResponseResult<String> importNcrFromExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            this.logger.info("\u5bfc\u5165NCR\u5355\u636e----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            this.logger.info("\u5bfc\u5165NCR\u5355\u636e----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        this.logger.info("\u5bfc\u5165NCR\u5355\u636etitleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        ArrayList<Ncr> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Ncr.class);
        }
        catch (Exception e) {
            this.logger.info("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.ncrService.importNcr(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165NCR\u5355\u636e Txt", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importNcrFromTxt"})
    public ResponseResult<String> importNcrFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"ncrQmsId", "ncrNumber", "ncrReport", "openTime", "isClose", "materialCode", "materialName", "mapNo", "quantity", "unqualifiedDescription", "unqualifiedType", "purCompanyName", "supCompanyName", "project", "responsible", "disposalWay", "disposalUser", "supCompanySapCode", "supCompanyName"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", Ncr.class, (String[])keys);
            List list = importTxt.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.ncrService.importNcr(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), (com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser(), list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }

    @ApiOperation(value="NCR\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d(Excel)", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("NCR\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"FRCASE", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        MultipleDateConverter dateConverter = new MultipleDateConverter();
        dateConverter.setDateFormat("yyyy-MM-dd");
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"ID", (String)"ncrQmsId", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"NCR\u7f16\u7801", (String)"ncrNumber", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"NCR\u62a5\u544a", (String)"ncrReport", (boolean)true));
        TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7acb\u65f6\u95f4", (String)"openTime");
        validDateFromKey.setToObjConverter((StrToObjConverter)dateConverter);
        validDateFromKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(validDateFromKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u5173\u95ed", (String)"isClose", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u4ee3\u7801", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u540d\u79f0", (String)"materialName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u63cf\u8ff0", (String)"unqualifiedDescription", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u7c7b\u578b", (String)"unqualifiedType", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d23\u4efb\u65b9", (String)"purCompanyName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d1f\u8d23\u4eba", (String)"responsible", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"disposalWay", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7f6e\u4eba\u5458", (String)"disposalUser", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546sap\u7f16\u7801", (String)"supCompanySapCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName", (boolean)true));
        return titleAndModelKeys;
    }

    @ApiOperation(value="NCR\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadReportExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(@ApiParam(value="NCR\u5355\u636eid", defaultValue="") @RequestParam(defaultValue="") String idArray, HttpServletResponse response) {
        try {
            this.logger.info("NCR\u5355\u636e\u5bfc\u51faExcel \u53c2\u6570" + idArray);
            NcrExample example = new NcrExample();
            if (StringUtils.isNotBlank((String)idArray)) {
                example.createCriteria().andIdIn((List)Arrays.asList(idArray.split(",")));
            }
            example.setOrderByClause(" UPDATE_TIME DESC");
            List ncrList = this.ncrService.queryAllObjByExample((IExample)example);
            block9: for (Ncr ncr : ncrList) {
                switch (ncr.getStatus()) {
                    case 1: {
                        ncr.setAttribute1("\u65b0\u589e");
                        continue block9;
                    }
                    case 2: {
                        ncr.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block9;
                    }
                    case 3: {
                        ncr.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block9;
                    }
                    case 4: {
                        ncr.setAttribute1("\u91c7\u8d2d\u786e\u8ba4");
                        continue block9;
                    }
                    case 5: {
                        ncr.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block9;
                    }
                }
                ncr.setAttribute1("\u4f5c\u5e9f");
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "NCR\u5355\u636e" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("NCR\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            MultipleDateConverter dateConverter = new MultipleDateConverter();
            dateConverter.setDateFormat("yyyy-MM-dd");
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"ncrNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"NCR\u62a5\u544a\u5355\u53f7", (String)"ncrReport"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u54c1\u5206\u7c7b", (String)"unqualifiedType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u73b0\u8c61", (String)"unqualifiedDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4", (String)"createTime");
            validDateFromKey.setToObjConverter((StrToObjConverter)dateConverter);
            validDateFromKey.setToStrConverter((ObjToStrConverter)dateConverter);
            titleAndModelKeys.add(validDateFromKey);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d1f\u8d23\u4eba", (String)"responsible"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"disposalUser"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("NCR\u5355\u636e\u5bfc\u51faExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)ncrList, (String)"NCR\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            ncrList = null;
            this.logger.info("NCR\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u91c7\u8d2dNCR\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/purdownloadReportExcel"})
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            NcrExample example = new NcrExample();
            NcrExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            ArrayList<String> companyCodeArray = new ArrayList<String>();
            List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
            if (CollectionUtils.isNotEmpty((Collection)companyList)) {
                for (Object company : companyList) {
                    companyCodeArray.add(company.getCompanySapCode());
                }
                criteria.andSupCompanySapCodeIn(companyCodeArray);
            }
            example.setOrderByClause(" UPDATE_TIME DESC");
            List ncrList = this.ncrService.queryAllObjByExample((IExample)example);
            block10: for (Ncr ncr : ncrList) {
                switch (ncr.getStatus()) {
                    case 1: {
                        ncr.setAttribute1("\u65b0\u589e");
                        continue block10;
                    }
                    case 2: {
                        ncr.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block10;
                    }
                    case 3: {
                        ncr.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block10;
                    }
                    case 4: {
                        ncr.setAttribute1("\u91c7\u8d2d\u786e\u8ba4");
                        continue block10;
                    }
                    case 5: {
                        ncr.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block10;
                    }
                }
                ncr.setAttribute1("\u4f5c\u5e9f");
            }
            this.logger.info("NCR\u5355\u636e\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + ncrList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "NCR\u5355\u636e\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("NCR\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"ncrNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"NCR\u62a5\u544a\u5355\u53f7", (String)"ncrReport"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"purCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u54c1\u5206\u7c7b", (String)"unqualifiedType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u73b0\u8c61", (String)"unqualifiedDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            MultipleDateConverter dateConverter = new MultipleDateConverter();
            dateConverter.setDateFormat("yyyy-MM-dd");
            TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4", (String)"createTime");
            validDateFromKey.setToObjConverter((StrToObjConverter)dateConverter);
            validDateFromKey.setToStrConverter((ObjToStrConverter)dateConverter);
            titleAndModelKeys.add(validDateFromKey);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d1f\u8d23\u4eba", (String)"responsible"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"disposalUser"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("NCR\u5355\u636eExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)ncrList, (String)"NCR\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            ncrList = null;
            this.logger.info("NCR\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546NCR\u5355\u636e\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/supdownloadReportExcel"})
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            NcrExample example = new NcrExample();
            NcrExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
            }
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
            criteria.andSendStatusEqualTo(Constant.YES_INT);
            criteria.andStatusNotEqualTo(NcrStatusEnum.STATUS_NEW.getValue());
            example.setOrderByClause(" UPDATE_TIME DESC");
            List ncrList = this.ncrService.queryAllObjByExample((IExample)example);
            block9: for (Ncr ncr : ncrList) {
                switch (ncr.getStatus()) {
                    case 1: {
                        ncr.setAttribute1("\u65b0\u589e");
                        continue block9;
                    }
                    case 2: {
                        ncr.setAttribute1("\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546");
                        continue block9;
                    }
                    case 3: {
                        ncr.setAttribute1("\u4f9b\u5e94\u5546\u56de\u590d");
                        continue block9;
                    }
                    case 4: {
                        ncr.setAttribute1("\u91c7\u8d2d\u786e\u8ba4");
                        continue block9;
                    }
                    case 5: {
                        ncr.setAttribute1("\u91c7\u8d2d\u62d2\u7edd");
                        continue block9;
                    }
                }
                ncr.setAttribute1("\u4f5c\u5e9f");
            }
            this.logger.info("NCR\u5355\u636e\u5bfc\u51faExcel \u6570\u636e\u6761\u6570" + ncrList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "NCR\u5355\u636e\u5e93\u5b58" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            this.logger.info("NCR\u5355\u636eExcel \u6587\u4ef6\u540d\u79f0" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5904\u7406\u65b9\u5f0f", (String)"rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"ncrNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"NCR\u62a5\u544a\u5355\u53f7", (String)"ncrReport"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"purCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u54c1\u5206\u7c7b", (String)"unqualifiedType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u73b0\u8c61", (String)"unqualifiedDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
            MultipleDateConverter dateConverter = new MultipleDateConverter();
            dateConverter.setDateFormat("yyyy-MM-dd");
            TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey((String)"\u65f6\u95f4", (String)"createTime");
            validDateFromKey.setToObjConverter((StrToObjConverter)dateConverter);
            validDateFromKey.setToStrConverter((ObjToStrConverter)dateConverter);
            titleAndModelKeys.add(validDateFromKey);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d1f\u8d23\u4eba", (String)"responsible"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"disposalUser"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u56de\u590d", (String)"supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62d2\u7edd\u539f\u56e0", (String)"purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"memo"));
            this.logger.info("NCR\u5355\u636eExcel \u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)ncrList, (String)"NCR\u5355\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            ncrList = null;
            this.logger.info("NCR\u5355\u636e\u5bfc\u51faExcel \u6587\u4ef6\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }
}

