
create table T_BASE_QUALITY_ANNEX_CONTACTS 
(
   ID                   VARCHAR2(32 CHAR)    not null,
   PROJECT_ID           VARCHAR2(32 CHAR),
   PUR_COMPANY_USER_ID  VARCHAR2(32 CHAR),
   PUR_COMPANY_ID       VARCHAR2(32 CHAR),
   PUR_COMPANY_NAME     VARCHAR2(255 CHAR),
   PUR_COMPANY_FULL_NAME VARCHAR2(255 CHAR),
   PUR_COMPANY_SRM_CODE VARCHAR2(255 CHAR),
   PUR_COMPANY_SAP_CODE VARCHAR2(255 CHAR),
   SUP_COMPANY_ID       VARCHAR2(32 CHAR),
   SUP_COMPANY_NAME     VARCHAR2(255 CHAR),
   SUP_COMPANY_FULL_NAME VARCHAR2(255 CHAR),
   SUP_COMPANY_SRM_CODE VARCHAR2(255 CHAR),
   SUP_COMPANY_SAP_CODE VARCHAR2(255 CHAR),
   DOCUMENT_NUMBER      VARCHAR2(255 CHAR),
   CREATE_BILL_TIME     DATE                 default SYSDATE,
   UPDATE_TIME          DATE,
   IS_ENABLE            NUMBER(7),
   BILL_STATUS          NUMBER(7),
   CREATE_BILL_NAME     VARCHAR2(255 CHAR),
   SEND_STATUS          NUMBER(7),
   PUR_SEND_TIME        DATE,
   SUP_SEND_TIME        DATE,
   SUP_CONFIRM_TIME     DATE,
   PUR_COMMIT_TIME      DATE,
   SUP_COMMIT_TIME      DATE,
   PUR_REMARKS          VARCHAR2(1000 CHAR),
   SUP_REMARKS          VARCHAR2(1000 CHAR),
   APPENDAGE_TYPE       VARCHAR2(255 CHAR),
   PUR_UPLOAD_NAME      VARCHAR2(2048 CHAR),
   SUP_REPLY_NAME       VARCHAR2(2048 CHAR),
   constraint PK_T_BASE_QUALITY_ANNEX_CONTAC primary key (ID)
);

comment on table T_BASE_QUALITY_ANNEX_CONTACTS is
'质量管理—附件往来表';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.ID is
'主键';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PROJECT_ID is
'项目ID';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_COMPANY_USER_ID is
'采购商用户ID';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_COMPANY_ID is
'采购公司ID';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_COMPANY_NAME is
'采购公司简称';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_COMPANY_FULL_NAME is
'采购公司全称';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_COMPANY_SRM_CODE is
'采购公司SRM编码';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_COMPANY_SAP_CODE is
'采购公司SAP编码';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_COMPANY_ID is
'供应商ID';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_COMPANY_NAME is
'供应商简称';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_COMPANY_FULL_NAME is
'供应商全称';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_COMPANY_SRM_CODE is
'供应商SRM编码';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_COMPANY_SAP_CODE is
'供应商SAP编码';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.DOCUMENT_NUMBER is
'单据号';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.CREATE_BILL_TIME is
'制单时间';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.UPDATE_TIME is
'更新时间';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.IS_ENABLE is
'记录是否可用(0=不可用，1=可用)';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.BILL_STATUS is
'单据状态(未回签=0,已回签=1,已审核=2,已驳回=3,已作废=4)';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.CREATE_BILL_NAME is
'创建人';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SEND_STATUS is
'发送状态(未发送=0,已发送=1)';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_SEND_TIME is
'采购公司发送时间';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_SEND_TIME is
'供应商发送时间';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_CONFIRM_TIME is
'供应商确认时间';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_COMMIT_TIME is
'采购公司提交资料时间';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_COMMIT_TIME is
'供应商提交资料时间';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_REMARKS is
'采购商备注';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_REMARKS is
'供应商备注';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.APPENDAGE_TYPE is
'附件类型';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.PUR_UPLOAD_NAME is
'采购商上传附件名称';

comment on column T_BASE_QUALITY_ANNEX_CONTACTS.SUP_REPLY_NAME is
'供应商回复附件名称';

