/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.query.business.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.query.business.command.CreateCommand;
import com.els.base.query.business.command.SwitchCommand;
import com.els.base.query.business.command.UpdateCommand;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.business.entity.QueryBusinessExample;
import com.els.base.query.business.service.QueryBusinessService;
import com.els.base.query.common.QueryConditionInvoker;
import com.els.base.query.condition.entity.QueryCondition;
import com.els.base.query.condition.entity.QueryConditionExample;
import com.els.base.query.condition.service.QueryConditionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e1a\u52a1")
@Controller
@RequestMapping(value={"queryBusiness"})
public class QueryBusinessController {
    @Resource
    protected QueryBusinessService queryBusinessService;
    @Resource
    protected QueryConditionService queryConditionService;
    @Resource
    protected QueryConditionInvoker queryConditionInvoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e1a\u52a1")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QueryBusiness queryBusiness) {
        CreateCommand cmd = new CreateCommand(queryBusiness);
        this.queryConditionInvoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e1a\u52a1")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QueryBusiness queryBusiness) {
        Assert.isNotBlank((String)queryBusiness.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        UpdateCommand cmd = new UpdateCommand(queryBusiness);
        this.queryConditionInvoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u505c\u7528\uff0c\u542f\u7528\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e1a\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="conditionFlag", required=true, value="\u5f00\u5173", paramType="query", dataType="String", defaultValue="0")})
    @RequestMapping(value={"service/switch"})
    @ResponseBody
    public ResponseResult<String> stop(@RequestBody(required=true) List<String> ids, @RequestParam(required=true, defaultValue="0") Integer conditionFlag) {
        Assert.isNotEmpty(ids, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        SwitchCommand cmd = new SwitchCommand(ids, conditionFlag);
        this.queryConditionInvoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eID\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"service/findByBusinessId"})
    @ResponseBody
    public ResponseResult<QueryBusiness> findByBusinessId(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryBusiness queryBusiness = (QueryBusiness)this.queryBusinessService.queryObjById(id);
        Assert.isNotNull((Object)queryBusiness, (String)"\u67e5\u8be2\u6761\u4ef6\u4e1a\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        List<QueryCondition> queryConditionList = this.queryConditionService.findByBusinessId(id);
        if (CollectionUtils.isNotEmpty(queryConditionList)) {
            queryBusiness.setQueryConditionList(queryConditionList);
        }
        return ResponseResult.success((Object)queryBusiness);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4e1a\u52a1\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"service/findByBusinessCode"})
    @ResponseBody
    public ResponseResult<QueryBusiness> findByBusinessCode(@RequestParam String businessCode) {
        Assert.isNotBlank((String)businessCode, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryBusiness queryBusiness = this.queryBusinessService.findByBusinessCode(businessCode);
        QueryConditionExample queryConditionExample = new QueryConditionExample();
        queryConditionExample.createCriteria().andParentIdIsNull().andQueryBusinessCodeEqualTo(businessCode).andQueryBusinessIdEqualTo(queryBusiness.getId());
        List queryConditionList = this.queryConditionService.queryAllObjByExample((IExample)queryConditionExample);
        if (CollectionUtils.isNotEmpty((Collection)queryConditionList)) {
            queryBusiness.setQueryConditionList(queryConditionList);
            for (QueryCondition queryCondition : queryConditionList) {
                QueryConditionExample example = new QueryConditionExample();
                example.createCriteria().andParentIdEqualTo(queryCondition.getId());
                List list = this.queryConditionService.queryAllObjByExample((IExample)example);
                queryCondition.setQueryConditionList(list);
            }
        }
        return ResponseResult.success((Object)queryBusiness);
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e1a\u52a1")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        QueryBusinessExample example = new QueryBusinessExample();
        example.createCriteria().andIdIn((List)ids);
        this.queryBusinessService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e1a\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QueryBusiness", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QueryBusiness>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QueryBusinessExample example = new QueryBusinessExample();
        example.setPageView((PageView<QueryBusiness>)new PageView(pageNo, pageSize));
        QueryBusinessExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.queryBusinessService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

