/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.query.condition.command;

import com.els.base.core.utils.Assert;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;
import com.els.base.query.condition.entity.QueryCondition;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateCommand
extends AbstractConditionCommand<String> {
    private QueryCondition queryCondition;

    public CreateCommand(QueryCondition queryCondition) {
        this.queryCondition = queryCondition;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {
        this.queryConditionInvoker = queryConditionInvoker;
        this.validData(this.queryCondition);
        this.processor(this.queryCondition);
        return null;
    }

    private void processor(QueryCondition queryCondition) {
        this.queryConditionInvoker.getQueryConditionService().addObj(queryCondition);
        List<QueryCondition> queryConditionList = queryCondition.getQueryConditionList();
        if (CollectionUtils.isNotEmpty(queryConditionList)) {
            for (QueryCondition condition : queryConditionList) {
                condition.setParentId(queryCondition.getId());
                condition.setQueryBusinessCode(queryCondition.getQueryBusinessCode());
                condition.setQueryBusinessId(queryCondition.getQueryBusinessId());
            }
        }
        this.queryConditionInvoker.getQueryConditionService().addAll(queryConditionList);
    }

    private void validData(QueryCondition queryCondition) {
        Assert.isNotNull((Object)queryCondition, (String)"\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        Assert.isNotBlank((String)queryCondition.getFieldName(), (String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        Assert.isNotBlank((String)queryCondition.getQueryBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        Assert.isNotBlank((String)queryCondition.getQueryBusinessId(), (String)"\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
    }
}

