package com.els.base.query.business.command;

import com.els.base.core.utils.Assert;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;

import java.util.Date;

/**
 * 创建业务查询条件
 * @author liuhf
 */
public class UpdateCommand extends AbstractConditionCommand<String> {

    private QueryBusiness queryBusiness;

    public UpdateCommand(QueryBusiness queryBusiness) {
        this.queryBusiness = queryBusiness;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {

        this.validData(queryBusiness);

        this.processor(queryBusiness);

        return null;
    }

    private void processor(QueryBusiness queryBusiness) {
        QueryBusiness oldQueryBusiness = this.queryConditionInvoker.getQueryBusinessService().queryObjById(queryBusiness.getId());
        oldQueryBusiness.setUpdateTime(new Date());

        //页面传回来的值
        oldQueryBusiness.setConditionDesc(queryBusiness.getConditionDesc());
        oldQueryBusiness.setConditionName(queryBusiness.getConditionName());
        oldQueryBusiness.setConditionType(queryBusiness.getConditionType());

        this.queryConditionInvoker.getQueryBusinessService().modifyObj(oldQueryBusiness);

    }

    private void validData(QueryBusiness queryBusiness) {
        Assert.isNotNull(queryBusiness, "业务模块信息不能为空，请检查！");
        Assert.isNotNull(queryBusiness.getId(), "业务模块ID不能为空，请检查！");
        Assert.isNotNull(queryBusiness.getConditionName(), "业务模块名称信息不能为空，请检查！");
        Assert.isNotNull(queryBusiness.getConditionType(), "业务模块类型信息不能为空，请检查！");
    }

}
