/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.query.condition.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.query.common.QueryConditionInvoker;
import com.els.base.query.condition.command.BatchCreateCommand;
import com.els.base.query.condition.command.CreateCommand;
import com.els.base.query.condition.entity.QueryCondition;
import com.els.base.query.condition.entity.QueryConditionExample;
import com.els.base.query.condition.service.QueryConditionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5")
@Controller
@RequestMapping(value={"queryCondition"})
public class QueryConditionController {
    @Resource
    protected QueryConditionService queryConditionService;
    @Resource
    protected QueryConditionInvoker queryConditionInvoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5")
    @RequestMapping(value={"service/batch/create"})
    @ResponseBody
    public ResponseResult<String> batchCreate(@RequestParam(required=true) String queryBusinessCode, @RequestBody(required=true) List<QueryCondition> queryConditionList) {
        BatchCreateCommand cmd = new BatchCreateCommand(queryConditionList, queryBusinessCode);
        this.queryConditionInvoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QueryCondition queryCondition) {
        CreateCommand cmd = new CreateCommand(queryCondition);
        this.queryConditionInvoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QueryCondition queryCondition) {
        Assert.isNotBlank((String)queryCondition.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.queryConditionService.modifyObj(queryCondition);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        QueryConditionExample example = new QueryConditionExample();
        example.createCriteria().andIdIn((List)ids);
        this.queryConditionService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QueryCondition", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QueryCondition>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QueryConditionExample example = new QueryConditionExample();
        example.setPageView((PageView<QueryCondition>)new PageView(pageNo, pageSize));
        QueryConditionExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.queryConditionService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2\u5168\u90e8\u6761\u4ef6")
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<QueryCondition>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        QueryConditionExample example = new QueryConditionExample();
        QueryConditionExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        String queryBusinessCode = wapper.getQueryParams().stream().filter(params -> "queryBusinessCode".equals(params.getProperty())).map(QueryParam::getValue).findAny().orElseGet(() -> null);
        Assert.isNotBlank((String)queryBusinessCode, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        List<QueryCondition> list = this.queryConditionService.findByBusinessCode(queryBusinessCode);
        return ResponseResult.success(list);
    }
}

