package com.els.base.query.business.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.business.entity.QueryBusinessExample;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;

import java.util.Date;
import java.util.List;

/**
 * 停用，启用 查询条件
 *
 * @author liuhf
 */
public class SwitchCommand extends AbstractConditionCommand<String> {

    List<String> ids;

    Integer conditionFlag = 0;

    public SwitchCommand(List<String> ids) {
        this.ids = ids;
    }

    public SwitchCommand(List<String> ids, Integer conditionFlag) {
        this.ids = ids;
        this.conditionFlag = conditionFlag;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {

        this.validData(ids);

        this.processor(ids);

        return null;
    }

    private void processor(List<String> ids) {

        QueryBusinessExample example = new QueryBusinessExample();
        example.createCriteria().andIdIn(ids);
        QueryBusiness queryBusiness = new QueryBusiness();
        queryBusiness.setConditionFlag(conditionFlag);

        this.queryConditionInvoker.getQueryBusinessService().updateByExampleSelective(queryBusiness, example);
    }

    private void validData(List<String> ids) {
        Assert.isNotEmpty(ids, "请选择一条操作的单据！");

        QueryBusinessExample example = new QueryBusinessExample();
        example.createCriteria()
                .andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT)
                .andConditionFlagEqualTo(conditionFlag);
        int count = this.queryConditionInvoker.getQueryBusinessService().countByExample(example);
        if (ids.size() != count) {
            if (Constant.NO_INT.equals(conditionFlag)) {
                throw new CommonException("您选的单据中存在已经停用的数据，不能重复停用，请检查！");
            } else {
                throw new CommonException("您选的单据中存在已经启用的数据，不能重复启用，请检查！");
            }
        }

    }

}
