/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.query.condition.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.query.condition.dao.QueryConditionMapper;
import com.els.base.query.condition.entity.QueryCondition;
import com.els.base.query.condition.entity.QueryConditionExample;
import com.els.base.query.condition.service.QueryConditionService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQueryConditionService")
public class QueryConditionServiceImpl
implements QueryConditionService {
    @Resource
    protected QueryConditionMapper queryConditionMapper;

    @Override
    @CacheEvict(value={"queryCondition"}, allEntries=true)
    public int insertBatch(List<QueryCondition> list) {
        Assert.isNotEmpty(list, (String)"\u6761\u4ef6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.queryConditionMapper.insertBatch(list);
    }

    @Override
    @Cacheable(value={"queryCondition"}, keyGenerator="redisKeyGenerator")
    public List<QueryCondition> findByBusinessCode(String businessCode) {
        Assert.isNotBlank((String)businessCode, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryConditionExample queryConditionExample = new QueryConditionExample();
        queryConditionExample.createCriteria().andQueryBusinessCodeEqualTo(businessCode);
        List<QueryCondition> queryConditions = this.queryConditionMapper.selectByExample(queryConditionExample);
        this.getQueryCondition(queryConditions);
        return queryConditions;
    }

    @Override
    @Cacheable(value={"queryCondition"}, keyGenerator="redisKeyGenerator")
    public List<QueryCondition> findByBusinessId(String businessId) {
        Assert.isNotBlank((String)businessId, (String)"\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryConditionExample queryConditionExample = new QueryConditionExample();
        queryConditionExample.createCriteria().andQueryBusinessIdEqualTo(businessId);
        List<QueryCondition> queryConditions = this.queryConditionMapper.selectByExample(queryConditionExample);
        this.getQueryCondition(queryConditions);
        return queryConditions;
    }

    private void getQueryCondition(List<QueryCondition> queryConditions) {
        if (CollectionUtils.isNotEmpty(queryConditions)) {
            for (QueryCondition queryCondition : queryConditions) {
                if (!StringUtils.isNotBlank((String)queryCondition.getParentId())) continue;
                QueryConditionExample temp = new QueryConditionExample();
                temp.createCriteria().andParentIdEqualTo(queryCondition.getParentId());
                List<QueryCondition> queryConditions1 = this.queryConditionMapper.selectByExample(temp);
                queryCondition.setQueryConditionList(queryConditions1);
            }
        }
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    public void addObj(QueryCondition t) {
        this.queryConditionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"queryCondition"}, allEntries=true)
    public void addAll(List<QueryCondition> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.queryConditionMapper.insertBatch(list);
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    public void deleteObjById(String id) {
        this.queryConditionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    public void deleteByExample(QueryConditionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.queryConditionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    public void modifyObj(QueryCondition t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.queryConditionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"queryCondition"}, keyGenerator="redisKeyGenerator")
    public QueryCondition queryObjById(String id) {
        return this.queryConditionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"queryCondition"}, keyGenerator="redisKeyGenerator")
    public List<QueryCondition> queryAllObjByExample(QueryConditionExample example) {
        return this.queryConditionMapper.selectByExample(example);
    }

    @Cacheable(value={"queryCondition"}, keyGenerator="redisKeyGenerator")
    public PageView<QueryCondition> queryObjByPage(QueryConditionExample example) {
        PageView<QueryCondition> pageView = example.getPageView();
        pageView.setQueryResult(this.queryConditionMapper.selectByExampleByPage(example));
        return pageView;
    }
}

