/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.query.business.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.business.entity.QueryBusinessExample;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;
import java.util.List;

public class SwitchCommand
extends AbstractConditionCommand<String> {
    List<String> ids;
    Integer conditionFlag = 0;

    public SwitchCommand(List<String> ids) {
        this.ids = ids;
    }

    public SwitchCommand(List<String> ids, Integer conditionFlag) {
        this.ids = ids;
        this.conditionFlag = conditionFlag;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {
        this.validData(this.ids);
        this.processor(this.ids);
        return null;
    }

    private void processor(List<String> ids) {
        QueryBusinessExample example = new QueryBusinessExample();
        example.createCriteria().andIdIn((List)ids);
        QueryBusiness queryBusiness = new QueryBusiness();
        queryBusiness.setConditionFlag(this.conditionFlag);
        this.queryConditionInvoker.getQueryBusinessService().updateByExampleSelective(queryBusiness, example);
    }

    private void validData(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u64cd\u4f5c\u7684\u5355\u636e\uff01");
        QueryBusinessExample example = new QueryBusinessExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andConditionFlagEqualTo(this.conditionFlag);
        int count = this.queryConditionInvoker.getQueryBusinessService().countByExample(example);
        if (ids.size() != count) {
            if (Constant.NO_INT.equals(this.conditionFlag)) {
                throw new CommonException("\u60a8\u9009\u7684\u5355\u636e\u4e2d\u5b58\u5728\u5df2\u7ecf\u505c\u7528\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u505c\u7528\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            throw new CommonException("\u60a8\u9009\u7684\u5355\u636e\u4e2d\u5b58\u5728\u5df2\u7ecf\u542f\u7528\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

