package com.els.base.query.condition.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.query.condition.dao.QueryConditionMapper;
import com.els.base.query.condition.entity.QueryCondition;
import com.els.base.query.condition.entity.QueryConditionExample;
import com.els.base.query.condition.service.QueryConditionService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultQueryConditionService")
public class QueryConditionServiceImpl implements QueryConditionService {
    @Resource
    protected QueryConditionMapper queryConditionMapper;

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    @Override
    public int insertBatch(List<QueryCondition> list) {
        Assert.isNotEmpty(list,"条件列表不能为空！");
        return this.queryConditionMapper.insertBatch(list);
    }

    @Cacheable(value="queryCondition", keyGenerator="redisKeyGenerator")
    @Override
    public List<QueryCondition> findByBusinessCode(String businessCode) {

        Assert.isNotBlank(businessCode,"业务编码不能为空！");
        QueryConditionExample queryConditionExample = new QueryConditionExample();
        queryConditionExample.createCriteria().andQueryBusinessCodeEqualTo(businessCode);

        //TODO 待优化，写成sql递归

        List<QueryCondition> queryConditions = queryConditionMapper.selectByExample(queryConditionExample);
        getQueryCondition(queryConditions);
        return queryConditions;
    }

    @Cacheable(value="queryCondition", keyGenerator="redisKeyGenerator")
    @Override
    public List<QueryCondition> findByBusinessId(String businessId) {
        Assert.isNotBlank(businessId,"业务ID不能为空！");
        QueryConditionExample queryConditionExample = new QueryConditionExample();
        queryConditionExample.createCriteria().andQueryBusinessIdEqualTo(businessId);

        //TODO 待优化，写成sql递归

        List<QueryCondition> queryConditions = queryConditionMapper.selectByExample(queryConditionExample);
        getQueryCondition(queryConditions);
        return queryConditions;
    }

    private void getQueryCondition(List<QueryCondition> queryConditions) {
        if(CollectionUtils.isNotEmpty(queryConditions)){
            for (QueryCondition queryCondition : queryConditions) {
                if(StringUtils.isNotBlank(queryCondition.getParentId())){
                    QueryConditionExample temp = new QueryConditionExample();
                    temp.createCriteria().andParentIdEqualTo(queryCondition.getParentId());
                    List<QueryCondition> queryConditions1 = queryConditionMapper.selectByExample(temp);
                    queryCondition.setQueryConditionList(queryConditions1);
                }
            }
        }
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    @Override
    public void addObj(QueryCondition t) {
        this.queryConditionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"queryCondition"}, allEntries=true)
    @Override
    public void addAll(List<QueryCondition> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.queryConditionMapper.insertBatch(list);
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.queryConditionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    @Override
    public void deleteByExample(QueryConditionExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.queryConditionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"queryCondition"}, allEntries=true)
    @Override
    public void modifyObj(QueryCondition t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.queryConditionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="queryCondition", keyGenerator="redisKeyGenerator")
    @Override
    public QueryCondition queryObjById(String id) {
        return this.queryConditionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="queryCondition", keyGenerator="redisKeyGenerator")
    @Override
    public List<QueryCondition> queryAllObjByExample(QueryConditionExample example) {
        return this.queryConditionMapper.selectByExample(example);
    }

    @Cacheable(value="queryCondition", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QueryCondition> queryObjByPage(QueryConditionExample example) {
        PageView<QueryCondition> pageView = example.getPageView();
        pageView.setQueryResult(this.queryConditionMapper.selectByExampleByPage(example));
        return pageView;
    }
}