package com.els.base.query.business.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.query.business.dao.QueryBusinessMapper;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.business.entity.QueryBusinessExample;
import com.els.base.query.business.service.QueryBusinessService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultQueryBusinessService")
public class QueryBusinessServiceImpl implements QueryBusinessService {
    @Resource
    protected QueryBusinessMapper queryBusinessMapper;

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    @Override
    public int updateByExampleSelective(QueryBusiness record, QueryBusinessExample example) {
        Assert.isNotNull(record);
        return queryBusinessMapper.updateByExampleSelective(record,example);
    }

    @Cacheable(value="queryBusiness", keyGenerator="redisKeyGenerator")
    @Override
    public int countByExample(QueryBusinessExample example) {
        return this.countByExample(example);
    }

    @Cacheable(value="queryBusiness", keyGenerator="redisKeyGenerator")
    @Override
    public QueryBusiness findByBusinessCode(String businessCode) {
        QueryBusinessExample example = new QueryBusinessExample();
        example.createCriteria()
                .andConditionFlagEqualTo(Constant.YES_INT)
                .andIsEnableEqualTo(Constant.YES_INT)
                .andConditionCodeEqualTo(businessCode);
        List<QueryBusiness> queryBusinesses = this.queryBusinessMapper.selectByExample(example);
        if(CollectionUtils.isNotEmpty(queryBusinesses)){
            return queryBusinesses.get(0);
        }else{
            return null;
        }
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    @Override
    public void addObj(QueryBusiness t) {
        this.queryBusinessMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    @Override
    public void addAll(List<QueryBusiness> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.queryBusinessMapper.insertBatch(list);
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.queryBusinessMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    @Override
    public void deleteByExample(QueryBusinessExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.queryBusinessMapper.deleteByExample(example);
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    @Override
    public void modifyObj(QueryBusiness t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.queryBusinessMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="queryBusiness", keyGenerator="redisKeyGenerator")
    @Override
    public QueryBusiness queryObjById(String id) {
        return this.queryBusinessMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="queryBusiness", keyGenerator="redisKeyGenerator")
    @Override
    public List<QueryBusiness> queryAllObjByExample(QueryBusinessExample example) {
        return this.queryBusinessMapper.selectByExample(example);
    }

    @Cacheable(value="queryBusiness", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<QueryBusiness> queryObjByPage(QueryBusinessExample example) {
        PageView<QueryBusiness> pageView = example.getPageView();
        pageView.setQueryResult(this.queryBusinessMapper.selectByExampleByPage(example));
        return pageView;
    }
}