package com.els.base.query.condition.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QueryConditionExample extends AbstractExample<QueryCondition> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<QueryCondition> pageView = new PageView<QueryCondition>(1, 10);

    private static final long serialVersionUID = 1L;

    public QueryConditionExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<QueryCondition> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<QueryCondition> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andParentIdIsNull() {
            addCriterion("PARENT_ID is null");
            return (Criteria) this;
        }

        public Criteria andParentIdIsNotNull() {
            addCriterion("PARENT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andParentIdEqualTo(String value) {
            addCriterion("PARENT_ID =", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotEqualTo(String value) {
            addCriterion("PARENT_ID <>", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdGreaterThan(String value) {
            addCriterion("PARENT_ID >", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdGreaterThanOrEqualTo(String value) {
            addCriterion("PARENT_ID >=", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdLessThan(String value) {
            addCriterion("PARENT_ID <", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdLessThanOrEqualTo(String value) {
            addCriterion("PARENT_ID <=", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdLike(String value) {
            addCriterion("PARENT_ID like", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotLike(String value) {
            addCriterion("PARENT_ID not like", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdIn(List<String> values) {
            addCriterion("PARENT_ID in", values, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotIn(List<String> values) {
            addCriterion("PARENT_ID not in", values, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdBetween(String value1, String value2) {
            addCriterion("PARENT_ID between", value1, value2, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotBetween(String value1, String value2) {
            addCriterion("PARENT_ID not between", value1, value2, "parentId");
            return (Criteria) this;
        }

        public Criteria andFieldNameIsNull() {
            addCriterion("FIELD_NAME is null");
            return (Criteria) this;
        }

        public Criteria andFieldNameIsNotNull() {
            addCriterion("FIELD_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andFieldNameEqualTo(String value) {
            addCriterion("FIELD_NAME =", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameNotEqualTo(String value) {
            addCriterion("FIELD_NAME <>", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameGreaterThan(String value) {
            addCriterion("FIELD_NAME >", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_NAME >=", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameLessThan(String value) {
            addCriterion("FIELD_NAME <", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameLessThanOrEqualTo(String value) {
            addCriterion("FIELD_NAME <=", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameLike(String value) {
            addCriterion("FIELD_NAME like", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameNotLike(String value) {
            addCriterion("FIELD_NAME not like", value, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameIn(List<String> values) {
            addCriterion("FIELD_NAME in", values, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameNotIn(List<String> values) {
            addCriterion("FIELD_NAME not in", values, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameBetween(String value1, String value2) {
            addCriterion("FIELD_NAME between", value1, value2, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldNameNotBetween(String value1, String value2) {
            addCriterion("FIELD_NAME not between", value1, value2, "fieldName");
            return (Criteria) this;
        }

        public Criteria andFieldCodeIsNull() {
            addCriterion("FIELD_CODE is null");
            return (Criteria) this;
        }

        public Criteria andFieldCodeIsNotNull() {
            addCriterion("FIELD_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andFieldCodeEqualTo(String value) {
            addCriterion("FIELD_CODE =", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeNotEqualTo(String value) {
            addCriterion("FIELD_CODE <>", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeGreaterThan(String value) {
            addCriterion("FIELD_CODE >", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_CODE >=", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeLessThan(String value) {
            addCriterion("FIELD_CODE <", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeLessThanOrEqualTo(String value) {
            addCriterion("FIELD_CODE <=", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeLike(String value) {
            addCriterion("FIELD_CODE like", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeNotLike(String value) {
            addCriterion("FIELD_CODE not like", value, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeIn(List<String> values) {
            addCriterion("FIELD_CODE in", values, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeNotIn(List<String> values) {
            addCriterion("FIELD_CODE not in", values, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeBetween(String value1, String value2) {
            addCriterion("FIELD_CODE between", value1, value2, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldCodeNotBetween(String value1, String value2) {
            addCriterion("FIELD_CODE not between", value1, value2, "fieldCode");
            return (Criteria) this;
        }

        public Criteria andFieldDescIsNull() {
            addCriterion("FIELD_DESC is null");
            return (Criteria) this;
        }

        public Criteria andFieldDescIsNotNull() {
            addCriterion("FIELD_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andFieldDescEqualTo(String value) {
            addCriterion("FIELD_DESC =", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescNotEqualTo(String value) {
            addCriterion("FIELD_DESC <>", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescGreaterThan(String value) {
            addCriterion("FIELD_DESC >", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_DESC >=", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescLessThan(String value) {
            addCriterion("FIELD_DESC <", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescLessThanOrEqualTo(String value) {
            addCriterion("FIELD_DESC <=", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescLike(String value) {
            addCriterion("FIELD_DESC like", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescNotLike(String value) {
            addCriterion("FIELD_DESC not like", value, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescIn(List<String> values) {
            addCriterion("FIELD_DESC in", values, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescNotIn(List<String> values) {
            addCriterion("FIELD_DESC not in", values, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescBetween(String value1, String value2) {
            addCriterion("FIELD_DESC between", value1, value2, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldDescNotBetween(String value1, String value2) {
            addCriterion("FIELD_DESC not between", value1, value2, "fieldDesc");
            return (Criteria) this;
        }

        public Criteria andFieldTypeIsNull() {
            addCriterion("FIELD_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andFieldTypeIsNotNull() {
            addCriterion("FIELD_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andFieldTypeEqualTo(String value) {
            addCriterion("FIELD_TYPE =", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeNotEqualTo(String value) {
            addCriterion("FIELD_TYPE <>", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeGreaterThan(String value) {
            addCriterion("FIELD_TYPE >", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_TYPE >=", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeLessThan(String value) {
            addCriterion("FIELD_TYPE <", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeLessThanOrEqualTo(String value) {
            addCriterion("FIELD_TYPE <=", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeLike(String value) {
            addCriterion("FIELD_TYPE like", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeNotLike(String value) {
            addCriterion("FIELD_TYPE not like", value, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeIn(List<String> values) {
            addCriterion("FIELD_TYPE in", values, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeNotIn(List<String> values) {
            addCriterion("FIELD_TYPE not in", values, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeBetween(String value1, String value2) {
            addCriterion("FIELD_TYPE between", value1, value2, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldTypeNotBetween(String value1, String value2) {
            addCriterion("FIELD_TYPE not between", value1, value2, "fieldType");
            return (Criteria) this;
        }

        public Criteria andFieldValueIsNull() {
            addCriterion("FIELD_VALUE is null");
            return (Criteria) this;
        }

        public Criteria andFieldValueIsNotNull() {
            addCriterion("FIELD_VALUE is not null");
            return (Criteria) this;
        }

        public Criteria andFieldValueEqualTo(String value) {
            addCriterion("FIELD_VALUE =", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueNotEqualTo(String value) {
            addCriterion("FIELD_VALUE <>", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueGreaterThan(String value) {
            addCriterion("FIELD_VALUE >", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_VALUE >=", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueLessThan(String value) {
            addCriterion("FIELD_VALUE <", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueLessThanOrEqualTo(String value) {
            addCriterion("FIELD_VALUE <=", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueLike(String value) {
            addCriterion("FIELD_VALUE like", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueNotLike(String value) {
            addCriterion("FIELD_VALUE not like", value, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueIn(List<String> values) {
            addCriterion("FIELD_VALUE in", values, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueNotIn(List<String> values) {
            addCriterion("FIELD_VALUE not in", values, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueBetween(String value1, String value2) {
            addCriterion("FIELD_VALUE between", value1, value2, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andFieldValueNotBetween(String value1, String value2) {
            addCriterion("FIELD_VALUE not between", value1, value2, "fieldValue");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdIsNull() {
            addCriterion("QUERY_BUSINESS_ID is null");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdIsNotNull() {
            addCriterion("QUERY_BUSINESS_ID is not null");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_ID =", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdNotEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_ID <>", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdGreaterThan(String value) {
            addCriterion("QUERY_BUSINESS_ID >", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdGreaterThanOrEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_ID >=", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdLessThan(String value) {
            addCriterion("QUERY_BUSINESS_ID <", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdLessThanOrEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_ID <=", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdLike(String value) {
            addCriterion("QUERY_BUSINESS_ID like", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdNotLike(String value) {
            addCriterion("QUERY_BUSINESS_ID not like", value, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdIn(List<String> values) {
            addCriterion("QUERY_BUSINESS_ID in", values, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdNotIn(List<String> values) {
            addCriterion("QUERY_BUSINESS_ID not in", values, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdBetween(String value1, String value2) {
            addCriterion("QUERY_BUSINESS_ID between", value1, value2, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessIdNotBetween(String value1, String value2) {
            addCriterion("QUERY_BUSINESS_ID not between", value1, value2, "queryBusinessId");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeIsNull() {
            addCriterion("QUERY_BUSINESS_CODE is null");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeIsNotNull() {
            addCriterion("QUERY_BUSINESS_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_CODE =", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeNotEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_CODE <>", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeGreaterThan(String value) {
            addCriterion("QUERY_BUSINESS_CODE >", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeGreaterThanOrEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_CODE >=", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeLessThan(String value) {
            addCriterion("QUERY_BUSINESS_CODE <", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeLessThanOrEqualTo(String value) {
            addCriterion("QUERY_BUSINESS_CODE <=", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeLike(String value) {
            addCriterion("QUERY_BUSINESS_CODE like", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeNotLike(String value) {
            addCriterion("QUERY_BUSINESS_CODE not like", value, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeIn(List<String> values) {
            addCriterion("QUERY_BUSINESS_CODE in", values, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeNotIn(List<String> values) {
            addCriterion("QUERY_BUSINESS_CODE not in", values, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeBetween(String value1, String value2) {
            addCriterion("QUERY_BUSINESS_CODE between", value1, value2, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andQueryBusinessCodeNotBetween(String value1, String value2) {
            addCriterion("QUERY_BUSINESS_CODE not between", value1, value2, "queryBusinessCode");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorIsNull() {
            addCriterion("FIELD_OPERATOR is null");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorIsNotNull() {
            addCriterion("FIELD_OPERATOR is not null");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorEqualTo(String value) {
            addCriterion("FIELD_OPERATOR =", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorNotEqualTo(String value) {
            addCriterion("FIELD_OPERATOR <>", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorGreaterThan(String value) {
            addCriterion("FIELD_OPERATOR >", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_OPERATOR >=", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorLessThan(String value) {
            addCriterion("FIELD_OPERATOR <", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorLessThanOrEqualTo(String value) {
            addCriterion("FIELD_OPERATOR <=", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorLike(String value) {
            addCriterion("FIELD_OPERATOR like", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorNotLike(String value) {
            addCriterion("FIELD_OPERATOR not like", value, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorIn(List<String> values) {
            addCriterion("FIELD_OPERATOR in", values, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorNotIn(List<String> values) {
            addCriterion("FIELD_OPERATOR not in", values, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorBetween(String value1, String value2) {
            addCriterion("FIELD_OPERATOR between", value1, value2, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldOperatorNotBetween(String value1, String value2) {
            addCriterion("FIELD_OPERATOR not between", value1, value2, "fieldOperator");
            return (Criteria) this;
        }

        public Criteria andFieldUrlIsNull() {
            addCriterion("FIELD_URL is null");
            return (Criteria) this;
        }

        public Criteria andFieldUrlIsNotNull() {
            addCriterion("FIELD_URL is not null");
            return (Criteria) this;
        }

        public Criteria andFieldUrlEqualTo(String value) {
            addCriterion("FIELD_URL =", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlNotEqualTo(String value) {
            addCriterion("FIELD_URL <>", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlGreaterThan(String value) {
            addCriterion("FIELD_URL >", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_URL >=", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlLessThan(String value) {
            addCriterion("FIELD_URL <", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlLessThanOrEqualTo(String value) {
            addCriterion("FIELD_URL <=", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlLike(String value) {
            addCriterion("FIELD_URL like", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlNotLike(String value) {
            addCriterion("FIELD_URL not like", value, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlIn(List<String> values) {
            addCriterion("FIELD_URL in", values, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlNotIn(List<String> values) {
            addCriterion("FIELD_URL not in", values, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlBetween(String value1, String value2) {
            addCriterion("FIELD_URL between", value1, value2, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldUrlNotBetween(String value1, String value2) {
            addCriterion("FIELD_URL not between", value1, value2, "fieldUrl");
            return (Criteria) this;
        }

        public Criteria andFieldPropIsNull() {
            addCriterion("FIELD_PROP is null");
            return (Criteria) this;
        }

        public Criteria andFieldPropIsNotNull() {
            addCriterion("FIELD_PROP is not null");
            return (Criteria) this;
        }

        public Criteria andFieldPropEqualTo(String value) {
            addCriterion("FIELD_PROP =", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropNotEqualTo(String value) {
            addCriterion("FIELD_PROP <>", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropGreaterThan(String value) {
            addCriterion("FIELD_PROP >", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_PROP >=", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropLessThan(String value) {
            addCriterion("FIELD_PROP <", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropLessThanOrEqualTo(String value) {
            addCriterion("FIELD_PROP <=", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropLike(String value) {
            addCriterion("FIELD_PROP like", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropNotLike(String value) {
            addCriterion("FIELD_PROP not like", value, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropIn(List<String> values) {
            addCriterion("FIELD_PROP in", values, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropNotIn(List<String> values) {
            addCriterion("FIELD_PROP not in", values, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropBetween(String value1, String value2) {
            addCriterion("FIELD_PROP between", value1, value2, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldPropNotBetween(String value1, String value2) {
            addCriterion("FIELD_PROP not between", value1, value2, "fieldProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropIsNull() {
            addCriterion("FIELD_SHOW_PROP is null");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropIsNotNull() {
            addCriterion("FIELD_SHOW_PROP is not null");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP =", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropNotEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP <>", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropGreaterThan(String value) {
            addCriterion("FIELD_SHOW_PROP >", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP >=", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropLessThan(String value) {
            addCriterion("FIELD_SHOW_PROP <", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropLessThanOrEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP <=", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropLike(String value) {
            addCriterion("FIELD_SHOW_PROP like", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropNotLike(String value) {
            addCriterion("FIELD_SHOW_PROP not like", value, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropIn(List<String> values) {
            addCriterion("FIELD_SHOW_PROP in", values, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropNotIn(List<String> values) {
            addCriterion("FIELD_SHOW_PROP not in", values, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropBetween(String value1, String value2) {
            addCriterion("FIELD_SHOW_PROP between", value1, value2, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropNotBetween(String value1, String value2) {
            addCriterion("FIELD_SHOW_PROP not between", value1, value2, "fieldShowProp");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueIsNull() {
            addCriterion("FIELD_SHOW_PROP_VALUE is null");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueIsNotNull() {
            addCriterion("FIELD_SHOW_PROP_VALUE is not null");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE =", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueNotEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE <>", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueGreaterThan(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE >", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueGreaterThanOrEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE >=", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueLessThan(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE <", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueLessThanOrEqualTo(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE <=", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueLike(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE like", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueNotLike(String value) {
            addCriterion("FIELD_SHOW_PROP_VALUE not like", value, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueIn(List<String> values) {
            addCriterion("FIELD_SHOW_PROP_VALUE in", values, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueNotIn(List<String> values) {
            addCriterion("FIELD_SHOW_PROP_VALUE not in", values, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueBetween(String value1, String value2) {
            addCriterion("FIELD_SHOW_PROP_VALUE between", value1, value2, "fieldShowPropValue");
            return (Criteria) this;
        }

        public Criteria andFieldShowPropValueNotBetween(String value1, String value2) {
            addCriterion("FIELD_SHOW_PROP_VALUE not between", value1, value2, "fieldShowPropValue");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}