/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.query.condition.command;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;
import com.els.base.query.condition.entity.QueryCondition;
import com.els.base.query.condition.entity.QueryConditionExample;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class BatchCreateCommand
extends AbstractConditionCommand<String> {
    private List<QueryCondition> queryConditionList;
    private String queryBusinessCode;

    public BatchCreateCommand(List<QueryCondition> queryConditionList, String queryBusinessCode) {
        this.queryConditionList = queryConditionList;
        this.queryBusinessCode = queryBusinessCode;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {
        this.queryConditionInvoker = queryConditionInvoker;
        this.validData(this.queryConditionList, this.queryBusinessCode);
        this.processor(this.queryConditionList);
        return null;
    }

    private void processor(List<QueryCondition> queryConditions) {
        QueryConditionExample queryConditionExample = new QueryConditionExample();
        queryConditionExample.createCriteria().andQueryBusinessCodeEqualTo(this.queryBusinessCode);
        this.queryConditionInvoker.getQueryConditionService().deleteByExample((IExample)queryConditionExample);
        QueryBusiness byBusinessCode = this.queryConditionInvoker.getQueryBusinessService().findByBusinessCode(this.queryBusinessCode);
        Assert.isNotNull((Object)byBusinessCode, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\uff01");
        for (QueryCondition condition : queryConditions) {
            condition.setId(UUIDGenerator.generateUUID());
            condition.setQueryBusinessCode(this.queryBusinessCode);
            condition.setQueryBusinessId(byBusinessCode.getId());
            List<QueryCondition> queryConditionList = condition.getQueryConditionList();
            if (!CollectionUtils.isNotEmpty(queryConditionList)) continue;
            for (QueryCondition queryCondition : queryConditionList) {
                queryCondition.setId(UUIDGenerator.generateUUID());
                queryCondition.setQueryBusinessCode(this.queryBusinessCode);
                queryCondition.setParentId(condition.getId());
                queryCondition.setQueryBusinessId(byBusinessCode.getId());
            }
        }
        this.queryConditionInvoker.getQueryConditionService().insertBatch(queryConditions);
        for (QueryCondition queryCondition : queryConditions) {
            if (!CollectionUtils.isNotEmpty(queryCondition.getQueryConditionList())) continue;
            this.queryConditionInvoker.getQueryConditionService().insertBatch(queryCondition.getQueryConditionList());
        }
    }

    private void validData(List<QueryCondition> queryConditionList, String queryBusinessCode) {
        Assert.isNotEmpty(queryConditionList, (String)"\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        Assert.isNotBlank((String)queryBusinessCode, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (QueryCondition queryCondition : queryConditionList) {
            Assert.isNotBlank((String)queryCondition.getFieldName(), (String)"\u5b57\u6bb5\u663e\u793a\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            Assert.isNotBlank((String)queryCondition.getFieldCode(), (String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            Assert.isNotBlank((String)queryCondition.getFieldOperator(), (String)"\u64cd\u4f5c\u7b26\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            Assert.isNotBlank((String)queryCondition.getFieldType(), (String)"\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

