/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.query.business.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.query.business.dao.QueryBusinessMapper;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.business.entity.QueryBusinessExample;
import com.els.base.query.business.service.QueryBusinessService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQueryBusinessService")
public class QueryBusinessServiceImpl
implements QueryBusinessService {
    @Resource
    protected QueryBusinessMapper queryBusinessMapper;

    @Override
    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    public int updateByExampleSelective(QueryBusiness record, QueryBusinessExample example) {
        Assert.isNotNull((Object)record);
        return this.queryBusinessMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"queryBusiness"}, keyGenerator="redisKeyGenerator")
    public int countByExample(QueryBusinessExample example) {
        return this.countByExample(example);
    }

    @Override
    @Cacheable(value={"queryBusiness"}, keyGenerator="redisKeyGenerator")
    public QueryBusiness findByBusinessCode(String businessCode) {
        QueryBusinessExample example = new QueryBusinessExample();
        example.createCriteria().andConditionFlagEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT).andConditionCodeEqualTo(businessCode);
        List<QueryBusiness> queryBusinesses = this.queryBusinessMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(queryBusinesses)) {
            return queryBusinesses.get(0);
        }
        return null;
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    public void addObj(QueryBusiness t) {
        this.queryBusinessMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    public void addAll(List<QueryBusiness> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.queryBusinessMapper.insertBatch(list);
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    public void deleteObjById(String id) {
        this.queryBusinessMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    public void deleteByExample(QueryBusinessExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.queryBusinessMapper.deleteByExample(example);
    }

    @CacheEvict(value={"queryBusiness"}, allEntries=true)
    public void modifyObj(QueryBusiness t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.queryBusinessMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"queryBusiness"}, keyGenerator="redisKeyGenerator")
    public QueryBusiness queryObjById(String id) {
        return this.queryBusinessMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"queryBusiness"}, keyGenerator="redisKeyGenerator")
    public List<QueryBusiness> queryAllObjByExample(QueryBusinessExample example) {
        return this.queryBusinessMapper.selectByExample(example);
    }

    @Cacheable(value={"queryBusiness"}, keyGenerator="redisKeyGenerator")
    public PageView<QueryBusiness> queryObjByPage(QueryBusinessExample example) {
        PageView<QueryBusiness> pageView = example.getPageView();
        pageView.setQueryResult(this.queryBusinessMapper.selectByExampleByPage(example));
        return pageView;
    }
}

