package com.els.base.query.business.command;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;

import java.util.Date;

/**
 * 创建业务查询条件
 * @author liuhf
 */
public class CreateCommand extends AbstractConditionCommand<String> {

    private QueryBusiness queryBusiness;

    public CreateCommand(QueryBusiness queryBusiness) {
        this.queryBusiness = queryBusiness;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {

        this.validData(queryBusiness);

        this.processor(queryBusiness);

        return null;
    }

    private void processor(QueryBusiness queryBusiness) {
        queryBusiness.setCreateTime(new Date());
        queryBusiness.setUpdateTime(new Date());
        queryBusiness.setConditionFlag(Constant.YES_INT);
        queryBusiness.setIsEnable(Constant.YES_INT);
        queryBusiness.setConditionCode(this.queryConditionInvoker.getGenerateCodeService().getNextCode("QUERY_BUSINESS_CODE"));
        this.queryConditionInvoker.getQueryBusinessService().addObj(queryBusiness);
    }

    private void validData(QueryBusiness queryBusiness) {
        Assert.isNotNull(queryBusiness, "业务模块信息不能为空，请检查！");
        Assert.isNotNull(queryBusiness.getConditionName(), "业务模块名称信息不能为空，请检查！");
        Assert.isNotNull(queryBusiness.getConditionType(), "业务模块类型信息不能为空，请检查！");
    }

}
