package com.els.base.query.common;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.query.business.service.QueryBusinessService;
import com.els.base.query.condition.service.QueryConditionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Component
public class QueryConditionInvoker {

    private static Logger logger = LoggerFactory.getLogger(QueryConditionInvoker.class);
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private QueryConditionService queryConditionService;
    @Resource
    private QueryBusinessService queryBusinessService;

    @Transactional
    public <Result> Result invoke(AbstractConditionCommand<Result> command) {
        logger.debug("执行命令[{}]", command.getClass().getName());

        // 此处可添加执行前的统一操作
        // 例如身份认证
        command.setQueryConditionInvoker(this);

        Result result = command.execute(this);

        // TODO 此处可添加执行后的操作
        // 例如消息发送

        return result;
    }

    public GenerateCodeService getGenerateCodeService() {
        return generateCodeService;
    }

    public void setGenerateCodeService(GenerateCodeService generateCodeService) {
        this.generateCodeService = generateCodeService;
    }

    public QueryConditionService getQueryConditionService() {
        return queryConditionService;
    }

    public void setQueryConditionService(QueryConditionService queryConditionService) {
        this.queryConditionService = queryConditionService;
    }

    public QueryBusinessService getQueryBusinessService() {
        return queryBusinessService;
    }

    public void setQueryBusinessService(QueryBusinessService queryBusinessService) {
        this.queryBusinessService = queryBusinessService;
    }
}
