package com.els.base.query.condition.command;

import com.els.base.core.utils.Assert;
import com.els.base.query.business.entity.QueryBusiness;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;
import com.els.base.query.condition.entity.QueryCondition;
import com.els.base.query.condition.entity.QueryConditionExample;
import com.els.base.utils.uuid.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * 批量创建条件
 *
 * @author liuhf
 */
public class BatchCreateCommand extends AbstractConditionCommand<String> {

    private List<QueryCondition> queryConditionList;
    private String queryBusinessCode;

    public BatchCreateCommand(List<QueryCondition> queryConditionList, String queryBusinessCode) {
        this.queryConditionList = queryConditionList;
        this.queryBusinessCode = queryBusinessCode;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {
        this.queryConditionInvoker = queryConditionInvoker;
        this.validData(queryConditionList, queryBusinessCode);
        this.processor(queryConditionList);
        return null;
    }

    private void processor(List<QueryCondition> queryConditions) {

        //先删除跟code关联的条件
        QueryConditionExample queryConditionExample = new QueryConditionExample();
        queryConditionExample.createCriteria().andQueryBusinessCodeEqualTo(queryBusinessCode);
        this.queryConditionInvoker.getQueryConditionService().deleteByExample(queryConditionExample);

        //根据code值查询
        QueryBusiness byBusinessCode = this.queryConditionInvoker.getQueryBusinessService().findByBusinessCode(queryBusinessCode);
        Assert.isNotNull(byBusinessCode, "业务编码不存在,请检查！");

        //构建关系
        for (QueryCondition condition : queryConditions) {
            condition.setId(UUIDGenerator.generateUUID());
            condition.setQueryBusinessCode(queryBusinessCode);
            condition.setQueryBusinessId(byBusinessCode.getId());
            List<QueryCondition> queryConditionList = condition.getQueryConditionList();
            if (CollectionUtils.isNotEmpty(queryConditionList)) {
                for (QueryCondition queryCondition : queryConditionList) {
                    queryCondition.setId(UUIDGenerator.generateUUID());
                    queryCondition.setQueryBusinessCode(queryBusinessCode);
                    queryCondition.setParentId(condition.getId());
                    queryCondition.setQueryBusinessId(byBusinessCode.getId());
                }
            }
        }

        //重新插入
        this.queryConditionInvoker.getQueryConditionService().insertBatch(queryConditions);

        for (QueryCondition queryCondition : queryConditions) {
            if (CollectionUtils.isNotEmpty(queryCondition.getQueryConditionList())) {
                this.queryConditionInvoker.getQueryConditionService().insertBatch(queryCondition.getQueryConditionList());
            }
        }
    }

    private void validData(List<QueryCondition> queryConditionList, String queryBusinessCode) {
        Assert.isNotEmpty(queryConditionList, "条件不能为空，请检查！");
        Assert.isNotBlank(queryBusinessCode, "业务编码不能为空！");
        for (QueryCondition queryCondition : queryConditionList) {
            Assert.isNotBlank(queryCondition.getFieldName(), "字段显示的名称不能为空，请检查！");
            Assert.isNotBlank(queryCondition.getFieldCode(), "字段编码不能为空，请检查！");
            Assert.isNotBlank(queryCondition.getFieldOperator(), "操作符不能为空，请检查！");
            Assert.isNotBlank(queryCondition.getFieldType(), "字段不能为空，请检查！");
            //Assert.isNotBlank(queryCondition.getQueryBusinessCode(), "业务编码不能为空，请检查！");
            //Assert.isNotBlank(queryCondition.getQueryBusinessId(), "业务ID不能为空，请检查！");
        }
    }
}
