package com.els.base.query.condition.command;

import com.els.base.core.utils.Assert;
import com.els.base.query.common.AbstractConditionCommand;
import com.els.base.query.common.QueryConditionInvoker;
import com.els.base.query.condition.entity.QueryCondition;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author 创建条件
 */
public class CreateCommand extends AbstractConditionCommand<String> {

    private QueryCondition queryCondition;

    public CreateCommand(QueryCondition queryCondition) {
        this.queryCondition = queryCondition;
    }

    @Override
    public String execute(QueryConditionInvoker queryConditionInvoker) {
        this.queryConditionInvoker = queryConditionInvoker;
        this.validData(queryCondition);
        this.processor(queryCondition);
        return null;
    }

    private void processor(QueryCondition queryCondition) {
        this.queryConditionInvoker.getQueryConditionService().addObj(queryCondition);

        List<QueryCondition> queryConditionList = queryCondition.getQueryConditionList();
        if (CollectionUtils.isNotEmpty(queryConditionList)) {
            for (QueryCondition condition : queryConditionList) {
                condition.setParentId(queryCondition.getId());
                condition.setQueryBusinessCode(queryCondition.getQueryBusinessCode());
                condition.setQueryBusinessId(queryCondition.getQueryBusinessId());
            }
        }
        this.queryConditionInvoker.getQueryConditionService().addAll(queryConditionList);
    }

    private void validData(QueryCondition queryCondition) {
        Assert.isNotNull(queryCondition, "条件不能为空，请检查！");
        Assert.isNotBlank(queryCondition.getFieldName(), "字段编码不能为空，请检查！");
        Assert.isNotBlank(queryCondition.getQueryBusinessCode(), "业务编码不能为空，请检查！");
        Assert.isNotBlank(queryCondition.getQueryBusinessId(), "业务ID不能为空，请检查！");
    }
}
