CREATE TABLE `T_BASE_QUERY_BUSINESS`
(
    `ID`             varchar(32)  NOT NULL COMMENT 'ID',
    `USER_ID`        varchar(32)  DEFAULT NULL COMMENT '供应商用户ID',
    `USER_NAME`      varchar(255) DEFAULT NULL COMMENT '供应商用户名称',
    `CONDITION_CODE` varchar(255) NOT NULL COMMENT '查询条件类型编码(自动生成)-唯一性',
    `CONDITION_TYPE` varchar(255) NOT NULL COMMENT '查询条件类型(创建者输入)-唯一性',
    `CONDITION_NAME` varchar(255) DEFAULT NULL COMMENT '查询条件业务名称',
    `CONDITION_DESC` varchar(255) DEFAULT NULL COMMENT '查询条件业务类型描述',
    `CONDITION_FLAG` int(7)       DEFAULT '1' COMMENT '查询条件是否可用(0_删除，1_可以使用，2_冻结)',
    `IS_ENABLE`      int(7)       DEFAULT NULL COMMENT '是否删除(0_删除，1_可用)',
    `CREATE_TIME`    datetime     DEFAULT NULL COMMENT '创建时间',
    `UPDATE_TIME`    datetime     DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`ID`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='自定义查询条件业务';


CREATE TABLE `T_BASE_QUERY_CONDITION`
(
    `ID`                  varchar(32)  NOT NULL COMMENT 'ID',
    `PARENT_ID`           varchar(32)  DEFAULT NULL COMMENT '父级ID',
    `FIELD_NAME`          varchar(255) DEFAULT NULL COMMENT '字段名称',
    `FIELD_CODE`          varchar(255) NOT NULL COMMENT '字段编码',
    `FIELD_DESC`          varchar(255) DEFAULT NULL COMMENT '字段描述',
    `FIELD_TYPE`          varchar(255) DEFAULT NULL COMMENT '字段类型',
    `FIELD_VALUE`         varchar(255) DEFAULT '' COMMENT '字段的默认值',
    `QUERY_BUSINESS_ID`   varchar(32)  DEFAULT NULL COMMENT '业务ID',
    `QUERY_BUSINESS_CODE` varchar(255) DEFAULT NULL COMMENT '业务编码',
    PRIMARY KEY (`ID`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='自定义查询条件字段';
