/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.codegenerator.service.impl;

import com.els.base.codegenerator.dao.GenerateCodeMapper;
import com.els.base.codegenerator.entity.GenerateCode;
import com.els.base.codegenerator.entity.GenerateCodeExample;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.codegenerator.service.GenerateStrategy;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.utils.SpringContextHolder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultGenerateCodeService")
public class GenerateCodeServiceImpl
implements GenerateCodeService {
    private static Logger logger = LoggerFactory.getLogger(GenerateCodeServiceImpl.class);
    private static int QUEUE_MAX_SIZE = 10;
    private static Map<String, ConcurrentLinkedQueue<String>> codeAndQueue = new Hashtable<String, ConcurrentLinkedQueue<String>>();
    @Resource
    protected GenerateCodeMapper generateCodeMapper;

    @Value(value="${generate.code.queue.size:1}")
    public void setQueueSize(Integer queueSize) {
        if (queueSize != null && queueSize > 0) {
            QUEUE_MAX_SIZE = queueSize;
        }
    }

    @Override
    @CacheEvict(value={"generateCode"}, allEntries=true)
    public void addObj(GenerateCode t) {
        if (StringUtils.isBlank((String)t.getTargetCode())) {
            throw new CommonException("\u53c2\u6570\u5f02\u5e38", "base_param_error", "\u76ee\u6807code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GenerateCodeExample example = new GenerateCodeExample();
        example.createCriteria().andTargetCodeEqualTo(t.getTargetCode());
        if (this.generateCodeMapper.countByExample(example) > 0) {
            throw new CommonException("\u76ee\u6807code\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d", "base_is_exists", "\u76ee\u6807code");
        }
        this.generateCodeMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"generateCode"}, allEntries=true)
    public void deleteObjById(String id) {
        this.generateCodeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"generateCode"}, allEntries=true)
    public void modifyObj(GenerateCode t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        GenerateCodeExample example = new GenerateCodeExample();
        example.createCriteria().andTargetCodeEqualTo(t.getTargetCode()).andIdNotEqualTo(t.getId());
        if (this.generateCodeMapper.countByExample(example) > 0) {
            throw new CommonException("\u76ee\u6807code\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d", "base_is_exists", "\u76ee\u6807code");
        }
        this.generateCodeMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"generateCode"}, keyGenerator="redisKeyGenerator")
    public GenerateCode queryObjById(String id) {
        return this.generateCodeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"generateCode"}, keyGenerator="redisKeyGenerator")
    public List<GenerateCode> queryAllObjByExample(GenerateCodeExample example) {
        return this.generateCodeMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"generateCode"}, keyGenerator="redisKeyGenerator")
    public PageView<GenerateCode> queryObjByPage(GenerateCodeExample example) {
        PageView<GenerateCode> pageView = example.getPageView();
        pageView.setQueryResult(this.generateCodeMapper.selectByExampleByPage(example));
        return pageView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CacheEvict(value={"generateCode"}, allEntries=true)
    public String getNextCode(String targetCode) {
        ConcurrentLinkedQueue<String> queue = codeAndQueue.get(targetCode);
        if (queue == null) {
            Map<String, ConcurrentLinkedQueue<String>> map = codeAndQueue;
            synchronized (map) {
                if (codeAndQueue.get(targetCode) == null) {
                    codeAndQueue.put(targetCode, new ConcurrentLinkedQueue());
                }
            }
        }
        try {
            queue = codeAndQueue.get(targetCode);
            return this.getNextCodeFromQueue(queue, targetCode);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("\u751f\u6210\u7f16\u7801\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextCodeFromQueue(ConcurrentLinkedQueue<String> queue, String targetCode) throws InterruptedException {
        String code = queue.poll();
        if (code != null) {
            return code;
        }
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = queue;
        synchronized (concurrentLinkedQueue) {
            code = queue.poll();
            if (code != null) {
                return code;
            }
            List<String> codeList = this.getNextCodes(targetCode, QUEUE_MAX_SIZE);
            for (String tmpCode : codeList) {
                queue.offer(tmpCode);
            }
        }
        return queue.poll();
    }

    @Override
    @CacheEvict(value={"generateCode"}, allEntries=true)
    @Transactional
    public List<String> getNextCodes(String targetCode, int quantity) {
        if (quantity <= 0) {
            throw new CommonException("\u53c2\u6570\u5f02\u5e38", "base_param_error", ",\u751f\u6210code\u7684\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e\u7b49\u4e8e0");
        }
        int tryTime = 3;
        ArrayList<String> codeList = null;
        while (tryTime > 0 && CollectionUtils.isEmpty(codeList)) {
            --tryTime;
            GenerateCodeExample example = new GenerateCodeExample();
            example.createCriteria().andTargetCodeEqualTo(targetCode);
            List<GenerateCode> list = this.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(list)) {
                throw new CommonException("targetCode \u4e0d\u5b58\u5728\u65e0\u6cd5\u64cd\u4f5c", "do_not_exists", "targetCode");
            }
            if (list.size() > 1) {
                throw new CommonException("\u6839\u636etargetCode\u67e5\u8be2, targetCode\u51fa\u73b0\u91cd\u590d", "base_data_repeat", "targetCode");
            }
            GenerateCode currentCode = list.get(0);
            String strategyStr = currentCode.getStrategy();
            GenerateStrategy strategy = null;
            try {
                strategy = (GenerateStrategy)SpringContextHolder.getOneBean(Class.forName(strategyStr));
            }
            catch (ClassNotFoundException e) {
                logger.error("\u7f16\u7801\u751f\u6210\u7b56\u7565\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(e);
            }
            List<String> tmpCodeList = strategy.generateNextCode(currentCode, quantity);
            String lastCode = tmpCodeList.get(tmpCodeList.size() - 1);
            this.modifyCurrentCode(targetCode, currentCode.getCurrentCode(), lastCode);
            String prefix = currentCode.getPrefix() == null ? "" : currentCode.getPrefix();
            String suffix = currentCode.getSuffix() == null ? "" : currentCode.getSuffix();
            codeList = new ArrayList<String>();
            for (String newCode : tmpCodeList) {
                codeList.add(MessageFormat.format(prefix + "{0}" + suffix, newCode));
            }
            if (tryTime != 0) continue;
            throw new CommonException("\u751f\u6210\u7f16\u7801\u5931\u8d25\uff0c\u91cd\u8bd5\u8d85\u8fc73\u6b21");
        }
        return codeList;
    }

    private void modifyCurrentCode(String targetCode, String oldCode, String newCode) {
        GenerateCodeExample example = new GenerateCodeExample();
        GenerateCodeExample.Criteria criteria = example.createCriteria().andTargetCodeEqualTo(targetCode);
        if (oldCode == null) {
            criteria.andCurrentCodeIsNull();
        } else {
            criteria.andCurrentCodeEqualTo(oldCode);
        }
        GenerateCode code = new GenerateCode();
        code.setCurrentCode(newCode);
        int effectRow = this.generateCodeMapper.updateByExampleSelective(code, example);
        if (effectRow <= 0) {
            throw new CommonException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u7f16\u7801\u7248\u672c\u5df2\u8fc7\u671f", "code_generate_fail");
        }
    }

    @Override
    @CacheEvict(value={"generateCode"}, allEntries=true)
    public String getNextCompanyCode() {
        return this.getNextCode("COMPANY_CODE_GENERATOR");
    }

    @Override
    @CacheEvict(value={"generateCode"}, allEntries=true)
    public List<String> getNextCompanyCodes(int auantity) {
        return this.getNextCodes("COMPANY_CODE_GENERATOR", auantity);
    }
}

