/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.dao.IndustryMapper;
import com.els.base.company.entity.Industry;
import com.els.base.company.entity.IndustryExample;
import com.els.base.company.service.IndustryService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u884c\u4e1a\u4fe1\u606f")
@Controller
@RequestMapping(value={"industry"})
public class IndustryController {
    private static final Integer YES_INABLED = 1;
    @Resource
    protected IndustryService industryService;
    @Resource
    protected IndustryMapper industryMapper;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u884c\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Industry industry) {
        if (StringUtils.isEmpty((String)industry.getName())) {
            throw new CommonException("\u884c\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)industry.getCode())) {
            throw new CommonException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        industry.setId(null);
        industry.setIsEnable(YES_INABLED);
        this.industryService.addObj(industry);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u884c\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Industry industry) {
        if (StringUtils.isBlank((String)industry.getId())) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isEmpty((String)industry.getName())) {
            throw new CommonException("\u884c\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)industry.getCode())) {
            throw new CommonException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = false;
        Industry obj = (Industry)this.industryService.queryObjById(industry.getId());
        if (null == obj) {
            throw new CommonException("\u8be5id\u67e5\u4e0d\u5230\u6570\u636e");
        }
        String code = obj.getCode();
        if (StringUtils.isNotBlank((String)code) && !code.equals(industry.getCode())) {
            flag = true;
        }
        if (flag) {
            IndustryExample example = new IndustryExample();
            example.createCriteria().andCodeEqualTo(industry.getCode()).andIsEnableEqualTo(YES_INABLED);
            if (this.industryMapper.countByExample(example) > 0) {
                throw new CommonException("\u8be5\u884c\u4e1a\u7f16\u7801\u5df2\u7ecf\u5b58\u5728,\u65e0\u6cd5\u4fee\u6539!");
            }
        }
        industry.setUpdateTime(new Date());
        this.industryService.modifyObj(industry);
        return ResponseResult.success();
    }

    @Transactional
    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u884c\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("Id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        this.industryService.deleteObjById(id);
        IndustryExample example = new IndustryExample();
        example.createCriteria().andParentIdEqualTo(id);
        if (this.industryMapper.countByExample(example) > 0) {
            List list = this.industryService.queryAllObjByExample(example);
            for (Industry industry : list) {
                this.industryService.deleteCascadedIndustryInfo(industry.getId());
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u884c\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Industry>> findByPage(@ApiParam(value="\u6240\u5728\u9875\u7801", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String sSearch) {
        IndustryExample example = new IndustryExample();
        example.setPageView(new PageView<Industry>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        if (StringUtils.isNotBlank((String)sSearch)) {
            // empty if block
        }
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.industryService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7id\u67e5\u8be2\u884c\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/findIndustryById"})
    @ResponseBody
    public ResponseResult<Industry> findIndustryById(@RequestParam(required=true) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("Id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        Industry i = (Industry)this.industryService.queryObjById(id);
        return ResponseResult.success(i);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u7684\u884c\u4e1a\u4fe1\u606f\u53ca\u5173\u8054\u7684\u5b50\u884c\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/findAllIndustryInfo"})
    @ResponseBody
    public ResponseResult<List<Industry>> findAllIndustryInfo() {
        IndustryExample example = new IndustryExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andIsEnableEqualTo(YES_INABLED).andParentIdIsNull();
        List industryList = this.industryService.queryAllObjByExample(example);
        for (Industry industry : industryList) {
            industry.setIndustryList(this.industryService.queryByParentId(industry.getId()));
        }
        return ResponseResult.success(industryList);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eid\u67e5\u627e\u4e0b\u4e00\u7ea7\u8054\u7684\u884c\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/findTheNextCascadedIndustryInfo"})
    @ResponseBody
    public ResponseResult<List<Industry>> findTheNextCascadedIndustryInfo(@RequestParam(required=true) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("Id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        List<Industry> list = this.industryService.findTheNextCascadedIndustryInfo(id);
        return ResponseResult.success(list);
    }
}

