/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.event;

import com.els.base.core.event.BaseEventDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.springframework.context.ApplicationEvent;

@JsonDeserialize(using=BaseEventDeserializer.class)
public abstract class BaseEvent
extends ApplicationEvent {
    private static final long serialVersionUID = 1L;
    private String sourceClass;
    private String projectId;
    private String eventClass;
    private long timestamp;

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public BaseEvent(Object source) {
        super(source);
        this.sourceClass = source.getClass().getName();
        this.eventClass = ((Object)((Object)this)).getClass().getName();
        this.timestamp = System.currentTimeMillis();
    }

    public BaseEvent(Object source, String projectId) {
        super(source);
        this.projectId = projectId;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

