/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.event;

import com.els.base.core.event.BaseEvent;
import com.els.base.core.event.EventPublisher;
import com.els.base.utils.SpringContextHolder;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;

@Component(value="applicationEventMulticaster")
public class CustomApplicationEventMulticaster
implements ApplicationEventMulticaster,
BeanClassLoaderAware,
BeanFactoryAware {
    private static Logger logger = LoggerFactory.getLogger(CustomApplicationEventMulticaster.class);
    @Value(value="${event.multecast.is.specified:false}")
    private String isSpecified;
    @Value(value="${event.multecast.bean.name:}")
    private String publisherName;
    @Resource(name="eventMulticaster")
    private SimpleApplicationEventMulticaster eventMulticaster;

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        if ("true".equals(this.isSpecified) && event instanceof BaseEvent) {
            EventPublisher publisher = null;
            try {
                publisher = StringUtils.isNotBlank((String)this.publisherName) ? (EventPublisher)SpringContextHolder.getBean((String)this.publisherName) : (EventPublisher)SpringContextHolder.getOneBean(EventPublisher.class);
            }
            catch (Exception e) {
                logger.warn("\u83b7\u53d6\u81ea\u5b9a\u4e49\u7684\u4e8b\u4ef6\u53d1\u5e03\u5668\u5931\u8d25");
            }
            publisher.multicastEvent((BaseEvent)event, eventType);
            return;
        }
        this.eventMulticaster.multicastEvent(event, eventType);
    }

    public void multicastEvent(ApplicationEvent event) {
        this.multicastEvent(event, ResolvableType.forInstance((Object)event));
    }

    public SimpleApplicationEventMulticaster getEventMulticaster() {
        return this.eventMulticaster;
    }

    public void setEventMulticaster(SimpleApplicationEventMulticaster eventMulticaster) {
        this.eventMulticaster = eventMulticaster;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventMulticaster.setBeanFactory(beanFactory);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.eventMulticaster.setBeanClassLoader(classLoader);
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        this.eventMulticaster.addApplicationListener(listener);
    }

    public void addApplicationListenerBean(String listenerBeanName) {
        this.eventMulticaster.addApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListener(ApplicationListener<?> listener) {
        this.eventMulticaster.removeApplicationListener(listener);
    }

    public void removeApplicationListenerBean(String listenerBeanName) {
        this.eventMulticaster.removeApplicationListenerBean(listenerBeanName);
    }

    public void removeAllListeners() {
        this.eventMulticaster.removeAllListeners();
    }
}

