/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.service.dictionary.impl;

import com.els.base.core.dao.dictionary.DicGroupMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dicGroupService")
public class DicGroupServiceImpl
implements DicGroupService {
    @Resource
    protected DicGroupMapper dicGroupMapper;
    @Resource
    protected DicGroupItemService dicGroupItemService;

    @Override
    @CacheEvict(value={"dicGroup"}, allEntries=true)
    public void addObj(DicGroup t) {
        if (StringUtils.isBlank((String)t.getCode())) {
            throw new CommonException("code\u503c\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "code\u503c");
        }
        DicGroupExample example = new DicGroupExample();
        example.createCriteria().andCodeEqualTo(t.getCode());
        if (this.dicGroupMapper.countByExample(example) > 0) {
            throw new CommonException("code\u503c\u5df2\u5b58\u5728", "base_is_exists", "code\u503c");
        }
        if (t.getCode().length() > 100 || t.getName().length() > 100) {
            throw new CommonException("\u7f16\u7801\u6216\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", "\u7f16\u7801\u6216\u540d\u79f0", "100");
        }
        this.dicGroupMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"dicGroup"}, allEntries=true)
    @Transactional
    public void deleteObjById(String id) {
        this.dicGroupMapper.deleteByPrimaryKey(id);
        this.dicGroupItemService.deleteItemsByGroupId(id);
    }

    @Override
    @CacheEvict(value={"dicGroup"}, allEntries=true)
    public void modifyObj(DicGroup t) {
        if (t == null || t.getId() == null) {
            throw new CommonException("id \u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isNotBlank((String)t.getCode()) && (t.getCode().length() > 100 || t.getName().length() > 100)) {
            throw new CommonException("\u7f16\u7801\u6216\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", "\u7f16\u7801\u6216\u540d\u79f0", "100");
        }
        this.dicGroupMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"dicGroup"}, keyGenerator="redisKeyGenerator")
    public DicGroup queryObjById(String id) {
        return this.dicGroupMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"dicGroup"}, keyGenerator="redisKeyGenerator")
    public List<DicGroup> queryAllObjByExample(DicGroupExample example) {
        return this.dicGroupMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"dicGroup"}, keyGenerator="redisKeyGenerator")
    public PageView<DicGroup> queryObjByPage(DicGroupExample example) {
        PageView<DicGroup> pageView = example.getPageView();
        pageView.setQueryResult(this.dicGroupMapper.selectByExampleByPage(example));
        return pageView;
    }
}

