/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.utils.query;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@ApiModel(value="\u901a\u7528\u6392\u5e8f\u6761\u4ef6")
public class OrderByParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ORDER_BY_DESC = "DESCENDING";
    private static final String ORDER_BY_ASC = "ASCENDING";
    private static final Pattern PATTERN_ORDER_BY_VALUE = Pattern.compile("[A-Z]([a-z\\d]+)?");
    @ApiModelProperty(value="\u5c5e\u6027\u540d")
    private String prop;
    @ApiModelProperty(value="\u6392\u5e8f\uff0c\u6b63\u5e8f DESCENDING, \u5012\u5e8f ASCENDING")
    private String order;

    public String getProp() {
        return this.prop;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getSQLFormat() {
        Assert.isNotBlank(this.prop, "\u6392\u5e8f\u5c5e\u6027prop\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order, "\u6392\u5e8f\u5c5e\u6027orderBy\u4e0d\u80fd\u4e3a\u7a7a");
        String propName = this.transformProperty(this.prop.trim());
        String orderBy = this.order.trim().toUpperCase();
        if (!ORDER_BY_DESC.equals(orderBy) && !ORDER_BY_ASC.equals(orderBy)) {
            throw new CommonException("\u6392\u5e8f\u5c5e\u6027orderBy\u683c\u5f0f\u5f02\u5e38\uff0c\u53ea\u80fd\u4e3a descending\u6216\u8005 ascending");
        }
        orderBy = orderBy.replaceAll("ENDING", "");
        return MessageFormat.format("{0} {1}", propName, orderBy);
    }

    private String transformProperty(String property) {
        property = StringUtils.capitalize((String)property);
        ArrayList<String> upperWorlds = new ArrayList<String>();
        Matcher matcher = PATTERN_ORDER_BY_VALUE.matcher(property);
        while (matcher.find()) {
            String upper = matcher.group().toUpperCase();
            upperWorlds.add(upper);
        }
        return StringUtils.join(upperWorlds, (String)"_");
    }
}

