/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.material.dao.MaterialMapper;
import com.els.base.material.dao.MaterialSealMapper;
import com.els.base.material.entity.MaterialSeal;
import com.els.base.material.entity.MaterialSealExample;
import com.els.base.material.entity.MaterialSealRef;
import com.els.base.material.entity.MaterialSealRefExample;
import com.els.base.material.service.MaterialSealRefService;
import com.els.base.material.service.MaterialSealService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialSealService")
public class MaterialSealServiceImpl
implements MaterialSealService {
    @Resource
    protected MaterialSealMapper materialSealMapper;
    @Resource
    protected MaterialSealRefService materialSealRefService;
    @Resource
    protected MaterialMapper materialMapper;

    @Override
    @CacheEvict(value={"materialSeal"}, allEntries=true)
    @Transactional
    public void addObj(MaterialSeal t) {
        MaterialSealExample materialSealExample = new MaterialSealExample();
        MaterialSealExample.Criteria criteria = materialSealExample.createCriteria();
        criteria.andSealCodeEqualTo(t.getSealCode());
        int countByExample = this.materialSealMapper.countByExample(materialSealExample);
        if (countByExample > 0) {
            // empty if block
        }
        this.materialSealMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"materialSeal"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialSealMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"materialSeal"}, allEntries=true)
    public void modifyObj(MaterialSeal t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialSealMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"materialSeal"}, keyGenerator="redisKeyGenerator")
    public MaterialSeal queryObjById(String id) {
        return this.materialSealMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"materialSeal"}, keyGenerator="redisKeyGenerator")
    public List<MaterialSeal> queryAllObjByExample(MaterialSealExample example) {
        return this.materialSealMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"materialSeal"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialSeal> queryObjByPage(MaterialSealExample example) {
        PageView<MaterialSeal> pageView = example.getPageView();
        example.setOrderByClause(" MODIFY_TIME desc ");
        List<MaterialSeal> selectByExampleByPage = this.materialSealMapper.selectByExampleByPage(example);
        pageView.setQueryResult(selectByExampleByPage);
        return pageView;
    }

    @Override
    public boolean judgeSealIsEffective(String materialCode) {
        MaterialSealRefExample msr = new MaterialSealRefExample();
        msr.createCriteria().andMaterialCodeEqualTo(materialCode);
        List selectByExample = this.materialSealRefService.queryAllObjByExample(msr);
        if (CollectionUtils.isEmpty(selectByExample)) {
            throw new CommonException("\u7269\u6599\u7f16\u7801:" + materialCode + "\u6240\u5bf9\u5e94\u7684\u5173\u5c01\u4fe1\u606f\u4e0d\u5b58\u5728", "do_not_exists", "\u7269\u6599\u7f16\u7801:" + materialCode + "\u6240\u5bf9\u5e94\u7684\u5173\u5c01\u4fe1\u606f");
        }
        String customsNo = ((MaterialSealRef)selectByExample.get(0)).getCustomsNo();
        if (customsNo == null) {
            throw new CommonException("\u5173\u5c01\u54c1\u53f7\u4e0d\u5b58\u5728", "do_not_exists", "\u5173\u5c01\u54c1\u53f7");
        }
        MaterialSealExample mse = new MaterialSealExample();
        MaterialSealExample.Criteria criteria = mse.createCriteria();
        criteria.andCustomsNoEqualTo(customsNo);
        criteria.andEffectiveTimeGreaterThan(new Date());
        boolean boo = true;
        List<MaterialSeal> allObjByExample = this.queryAllObjByExample(mse);
        if (CollectionUtils.isNotEmpty(allObjByExample)) {
            BigDecimal countQuantity = null;
            BigDecimal countDeliveryNum = null;
            for (MaterialSeal materialSeal : allObjByExample) {
                countQuantity = countQuantity.add(materialSeal.getQuantity());
                countDeliveryNum = countDeliveryNum.add(materialSeal.getDeliveryNum());
            }
            if (countQuantity.compareTo(countDeliveryNum) == 0 || countQuantity.compareTo(countDeliveryNum) == -1) {
                boo = false;
            }
        } else {
            boo = false;
        }
        return boo;
    }

    @Override
    @CacheEvict(value={"materialSeal"}, allEntries=true)
    public void updateDeliveryNum(String materialCode, BigDecimal quantity, String code) {
        MaterialSealRefExample materialSealRefExample = new MaterialSealRefExample();
        MaterialSealRefExample.Criteria refCriteria = materialSealRefExample.createCriteria();
        refCriteria.andMaterialCodeEqualTo(materialCode);
        List selectByExample2 = this.materialSealRefService.queryAllObjByExample(materialSealRefExample);
        String customs = null;
        if (!CollectionUtils.isEmpty(selectByExample2)) {
            BigDecimal deliveryNum;
            for (MaterialSealRef materialSealRef : selectByExample2) {
                customs = materialSealRef.getCustomsNo();
            }
            MaterialSealExample materialSealExample = new MaterialSealExample();
            MaterialSealExample.Criteria criteria = materialSealExample.createCriteria();
            criteria.andCustomsNoEqualTo(customs);
            materialSealExample.setOrderByClause(" EFFECTIVE_TIME ASC ");
            List<MaterialSeal> sealInfo = this.materialSealMapper.selectByExample(materialSealExample);
            ArrayList<MaterialSeal> list = new ArrayList<MaterialSeal>();
            MaterialSealExample sealExample = new MaterialSealExample();
            MaterialSealExample.Criteria sealcriteria = sealExample.createCriteria();
            BigDecimal bigDecimal = new BigDecimal(0);
            if (code.equals("I")) {
                for (MaterialSeal materialSeal : sealInfo) {
                    if (materialSeal.getDeliveryNum() == null) {
                        materialSeal.setDeliveryNum(bigDecimal);
                    }
                    if (materialSeal.getQuantity().compareTo(materialSeal.getDeliveryNum()) != 1) continue;
                    list.add(materialSeal);
                }
                if (list.size() != 0) {
                    for (MaterialSeal materialSeal : list) {
                        deliveryNum = materialSeal.getDeliveryNum();
                        BigDecimal quantity2 = materialSeal.getQuantity();
                        BigDecimal parse = quantity2.subtract(deliveryNum);
                        BigDecimal saveNum = null;
                        if (quantity.compareTo(parse) == 0 || quantity.compareTo(parse) == -1) {
                            saveNum = deliveryNum.add(quantity);
                            quantity = new BigDecimal(0);
                        } else if (quantity.compareTo(parse) == 1) {
                            saveNum = quantity2;
                            quantity = quantity.subtract(parse);
                        }
                        materialSeal.setDeliveryNum(saveNum);
                        materialSeal.setNotShipped(quantity2.subtract(saveNum));
                        sealcriteria.andIdEqualTo(materialSeal.getId());
                        this.materialSealMapper.updateByPrimaryKeySelective(materialSeal);
                    }
                    if (quantity.compareTo(bigDecimal) == 1) {
                        // empty if block
                    }
                }
            }
            if (code.equals("D")) {
                for (MaterialSeal materialSealInfo : sealInfo) {
                    if (materialSealInfo.getDeliveryNum() == null) {
                        materialSealInfo.setDeliveryNum(bigDecimal);
                    }
                    if (materialSealInfo.getDeliveryNum().compareTo(bigDecimal) != 1) continue;
                    list.add(materialSealInfo);
                }
                if (list.size() != 0) {
                    for (MaterialSeal materialSeal : list) {
                        deliveryNum = materialSeal.getDeliveryNum();
                        BigDecimal saveNum = null;
                        if (quantity.compareTo(deliveryNum) == -1 || quantity.compareTo(deliveryNum) == 0) {
                            saveNum = deliveryNum.subtract(quantity);
                            quantity = bigDecimal;
                        } else if (quantity.compareTo(deliveryNum) == 1) {
                            saveNum = bigDecimal;
                            quantity = quantity.subtract(deliveryNum);
                        }
                        materialSeal.setDeliveryNum(saveNum);
                        materialSeal.setNotShipped(materialSeal.getQuantity().subtract(saveNum));
                        sealcriteria.andIdEqualTo(materialSeal.getId());
                        this.materialSealMapper.updateByPrimaryKeySelective(materialSeal);
                    }
                    if (quantity.compareTo(bigDecimal) == 1) {
                        // empty if block
                    }
                }
            }
        }
    }

    @Override
    @CacheEvict(value={"materialSeal"}, allEntries=true)
    public void importMaterailSeal(List<MaterialSeal> sealList) {
        for (int i = 0; i < sealList.size(); ++i) {
            MaterialSeal seal = sealList.get(i);
            MaterialSealExample example = new MaterialSealExample();
            example.createCriteria().andCompanyIdEqualTo(seal.getCompanyId()).andProjectIdEqualTo(seal.getProjectId()).andSupplierCodeEqualTo(seal.getSupplierCode()).andSealCodeEqualTo(seal.getSealCode()).andCustomsNoEqualTo(seal.getCustomsNo());
            List<MaterialSeal> tmpList = this.materialSealMapper.selectByExample(example);
            if (CollectionUtils.isEmpty(tmpList)) {
                this.addObj(seal);
                continue;
            }
            for (MaterialSeal ms : tmpList) {
                ms.setQuantity(seal.getQuantity());
                ms.setModifyTime(seal.getModifyTime());
                this.modifyObj(ms);
            }
        }
    }
}

