/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.material.dao.MaterialMapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialPropValueService;
import com.els.base.material.service.MaterialService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialService")
public class MaterialServiceImpl
implements MaterialService {
    @Resource
    protected MaterialMapper materialMapper;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected MaterialPropValueService materialPropValueService;

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void addObj(Material t) {
        if (StringUtils.isBlank((String)t.getCategoryId())) {
            throw new NullPointerException("\u7269\u6599\u5206\u7c7bId\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById(t.getCategoryId());
        if (materialCategory == null) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b '" + t.getCategoryId() + "' \u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "do_not_exists", "\u7269\u6599\u5206\u7c7b ");
        }
        t.setCategoryName(materialCategory.getCategoryName());
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria materialExampleCriteria = materialExample.createCriteria();
        materialExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialExampleCriteria.andMaterialCodeEqualTo(t.getMaterialCode());
        int count = this.materialMapper.countByExample(materialExample);
        if (count > 0) {
            throw new CommonException("\u7269\u6599\u7f16\u53f7 '" + t.getMaterialCode() + "' \u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "base_is_exists", "\u7269\u6599MaterialCode");
        }
        this.materialMapper.insertSelective(t);
        MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
        MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
        materialPropValueExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialPropValueExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialPropValueExampleCriteria.andMaterialIdEqualTo(t.getId());
        this.materialPropValueService.deleteByExample(materialPropValueExample);
        List<MaterialPropKeyGroup> materialPropKeyGroupList = t.getMaterialPropKeyGroupList();
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                List<MaterialPropKey> materialPropKeyList = materialPropKeyGroup.getMaterialPropKeyList();
                if (!CollectionUtils.isNotEmpty(materialPropKeyList)) continue;
                for (MaterialPropKey materialPropKey : materialPropKeyList) {
                    MaterialPropValue materialPropValue = new MaterialPropValue();
                    materialPropValue.setProjectId(t.getProjectId());
                    materialPropValue.setCompanyId(t.getCompanyId());
                    materialPropValue.setMaterialId(t.getId());
                    materialPropValue.setPropKeyId(materialPropKey.getId());
                    materialPropValue.setPropKey(materialPropKey.getPropKey());
                    materialPropValue.setPropValue(materialPropKey.getPropValue());
                    materialPropValue.setPropKeyGroupId(materialPropKeyGroup.getId());
                    this.materialPropValueService.addObj(materialPropValue);
                }
            }
        }
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void modifyObj(Material t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        Material material = this.materialMapper.selectByPrimaryKey(t.getId());
        if (material == null) {
            throw new CommonException("\u8be5\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0", "do_not_exists", "\u8be5\u7269\u6599");
        }
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById(t.getCategoryId());
        if (materialCategory == null) {
            throw new CommonException("\u8be5\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "do_not_exists", "\u8be5\u7269\u6599");
        }
        t.setProjectId(t.getProjectId());
        t.setCompanyId(t.getCompanyId());
        t.setCategoryName(materialCategory.getCategoryName());
        t.setCreateUserId(t.getCreateUserId());
        t.setCreateUserName(t.getCreateUserName());
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria materialExampleCriteria = materialExample.createCriteria();
        materialExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialExampleCriteria.andMaterialCodeEqualTo(t.getMaterialCode());
        if (material.getMaterialCode().equals(t.getMaterialCode())) {
            this.materialMapper.updateByPrimaryKeySelective(t);
        } else {
            if (this.materialMapper.countByExample(materialExample) > 0) {
                throw new CommonException("\u7269\u6599MaterialCode '" + t.getMaterialCode() + "' \u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0", "base_is_exists", "\u7269\u6599MaterialCode");
            }
            this.materialMapper.updateByPrimaryKeySelective(t);
        }
        MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
        MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
        materialPropValueExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialPropValueExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialPropValueExampleCriteria.andMaterialIdEqualTo(t.getId());
        this.materialPropValueService.deleteByExample(materialPropValueExample);
        List<MaterialPropKeyGroup> materialPropKeyGroupList = t.getMaterialPropKeyGroupList();
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                List<MaterialPropKey> materialPropKeyList = materialPropKeyGroup.getMaterialPropKeyList();
                if (!CollectionUtils.isNotEmpty(materialPropKeyList)) continue;
                for (MaterialPropKey materialPropKey : materialPropKeyList) {
                    MaterialPropValue materialPropValue = new MaterialPropValue();
                    materialPropValue.setProjectId(t.getProjectId());
                    materialPropValue.setCompanyId(t.getCompanyId());
                    materialPropValue.setMaterialId(t.getId());
                    materialPropValue.setPropKeyId(materialPropKey.getId());
                    materialPropValue.setPropKey(materialPropKey.getPropKey());
                    materialPropValue.setPropValue(materialPropKey.getPropValue());
                    materialPropValue.setPropKeyGroupId(materialPropKeyGroup.getId());
                    this.materialPropValueService.addObj(materialPropValue);
                }
            }
        }
    }

    @Override
    public Material queryObjById(String id) {
        return this.materialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public List<Material> queryAllObjByExample(MaterialExample example) {
        return this.materialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public PageView<Material> queryObjByPage(MaterialExample example) {
        PageView<Material> pageView = example.getPageView();
        pageView.setQueryResult(this.materialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public int isEnable(String materialId, Integer isEnable) {
        Material material = new Material();
        material.setId(materialId);
        material.setIsEnable(isEnable);
        return this.materialMapper.updateByPrimaryKeySelective(material);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void importMaterial(List<Material> materials) {
        if (materials == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        for (Material material : materials) {
            String projectId = material.getProjectId();
            String companyId = material.getCompanyId();
            String materialCode = material.getMaterialCode();
            MaterialExample materialExample = new MaterialExample();
            MaterialExample.Criteria criteria = materialExample.createCriteria();
            criteria.andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andMaterialCodeEqualTo(materialCode);
            int count = this.materialMapper.countByExample(materialExample);
            if (count > 0) {
                this.materialMapper.updateByExampleSelective(material, materialExample);
                continue;
            }
            this.materialMapper.insertSelective(material);
        }
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public Boolean isExists(String materialCode) {
        if (StringUtils.isBlank((String)materialCode)) {
            throw new IllegalArgumentException("parameter materialCode is null");
        }
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria criteria = materialExample.createCriteria();
        criteria.andMaterialCodeEqualTo(materialCode);
        int count = this.materialMapper.countByExample(materialExample);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isJTL(String materialCode) {
        if (StringUtils.isEmpty((String)materialCode)) {
            throw new CommonException("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(materialCode).andLogProGroupEqualTo("L003");
        int count = this.materialMapper.countByExample(materialExample);
        return count != 0;
    }
}

