/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialPropKeyService;
import com.els.base.material.service.MaterialPropValueService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7269\u6599\u5c5e\u6027\u7ec4")
@Controller
@RequestMapping(value={"materialPropKeyGroup"})
public class MaterialPropKeyGroupController {
    @Resource
    protected MaterialPropKeyGroupService materialPropKeyGroupService;
    @Resource
    protected MaterialPropKeyService materialPropKeyService;
    @Resource
    protected MaterialPropValueService materialPropValueService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5c5e\u6027\u7ec4")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@ApiParam(value="\u7269\u6599\u5c5e\u6027\u7ec4\u4fe1\u606f") @RequestBody MaterialPropKeyGroup materialPropKeyGroup) {
        materialPropKeyGroup.setId(null);
        materialPropKeyGroup.setProjectId(ProjectUtils.getProjectId());
        materialPropKeyGroup.setCompanyId(CompanyUtils.currentCompanyId());
        this.materialPropKeyGroupService.addObj(materialPropKeyGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5c5e\u6027\u7ec4")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@ApiParam(value="\u7269\u6599\u5c5e\u6027\u7ec4\u4fe1\u606f") @RequestBody MaterialPropKeyGroup materialPropKeyGroup) {
        if (StringUtils.isBlank((String)materialPropKeyGroup.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        materialPropKeyGroup.setCompanyId(CompanyUtils.currentCompanyId());
        materialPropKeyGroup.setProjectId(ProjectUtils.getProjectId());
        this.materialPropKeyGroupService.modifyObj(materialPropKeyGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5c5e\u6027\u7ec4")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        MaterialPropKeyExample materialPropKeyExample = new MaterialPropKeyExample();
        MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExample.createCriteria();
        materialPropKeyExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        materialPropKeyExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(id);
        List materialPropKeyList = this.materialPropKeyService.queryAllObjByExample(materialPropKeyExample);
        if (CollectionUtils.isNotEmpty(materialPropKeyList)) {
            throw new CommonException("\u8be5\u5c5e\u6027\u7ec4\u4e0b\u9762\u5b58\u5728\u5c5e\u6027key\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664", "existing_ref_ass", "\u8be5\u5c5e\u6027\u7ec4", "\u5c5e\u6027key");
        }
        this.materialPropKeyGroupService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u5c5e\u6027\u7ec4")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialPropKeyGroup>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialPropKeyGroup") @RequestBody(required=false) List<QueryParam> params) {
        MaterialPropKeyGroupExample example = new MaterialPropKeyGroupExample();
        example.setPageView(new PageView<MaterialPropKeyGroup>(pageNo, pageSize));
        MaterialPropKeyGroupExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(params)) {
            CriteriaUtils.addCriterion(criteria, params);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        PageView pageData = this.materialPropKeyGroupService.queryObjByPage(example);
        List materialPropKeyGroupList = pageData.getQueryResult();
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                MaterialPropKeyExample materialPropKeyExample = new MaterialPropKeyExample();
                MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExample.createCriteria();
                materialPropKeyExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
                materialPropKeyExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
                materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                materialPropKeyExampleCriteria.andIsEnableEqualTo(Constant.YES_INT);
                List<MaterialPropKey> materialPropKeyList = this.materialPropKeyService.queryAllObjByExample(materialPropKeyExample);
                if (!CollectionUtils.isNotEmpty(materialPropKeyList)) continue;
                materialPropKeyGroup.setMaterialPropKeyList(materialPropKeyList);
            }
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7269\u6599\u5206\u7c7b\u7269\u6599\u5c5e\u6027\u7ec4\u5217\u8868(\u4e0d\u5206\u9875)")
    @RequestMapping(value={"service/findAllPropKeyGroupByMaterialCategoryId"})
    @ResponseBody
    public ResponseResult<List<MaterialPropKeyGroup>> findAllPropKeyGroupByMaterialCategoryId(@RequestParam(required=true) String materialCategoryId) {
        if (StringUtils.isBlank((String)materialCategoryId)) {
            throw new CommonException("id \u4e3a\u7a7a", "id_is_blank");
        }
        MaterialPropKeyGroupExample example = new MaterialPropKeyGroupExample();
        MaterialPropKeyGroupExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andMaterialCategoryIdEqualTo(materialCategoryId);
        List materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                MaterialPropKeyExample materialPropKeyExample = new MaterialPropKeyExample();
                MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExample.createCriteria();
                materialPropKeyExampleCriteria.andProjectIdEqualTo(materialPropKeyGroup.getProjectId());
                materialPropKeyExampleCriteria.andCompanyIdEqualTo(materialPropKeyGroup.getCompanyId());
                materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                materialPropKeyExampleCriteria.andIsEnableEqualTo(Constant.YES_INT);
                List<MaterialPropKey> materialPropKeyList = this.materialPropKeyService.queryAllObjByExample(materialPropKeyExample);
                materialPropKeyGroup.setMaterialPropKeyList(materialPropKeyList);
            }
        }
        return ResponseResult.success(materialPropKeyGroupList);
    }
}

