/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.sample.dao.SampleComfirmDataMapper;
import com.els.base.sample.entity.SampleComfirmAuth;
import com.els.base.sample.entity.SampleComfirmData;
import com.els.base.sample.entity.SampleComfirmDataExample;
import com.els.base.sample.entity.SampleComfirmDlevel;
import com.els.base.sample.entity.SampleComfirmEp;
import com.els.base.sample.entity.SampleComfirmEsd;
import com.els.base.sample.entity.SampleComfirmInfo;
import com.els.base.sample.entity.SampleComfirmMsl;
import com.els.base.sample.entity.SampleComfirmOrder;
import com.els.base.sample.entity.SampleComfirmPack;
import com.els.base.sample.entity.SampleComfirmSilk;
import com.els.base.sample.entity.SampleComfirmSp;
import com.els.base.sample.entity.SampleComfirmSpec;
import com.els.base.sample.entity.SampleComfirmWeld;
import com.els.base.sample.enums.SampleComfirmInfoStatus;
import com.els.base.sample.enums.SampleComfirmOrderDataStatus;
import com.els.base.sample.enums.SampleComfirmOrderStatus;
import com.els.base.sample.service.SampleComfirmAuthService;
import com.els.base.sample.service.SampleComfirmDataService;
import com.els.base.sample.service.SampleComfirmDlevelService;
import com.els.base.sample.service.SampleComfirmEpService;
import com.els.base.sample.service.SampleComfirmEsdService;
import com.els.base.sample.service.SampleComfirmInfoService;
import com.els.base.sample.service.SampleComfirmMslService;
import com.els.base.sample.service.SampleComfirmOrderService;
import com.els.base.sample.service.SampleComfirmPackService;
import com.els.base.sample.service.SampleComfirmSilkService;
import com.els.base.sample.service.SampleComfirmSpService;
import com.els.base.sample.service.SampleComfirmSpecService;
import com.els.base.sample.service.SampleComfirmWeldService;
import com.els.base.sample.vo.SampleOrderCreateVO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSampleComfirmDataService")
public class SampleComfirmDataServiceImpl
implements SampleComfirmDataService {
    @Resource
    protected SampleComfirmDataMapper sampleComfirmDataMapper;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected SampleComfirmOrderService sampleComfirmOrderService;
    @Resource
    protected SampleComfirmInfoService sampleComfirmInfoService;
    @Resource
    protected SampleComfirmSpecService sampleComfirmSpecService;
    @Resource
    protected SampleComfirmEsdService sampleComfirmEsdService;
    @Resource
    protected SampleComfirmMslService sampleComfirmMslService;
    @Resource
    protected SampleComfirmWeldService sampleComfirmWeldService;
    @Resource
    protected SampleComfirmSilkService sampleComfirmSilkService;
    @Resource
    protected SampleComfirmPackService sampleComfirmPackService;
    @Resource
    protected SampleComfirmAuthService sampleComfirmAuthService;
    @Resource
    protected SampleComfirmEpService sampleComfirmEpService;
    @Resource
    protected SampleComfirmSpService sampleComfirmSpService;
    @Resource
    protected SampleComfirmDlevelService sampleComfirmDlevelService;

    @Override
    @CacheEvict(value={"sampleComfirmData"}, allEntries=true)
    public void addObj(SampleComfirmData t) {
        this.sampleComfirmDataMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"sampleComfirmData"}, allEntries=true)
    public void deleteObjById(String id) {
        this.sampleComfirmDataMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"sampleComfirmData"}, allEntries=true)
    public void modifyObj(SampleComfirmData t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.sampleComfirmDataMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"sampleComfirmData"}, keyGenerator="redisKeyGenerator")
    public SampleComfirmData queryObjById(String id) {
        return this.sampleComfirmDataMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"sampleComfirmData"}, keyGenerator="redisKeyGenerator")
    public List<SampleComfirmData> queryAllObjByExample(SampleComfirmDataExample example) {
        return this.sampleComfirmDataMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"sampleComfirmData"}, keyGenerator="redisKeyGenerator")
    public PageView<SampleComfirmData> queryObjByPage(SampleComfirmDataExample example) {
        PageView<SampleComfirmData> pageView = example.getPageView();
        pageView.setQueryResult(this.sampleComfirmDataMapper.selectByExampleByPage(example));
        return pageView;
    }

    private Material findMaterialByCode(String materialCode) {
        MaterialExample example = new MaterialExample();
        MaterialExample.Criteria criteria = example.createCriteria();
        criteria.andMaterialCodeEqualTo(materialCode);
        List materials = this.materialService.queryAllObjByExample(example);
        if (materials == null || materials.isEmpty()) {
            throw new CommonException("\u672a\u627e\u5230\u8be5\u7269\u6599[" + materialCode + "]");
        }
        return (Material)materials.get(0);
    }

    @Override
    @Transactional
    @CacheEvict(value={"sampleComfirmData"}, allEntries=true)
    public void importFromPlm(List<SampleComfirmData> list) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        for (SampleComfirmData entity : list) {
            Material material = this.findMaterialByCode(entity.getMaterialCode());
            String orderNo = this.generateCodeService.getNextCode("SAMPLE_IMPORT_ORDER_NO");
            entity.setSapOrderNo(orderNo);
            entity.setOrderStatus(SampleComfirmOrderDataStatus.UNCOMFIRMORDER.getValue());
            entity.setCreateTime(new Date());
            entity.setModifyTime(new Date());
            entity.setSapCreateDate(new Date());
            entity.setMaterialCategory(material.getCategoryName());
            entity.setMaterialDesc(material.getDescription());
            entity.setMaterialGroup(material.getProjectTypeGroup());
            entity.setMaterialName(material.getMaterialName());
            entity.setImportStatus(Constant.NO_INT);
            this.sampleComfirmDataMapper.insert(entity);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"sampleComfirmData"}, allEntries=true)
    public void genSampleOrder(SampleOrderCreateVO sampleOrders, String loginUserName) {
        if (sampleOrders == null) {
            throw new CommonException("\u53c2\u6570\u4e3a\u7a7a");
        }
        List<String> supplierSrmCodes = sampleOrders.getSupplierSrmCodes();
        if (supplierSrmCodes == null || supplierSrmCodes.isEmpty()) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
        }
        List<SampleComfirmData> sampleComfirmDatas = sampleOrders.getSampleComfirmDatas();
        if (sampleComfirmDatas == null || sampleComfirmDatas.isEmpty()) {
            throw new CommonException("\u6837\u54c1\u8ba4\u5b9a\u6570\u636e\u4e3a\u7a7a");
        }
        StringBuffer materialBuffer = new StringBuffer();
        for (SampleComfirmData sampleData : sampleComfirmDatas) {
            if (sampleData.getOrderStatus().intValue() == SampleComfirmOrderDataStatus.COMFIRMORDERED.getValue()) {
                throw new CommonException("\u6837\u54c1[" + sampleData.getMaterialCode() + "]\u5df2\u7ecf\u751f\u6210\u8ba4\u5b9a\u5355");
            }
            materialBuffer.append(sampleData.getMaterialCode() + ",");
        }
        for (String supplierSrmCode : supplierSrmCodes) {
            CompanyExample example = new CompanyExample();
            CompanyExample.Criteria criteria = example.createCriteria();
            criteria.andCompanyCodeEqualTo(supplierSrmCode);
            List companys = this.companyService.queryAllObjByExample(example);
            if (companys == null || companys.isEmpty()) {
                throw new CommonException("\u672a\u80fd\u627e\u5230\u4f9b\u5e94\u5546[" + supplierSrmCode + "]\u4fe1\u606f");
            }
            Company company = (Company)companys.get(0);
            SampleComfirmOrder sampleComfirmOrder = this.genSampleComfirmOrder(company, materialBuffer.toString(), loginUserName);
            String orderNo = sampleComfirmOrder.getOrderNo();
            for (SampleComfirmData sampleComfirmData : sampleComfirmDatas) {
                Material material = this.findMaterialByCode(sampleComfirmData.getMaterialCode());
                this.genSampleComfirmInfo(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmSpec(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmEsd(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmMsl(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmWeld(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmSilk(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmPack(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmAuth(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmEp(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmSp(orderNo, sampleComfirmData, material, company);
                this.genSampleComfirmDlevel(orderNo, sampleComfirmData, material, company);
                sampleComfirmData.setOrderStatus(SampleComfirmOrderDataStatus.COMFIRMORDERED.getValue());
                sampleComfirmData.setModifyTime(new Date());
                this.sampleComfirmDataMapper.updateByPrimaryKey(sampleComfirmData);
            }
        }
    }

    private SampleComfirmOrder genSampleComfirmOrder(Company company, String materialCodeBuffer, String loginUserName) {
        SampleComfirmOrder sampleComfirmOrder = new SampleComfirmOrder();
        sampleComfirmOrder.setContactPerson(company.getContacts());
        sampleComfirmOrder.setContactTel(company.getTelephone());
        sampleComfirmOrder.setCreateTime(new Date());
        sampleComfirmOrder.setCreatePerson(loginUserName);
        sampleComfirmOrder.setModifyTime(new Date());
        String orderNo = this.generateCodeService.getNextCode("SAMPLE_CONFIRM_ORDER_NO");
        sampleComfirmOrder.setOrderNo(orderNo);
        sampleComfirmOrder.setOrderStatus(SampleComfirmOrderStatus.UNSEND.getValue());
        sampleComfirmOrder.setSupplierAddr(company.getAddress());
        sampleComfirmOrder.setSupplierCode(company.getCompanyCode());
        sampleComfirmOrder.setSupplierName(company.getCompanyName());
        sampleComfirmOrder.setSupplierSapCode(company.getCompanySapCode());
        sampleComfirmOrder.setSupplierSrmCode(company.getCompanyCode());
        if (StringUtils.isNotBlank((String)materialCodeBuffer)) {
            materialCodeBuffer = materialCodeBuffer.substring(0, materialCodeBuffer.length() - 1);
            sampleComfirmOrder.setMaterialCode(materialCodeBuffer);
        }
        this.sampleComfirmOrderService.addObj(sampleComfirmOrder);
        return sampleComfirmOrder;
    }

    private void genSampleComfirmInfo(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmInfo sampleComfirmInfo = new SampleComfirmInfo();
        sampleComfirmInfo.setBrand(material.getBrandName());
        sampleComfirmInfo.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmInfo.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmInfo.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmInfo.setOrderNo(orderNo);
        sampleComfirmInfo.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmInfo.setSingleWeight(material.getWeight());
        sampleComfirmInfo.setStatus(SampleComfirmInfoStatus.UNSEND.getValue());
        sampleComfirmInfo.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmInfo.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmInfoService.addObj(sampleComfirmInfo);
    }

    private void genSampleComfirmSpec(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmSpec sampleComfirmSpec = new SampleComfirmSpec();
        sampleComfirmSpec.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmSpec.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmSpec.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmSpec.setOrderNo(orderNo);
        sampleComfirmSpec.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmSpec.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmSpec.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmSpecService.addObj(sampleComfirmSpec);
    }

    private void genSampleComfirmEsd(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmEsd sampleComfirmEsd = new SampleComfirmEsd();
        sampleComfirmEsd.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmEsd.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmEsd.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmEsd.setOrderNo(orderNo);
        sampleComfirmEsd.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmEsd.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmEsd.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmEsdService.addObj(sampleComfirmEsd);
    }

    private void genSampleComfirmMsl(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmMsl sampleComfirmMsl = new SampleComfirmMsl();
        sampleComfirmMsl.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmMsl.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmMsl.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmMsl.setOrderNo(orderNo);
        sampleComfirmMsl.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmMsl.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmMsl.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmMslService.addObj(sampleComfirmMsl);
    }

    private void genSampleComfirmWeld(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmWeld sampleComfirmWeld = new SampleComfirmWeld();
        sampleComfirmWeld.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmWeld.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmWeld.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmWeld.setOrderNo(orderNo);
        sampleComfirmWeld.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmWeld.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmWeld.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmWeldService.addObj(sampleComfirmWeld);
    }

    private void genSampleComfirmSilk(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmSilk sampleComfirmSilk = new SampleComfirmSilk();
        sampleComfirmSilk.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmSilk.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmSilk.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmSilk.setOrderNo(orderNo);
        sampleComfirmSilk.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmSilk.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmSilk.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmSilkService.addObj(sampleComfirmSilk);
    }

    private void genSampleComfirmPack(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmPack sampleComfirmPack = new SampleComfirmPack();
        sampleComfirmPack.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmPack.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmPack.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmPack.setOrderNo(orderNo);
        sampleComfirmPack.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmPack.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmPack.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmPackService.addObj(sampleComfirmPack);
    }

    private void genSampleComfirmAuth(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmAuth sampleComfirmAuth = new SampleComfirmAuth();
        sampleComfirmAuth.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmAuth.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmAuth.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmAuth.setOrderNo(orderNo);
        sampleComfirmAuth.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmAuth.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmAuth.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmAuthService.addObj(sampleComfirmAuth);
    }

    private void genSampleComfirmEp(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmEp sampleComfirmEp = new SampleComfirmEp();
        sampleComfirmEp.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmEp.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmEp.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmEp.setOrderNo(orderNo);
        sampleComfirmEp.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmEp.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmEp.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmEpService.addObj(sampleComfirmEp);
    }

    private void genSampleComfirmSp(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmSp sampleComfirmSp = new SampleComfirmSp();
        sampleComfirmSp.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmSp.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmSp.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmSp.setOrderNo(orderNo);
        sampleComfirmSp.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmSp.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmSp.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmSpService.addObj(sampleComfirmSp);
    }

    private void genSampleComfirmDlevel(String orderNo, SampleComfirmData sampleComfirmData, Material material, Company company) {
        SampleComfirmDlevel sampleComfirmDlevel = new SampleComfirmDlevel();
        sampleComfirmDlevel.setMaterialCode(sampleComfirmData.getMaterialCode());
        sampleComfirmDlevel.setMaterialDesc(sampleComfirmData.getMaterialDesc());
        sampleComfirmDlevel.setMaterialName(sampleComfirmData.getMaterialName());
        sampleComfirmDlevel.setOrderNo(orderNo);
        sampleComfirmDlevel.setSapOrderNo(sampleComfirmData.getSapOrderNo());
        sampleComfirmDlevel.setSupplierSrmCode(company.getCompanyCode());
        sampleComfirmDlevel.setSupplierSapCode(company.getCompanySapCode());
        this.sampleComfirmDlevelService.addObj(sampleComfirmDlevel);
    }
}

