/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.sample.entity.SampleComfirmInfo;
import com.els.base.sample.entity.SampleComfirmInfoExample;
import com.els.base.sample.entity.SampleComfirmOrder;
import com.els.base.sample.entity.SampleComfirmOrderExample;
import com.els.base.sample.enums.SampleComfirmInfoStatus;
import com.els.base.sample.service.SampleConfirmService;
import com.els.base.sample.vo.SampleComfirmInfoVO;
import com.els.base.sample.vo.SampleComfirmOrderVO;
import com.els.base.sample.vo.SampleComfirmQualifiedVO;
import com.els.base.sample.vo.SampleComfirmSendVO;
import com.els.base.sample.web.controller.command.PurViewDetailCommand;
import com.els.base.sample.web.controller.command.SampleCommandInvoker;
import com.els.base.sample.web.controller.command.SupEditCommand;
import com.els.base.sample.web.controller.command.SupViewDetailCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6837\u54c1\u8ba4\u5b9a\u6c47\u603b")
@Controller
@RequestMapping(value={"sampleComfirm"})
public class SampleComfirmController {
    @Resource
    protected SampleCommandInvoker invoker;
    @Resource
    protected SampleConfirmService sampleConfirmService;

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6c47\u603b-\u4f9b\u5e94\u5546\u7ef4\u5ea6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SampleComfirmOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findBySupplier"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmOrderVO>> purFindBySupplier(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SampleComfirmOrderExample example = new SampleComfirmOrderExample();
        example.setPageView(new PageView<SampleComfirmOrder>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<SampleComfirmOrderVO> pageData = this.sampleConfirmService.queryByPageOfSupplier(example, pageNo, pageSize);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6c47\u603b-\u6837\u54c1\u7ef4\u5ea6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SampleComfirmOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findBySample"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmInfoVO>> purFindBySample(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SampleComfirmInfoExample example = new SampleComfirmInfoExample();
        example.setPageView(new PageView<SampleComfirmInfo>(pageNo, pageSize));
        if (wapper != null) {
            SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView<SampleComfirmInfoVO> pageData = this.sampleConfirmService.queryByPageOfSample(example, pageNo, pageSize);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546-\u6c47\u603b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SampleComfirmOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findBySample"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmInfo>> supFindBySample(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SampleComfirmInfoExample example = new SampleComfirmInfoExample();
        example.setPageView(new PageView<SampleComfirmInfo>(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        String currentCompanyCode = CompanyUtils.currentCompany().getCompanyCode();
        criteria.andSupplierSrmCodeEqualTo(currentCompanyCode);
        criteria.andStatusNotEqualTo(SampleComfirmInfoStatus.UNSEND.getValue());
        PageView<SampleComfirmInfo> pageData = this.sampleConfirmService.supQueryByPageOfSample(example, pageNo, pageSize);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6c47\u603b-\u4f9b\u5e94\u5546\u7ef4\u5ea6-\u6279\u91cf\u53d1\u9001")
    @RequestMapping(value={"service/pur/sendBySupplier"})
    @ResponseBody
    public ResponseResult<String> purSendBySupplier(@RequestBody List<String> orderNos) {
        this.sampleConfirmService.purSendBySupplier(orderNos, CompanyUtils.currentCompany().getCompanyCode(), SpringSecurityUtils.getLoginUser().getNickName());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6c47\u603b-\u6837\u54c1\u7ef4\u5ea6-\u6279\u91cf\u53d1\u9001")
    @RequestMapping(value={"service/pur/sendBySample"})
    @ResponseBody
    public ResponseResult<String> purSendBySample(@RequestBody List<SampleComfirmSendVO> list) {
        this.sampleConfirmService.purSendBySample(list, CompanyUtils.currentCompany().getCompanyCode(), SpringSecurityUtils.getLoginUser().getNickName());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6c47\u603b-\u4f9b\u5e94\u5546\u7ef4\u5ea6-\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/pur/obsoleteBySupplier"})
    @ResponseBody
    public ResponseResult<String> purObsoleteBySupplier(@RequestBody List<String> orderNos) {
        this.sampleConfirmService.purObsoleteBySupplier(orderNos, CompanyUtils.currentCompany().getCompanyCode());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6c47\u603b-\u6837\u54c1\u7ef4\u5ea6-\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/pur/obsoleteBySample"})
    @ResponseBody
    public ResponseResult<String> purObsoleteBySample(@RequestBody List<SampleComfirmSendVO> list) {
        this.sampleConfirmService.purObsoleteBySample(list, CompanyUtils.currentCompany().getCompanyCode());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6837\u54c1\u8ba4\u5b9a-\u5408\u683c")
    @RequestMapping(value={"service/pur/qualified"})
    @ResponseBody
    public ResponseResult<String> purComfirmSampleQualified(@RequestBody List<SampleComfirmQualifiedVO> list) {
        String companyCode = CompanyUtils.currentCompany().getCompanyCode();
        this.sampleConfirmService.purComfirmSample(list, SampleComfirmInfoStatus.QUALIFIED.getValue(), companyCode);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6837\u54c1\u8ba4\u5b9a-\u4e0d\u5408\u683c")
    @RequestMapping(value={"service/pur/unqualified"})
    @ResponseBody
    public ResponseResult<String> purComfirmSampleUnqualified(@RequestBody List<SampleComfirmQualifiedVO> list) {
        String companyCode = CompanyUtils.currentCompany().getCompanyCode();
        this.sampleConfirmService.purComfirmSample(list, SampleComfirmInfoStatus.UNQUALIFIED.getValue(), companyCode);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546-\u6c47\u603b-\u6279\u91cf\u786e\u8ba4")
    @RequestMapping(value={"service/sup/confirmSample"})
    @ResponseBody
    public ResponseResult<String> supConfirmSample(@RequestBody List<SampleComfirmSendVO> list) {
        Company supCompany = CompanyUtils.currentCompany();
        this.sampleConfirmService.supConfirmSample(list, supCompany.getCompanyCode());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546-\u6c47\u603b-\u6279\u91cf\u62d2\u7edd")
    @RequestMapping(value={"service/sup/refuseSample"})
    @ResponseBody
    public ResponseResult<String> supRefuseSample(@RequestBody List<SampleComfirmSendVO> list) {
        Company supCompany = CompanyUtils.currentCompany();
        this.sampleConfirmService.supRefuseSample(list, supCompany.getCompanyCode());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546-\u660e\u7ec6-\u63d0\u4ea4\u6837\u54c1")
    @RequestMapping(value={"service/sup/submitSample"})
    @ResponseBody
    public ResponseResult<String> supSubmitSample(@RequestBody List<SampleComfirmSendVO> list) {
        Company supCompany = CompanyUtils.currentCompany();
        this.sampleConfirmService.supSubmitSample(list, supCompany.getCompanyCode());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6837\u54c1\u6c47\u603b-\u660e\u7ec6-\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="sapOrderNo", required=true, value="\u6e90\u5355\u636e\u53f7", paramType="query", dataType="String"), @ApiImplicitParam(name="materialCode", required=true, value="\u7269\u6599\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/pur/detail/supplierInfo"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmOrder>> purDetailSupplierInfo(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) String sapOrderNo, @RequestParam(required=true) String materialCode) {
        PageView<SampleComfirmOrder> pageData = this.sampleConfirmService.purDetailSupplierInfo(pageNo, pageSize, sapOrderNo, materialCode);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9-\u67e5\u770b\u8be6\u60c5")
    @RequestMapping(value={"service/purViewDetail"})
    @ResponseBody
    public ResponseResult<SampleComfirmOrder> purViewDetail(@RequestParam String id) {
        PurViewDetailCommand cmd = new PurViewDetailCommand(id);
        SampleComfirmOrder sampleComfirmOrder = this.invoker.invoke(cmd);
        return ResponseResult.success(sampleComfirmOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u65b9-\u67e5\u770b\u8be6\u60c5-\u5355\u4e2a\u7269\u6599")
    @RequestMapping(value={"service/supViewDetail"})
    @ResponseBody
    public ResponseResult<SampleComfirmInfo> supViewDetail(@RequestParam String id) {
        SupViewDetailCommand cmd = new SupViewDetailCommand(id);
        SampleComfirmInfo sampleComfirmInfo = this.invoker.invoke(cmd);
        return ResponseResult.success(sampleComfirmInfo);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u65b9-\u67e5\u770b\u8be6\u60c5-\u4fdd\u5b58")
    @RequestMapping(value={"service/supEdit"})
    @ResponseBody
    public ResponseResult<String> supEdit(@RequestBody SampleComfirmInfo sampleComfirmInfo) {
        SupEditCommand cmd = new SupEditCommand(sampleComfirmInfo);
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }
}

