/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.sample.entity.SampleComfirmData;
import com.els.base.sample.entity.SampleComfirmDataExample;
import com.els.base.sample.service.SampleComfirmDataService;
import com.els.base.sample.utils.SampleComfirmExcelUtils;
import com.els.base.sample.vo.SampleOrderCreateVO;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7")
@Controller
@RequestMapping(value={"sampleComfirmData"})
public class SampleComfirmDataController {
    @Resource
    protected SampleComfirmDataService sampleComfirmDataService;
    @Resource
    protected MaterialService materialService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SampleComfirmData sampleComfirmData) {
        this.sampleComfirmDataService.addObj(sampleComfirmData);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<SampleComfirmData> sampleComfirmDataList) {
        if (CollectionUtils.isEmpty(sampleComfirmDataList)) {
            throw new CommonException("data\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        for (SampleComfirmData sampleComfirmData : sampleComfirmDataList) {
            this.sampleComfirmDataService.modifyObj(sampleComfirmData);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sampleComfirmDataService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SampleComfirmData", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmData>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SampleComfirmDataExample example = new SampleComfirmDataExample();
        example.setPageView(new PageView<SampleComfirmData>(pageNo, pageSize));
        example.setOrderByClause("SAP_ORDER_NO DESC");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.sampleComfirmDataService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7")
    @RequestMapping(value={"service/BatchDelete"})
    @ResponseBody
    public ResponseResult<String> BatchDelete(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ids.forEach(id -> this.sampleComfirmDataService.deleteObjById(id));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4ecePLM\u7cfb\u7edf\u5bfc\u5165\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7\u5355\u6570\u636e")
    @RequestMapping(value={"front/importFromPlm/{accessToken}"})
    @ResponseBody
    public ResponseResult<String> importFromPlm(@PathVariable(value="accessToken") String accessToken, @RequestBody List<SampleComfirmData> list) {
        this.sampleComfirmDataService.importFromPlm(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/addBuild"})
    @ResponseBody
    public ResponseResult<String> addBuild(@RequestBody List<SampleComfirmData> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("data\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        for (SampleComfirmData sampleComfirmData : list) {
            sampleComfirmData.setCreateOrderPerson(SpringSecurityUtils.getLoginUserName());
        }
        this.sampleComfirmDataService.importFromPlm(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7269\u6599\u67e5\u8be2\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/findSampleComfirmData"})
    @ResponseBody
    public ResponseResult<List<SampleComfirmData>> findSampleComfirmData(@RequestBody List<SampleComfirmData> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("data\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        for (SampleComfirmData sampleComfirmData : list) {
            SampleComfirmDataExample sampleComfirmDataExample = new SampleComfirmDataExample();
            sampleComfirmDataExample.createCriteria().andMaterialCodeEqualTo(sampleComfirmData.getMaterialCode());
            List tempSampleComfirmData = this.sampleComfirmDataService.queryAllObjByExample(sampleComfirmDataExample);
            if (CollectionUtils.isNotEmpty(tempSampleComfirmData)) {
                ArrayList<SampleComfirmData> newSampleComfirmData = new ArrayList<SampleComfirmData>();
                newSampleComfirmData.add(sampleComfirmData);
                return ResponseResult.success(newSampleComfirmData);
            }
            sampleComfirmData.setCreateOrderPerson(SpringSecurityUtils.getLoginUserName());
        }
        this.sampleComfirmDataService.importFromPlm(list);
        return ResponseResult.success(null);
    }

    @ApiOperation(httpMethod="POST", value="\u751f\u6210\u6837\u54c1\u8ba4\u5b9a\u5355")
    @RequestMapping(value={"service/genSampleOrder"})
    @ResponseBody
    public ResponseResult<String> genSampleOrder(@RequestBody SampleOrderCreateVO sampleOrders) {
        this.sampleComfirmDataService.genSampleOrder(sampleOrders, SpringSecurityUtils.getLoginUser().getNickName());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7\u6279\u91cf\u5bfc\u51faExcel")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(String queryParams, HttpServletResponse response) {
        try {
            SampleComfirmDataExample comfirmDataExample = new SampleComfirmDataExample();
            SampleComfirmDataExample.Criteria createCriteria = comfirmDataExample.createCriteria().andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion(createCriteria, queryParamWapper);
            }
            List sampleConfirmDataList = this.sampleComfirmDataService.queryAllObjByExample(comfirmDataExample);
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndMoudleKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, sampleConfirmDataList, (String)"\u6837\u54c1\u8ba4\u5b9a", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7\u9009\u4e2d\u5bfc\u51faExcel")
    @RequestMapping(value={"service/downloadExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadExcelBySelect(@ApiParam(value="\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7\u5355id", defaultValue="") @RequestParam(defaultValue="") String idList, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((String)idList)) {
                throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
            }
            SampleComfirmDataExample comfirmDataExample = new SampleComfirmDataExample();
            comfirmDataExample.createCriteria().andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIdIn((List)Arrays.asList(idList.split(",")));
            List sampleConfirmDataList = this.sampleComfirmDataService.queryAllObjByExample(comfirmDataExample);
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndMoudleKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, sampleConfirmDataList, (String)"\u6837\u54c1\u8ba4\u5b9a", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> getTitleAndMoudleKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"sapOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"orderStatus"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b", (String)"materialCategory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7ec4", (String)"materialGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f7f\u7528\u673a\u578b", (String)"useModel"));
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey((String)"\u5236\u5355\u65f6\u95f4", (String)"sapCreateDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5236\u5355\u4eba", (String)"createOrderPerson"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @RequestMapping(value={"service/downloadExcelTemplate"})
    @ResponseBody
    public String downloadExcelTemplate(HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException {
        String fileName = "\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7\u6a21\u677f.xls";
        this.setDownloadHeader(fileName, response);
        SampleComfirmExcelUtils.export(response.getOutputStream());
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20excel\u6a21\u677f\u5bfc\u5165\u6570\u636e")
    @RequestMapping(value={"service/uploadForImportExcelTemplate"})
    @ResponseBody
    public ResponseResult<List<? extends SampleComfirmData>> uploadForImportExcelTemplate(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        MultipartFile file = (MultipartFile)fileMap.entrySet().iterator().next().getValue();
        List<? extends SampleComfirmData> iTargets = null;
        try {
            iTargets = SampleComfirmExcelUtils.importFromExcel(file.getInputStream());
        }
        catch (IllegalArgumentException e) {
            throw new CommonException("EXCEL\u8868\u683c\u5f0f\u5f02\u5e38,\u8bf7\u6309\u7167EXCEL\u6a21\u677f\u683c\u5f0f\u586b\u5199");
        }
        iTargets.stream().forEach(target -> {
            Assert.isNotNull(target.getMaterialCode(), "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            MaterialExample materialExample = new MaterialExample();
            materialExample.createCriteria().andMaterialCodeEqualTo(target.getMaterialCode());
            List materials = this.materialService.queryAllObjByExample(materialExample);
            if (CollectionUtils.isEmpty(materials)) {
                throw new CommonException(String.format("\u7269\u6599\u7f16\u7801[%s]\u4e0d\u5b58\u5728,\u8bf7\u66f4\u6b63\u540e\u518d\u91cd\u65b0\u5bfc\u5165", target.getMaterialCode()));
            }
            target.setMaterialDesc(((Material)materials.get(0)).getDescription());
            target.setMaterialName(((Material)materials.get(0)).getMaterialName());
            target.setMaterialCategory(((Material)materials.get(0)).getCategoryName());
        });
        return ResponseResult.success(iTargets);
    }

    private void setDownloadHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream;charset=UTF-8");
    }
}

