ALTER TABLE "T_BASE_COMPANY"
ADD ( "ENGLISH_COMPANY_NAME" NVARCHAR2(255) NULL  ) 
ADD ( "ENGLISH_ADDRESS" NVARCHAR2(255) NULL  ) 
ADD ( "REGISTERED_CAPITAL" NVARCHAR2(100) NULL  )
ADD ( "ACTING_BRAND" NVARCHAR2(255) NULL  ) 
ADD ( "COMPANY_ESTABLISHMENT_TIME" DATE   ) 
ADD ( "LAND_AREA" NVARCHAR2(100) NULL  ) 
ADD ( "TOTAL_BUILDING_AREA" NVARCHAR2(100) NULL  ) 
ADD ( "WORKPLACE_OWNERSHIP" NVARCHAR2(100) NULL  ) 
ADD ( "PLANT_AREA" NVARCHAR2(100) NULL  ) 
ADD ( "PLANT_USE_RATE" NVARCHAR2(100) NULL  ) 
ADD ( "MANAGER_NUMBER" NVARCHAR2(50) NULL  ) 
ADD ( "SALESMAN_NUMBER" NVARCHAR2(50) NULL  ) 
ADD ( "TECHNICIAN_NUMBER" NVARCHAR2(50) NULL  ) 
ADD ( "QUALITY_INSPECTOR_NUMBER" NVARCHAR2(50) NULL  ) 
ADD ( "WORKER_NUMBER" NVARCHAR2(50) NULL  ) 
ADD ( "TOTAL_NUMBER" NVARCHAR2(50) NULL  ) 
ADD ( "PRODUCT_CAPACITY" NVARCHAR2(50) NULL  ) 
ADD ( "PRODUCT_SUPPLY_CYCLE" NVARCHAR2(50) NULL  ) 
ADD ( "FEEDBACK_TIME" DATE  ) 
ADD ( "PPM_PERFORMANCE" NVARCHAR2(50) NULL  ) 
ADD ( "AGENT_TIME" DATE  ) 
ADD ( "ACTING_PRODUCTS" NVARCHAR2(100) NULL  ) 
ADD ( "DELIVERY_MODE" NVARCHAR2(100) NULL  ) 
ADD ( "IS_FIELD_SERVICE" NUMBER(11) NULL  )
ADD ( "BUSINESS_LICENSE_NUMBER" NVARCHAR2(100) NULL  )
ADD ( "CAPITAL_TYPE" VARCHAR(100) NULL  )
ADD ( "COMPANY_ENGLISH_ABBREVIATION" VARCHAR(100) NULL  )
ADD ( "FINISH_FLAG" NUMBER(7) default 0  );


COMMENT ON COLUMN "T_BASE_COMPANY"."ENGLISH_COMPANY_NAME" IS '企业英文名称';

COMMENT ON COLUMN "T_BASE_COMPANY"."ENGLISH_ADDRESS" IS '英文地址';

COMMENT ON COLUMN "T_BASE_COMPANY"."REGISTERED_CAPITAL" IS '注册资本';

COMMENT ON COLUMN "T_BASE_COMPANY"."ACTING_BRAND" IS '代理品牌';

COMMENT ON COLUMN "T_BASE_COMPANY"."COMPANY_ESTABLISHMENT_TIME" IS '公司成立时间';

COMMENT ON COLUMN "T_BASE_COMPANY"."LAND_AREA" IS '占地面积';

COMMENT ON COLUMN "T_BASE_COMPANY"."TOTAL_BUILDING_AREA" IS '总建筑面积';

COMMENT ON COLUMN "T_BASE_COMPANY"."WORKPLACE_OWNERSHIP" IS '工作场所所有权';

COMMENT ON COLUMN "T_BASE_COMPANY"."PLANT_AREA" IS '厂房面积';

COMMENT ON COLUMN "T_BASE_COMPANY"."PLANT_USE_RATE" IS '厂房使用率';

COMMENT ON COLUMN "T_BASE_COMPANY"."MANAGER_NUMBER" IS '管理人员数';

COMMENT ON COLUMN "T_BASE_COMPANY"."SALESMAN_NUMBER" IS '业务人员数';

COMMENT ON COLUMN "T_BASE_COMPANY"."TECHNICIAN_NUMBER" IS '工程技术人员数';

COMMENT ON COLUMN "T_BASE_COMPANY"."QUALITY_INSPECTOR_NUMBER" IS '质量人员数';

COMMENT ON COLUMN "T_BASE_COMPANY"."WORKER_NUMBER" IS '工人数';

COMMENT ON COLUMN "T_BASE_COMPANY"."TOTAL_NUMBER" IS '总人数';

COMMENT ON COLUMN "T_BASE_COMPANY"."PRODUCT_CAPACITY" IS '产品产能';

COMMENT ON COLUMN "T_BASE_COMPANY"."PRODUCT_SUPPLY_CYCLE" IS '产品供货周期';

COMMENT ON COLUMN "T_BASE_COMPANY"."FEEDBACK_TIME" IS 'BD反馈时间';

COMMENT ON COLUMN "T_BASE_COMPANY"."PPM_PERFORMANCE" IS 'PPM表现';

COMMENT ON COLUMN "T_BASE_COMPANY"."AGENT_TIME" IS '代理证时间';

COMMENT ON COLUMN "T_BASE_COMPANY"."ACTING_PRODUCTS" IS '代理产品';

COMMENT ON COLUMN "T_BASE_COMPANY"."DELIVERY_MODE" IS '交货方式';

COMMENT ON COLUMN "T_BASE_COMPANY"."IS_FIELD_SERVICE" IS '是否提供现场服务(1提供,0不提供)';

COMMENT ON COLUMN "T_BASE_COMPANY"."BUSINESS_LICENSE_NUMBER" IS '营业执照注册号';

COMMENT ON COLUMN "T_BASE_COMPANY"."CAPITAL_TYPE" IS '资本类型';

COMMENT ON COLUMN "T_BASE_COMPANY"."COMPANY_ENGLISH_ABBREVIATION" IS '公司英文简称';

comment on column "T_BASE_COMPANY_CONTACTS"."FINISH_FLAG" is '完成标识符(0=未完成，1=已完成)';
