
-- ----------------------------
-- Table structure for T_BASE_SAMPLE_COMFIRM_SILK
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_COMFIRM_SILK" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"IS_INCLUDE_SILK" NUMBER NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"ATTACHMENT" CLOB NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_COMFIRM_SILK" IS '明细-产品丝印or标签';
COMMENT ON COLUMN "T_BASE_SAMPLE_COMFIRM_SILK"."IS_INCLUDE_SILK" IS '是否包含丝印/标签';
COMMENT ON COLUMN "T_BASE_SAMPLE_COMFIRM_SILK"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_COMFIRM_SILK"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_COMFIRM_WELD
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_COMFIRM_WELD" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"IS_NEED_WELD" NUMBER NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"ATTACHMENT" CLOB NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_COMFIRM_WELD" IS '明细-焊接信息';
COMMENT ON COLUMN "T_BASE_SAMPLE_COMFIRM_WELD"."IS_NEED_WELD" IS '是否需要焊接';
COMMENT ON COLUMN "T_BASE_SAMPLE_COMFIRM_WELD"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_COMFIRM_WELD"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_AUTH
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_AUTH" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"AUTH_WAY" NVARCHAR2(255) NULL ,
"AUTH_NAME" NVARCHAR2(255) NULL ,
"AUTH_CODE" NVARCHAR2(255) NULL ,
"BEGIN_INDATE" DATE NULL ,
"END_INDATE" DATE NULL ,
"DID" NVARCHAR2(255) NULL ,
"RF_TEST_REPORT" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"QDL_ATTACHMENT" CLOB NULL ,
"BOM_ATTACHMENT" CLOB NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_AUTH" IS '明细-认证信息';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."AUTH_WAY" IS '产品认证方式';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."AUTH_NAME" IS '产品认证名称';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."AUTH_CODE" IS '产品认证编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."BEGIN_INDATE" IS '有效期起';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."END_INDATE" IS '有效期止';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."DID" IS 'DID';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."RF_TEST_REPORT" IS 'RF测试报告（第三方）';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_AUTH"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_DATA
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_DATA" (
"ID" NVARCHAR2(32) NOT NULL ,
"COMPANY_ID" NVARCHAR2(32) NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"ORDER_STATUS" NUMBER(2) NULL ,
"MATERIAL_CATEGORY" NVARCHAR2(255) NULL ,
"MATERIAL_GROUP" NVARCHAR2(255) NULL ,
"MATERIAL_CODE" NVARCHAR2(255) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"USE_MODEL" NVARCHAR2(255) NULL ,
"SAP_CREATE_DATE" DATE NULL ,
"CREATE_ORDER_PERSON" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"SAP_MODIFY_DATE" DATE NULL ,
"CREATE_TIME" DATE NULL ,
"MODIFY_TIME" DATE NULL ,
"ATTACHMENT_ADDR" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_DATA" IS '样品认定申请';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."ID" IS 'ID主键';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."SAP_ORDER_NO" IS '单据号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."ORDER_STATUS" IS '单据状态（0未生成认定单，1已生成认定单）';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."MATERIAL_CATEGORY" IS '物料分类';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."MATERIAL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."USE_MODEL" IS '使用机型';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."SAP_CREATE_DATE" IS '制单时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."CREATE_ORDER_PERSON" IS '制单人';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."SAP_MODIFY_DATE" IS 'SAP修改时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."MODIFY_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."ATTACHMENT_ADDR" IS '附件地址';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DATA"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_DLEVEL
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_DLEVEL" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"DEVEICE_LEVEL" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"ATTACHMENT" CLOB NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_DLEVEL" IS '明细- 器件等级';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DLEVEL"."DEVEICE_LEVEL" IS '器件等级';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DLEVEL"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_DLEVEL"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_EP
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_EP" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"DOC_SUBMIT_LEVEL" NVARCHAR2(255) NULL ,
"MATERIAL_SUBMIT_LEVEL" NVARCHAR2(255) NULL ,
"PRODUCT_SPEC" NVARCHAR2(255) NULL ,
"DETECTION_ORG" NVARCHAR2(255) NULL ,
"REPORT_CODE" NVARCHAR2(255) NULL ,
"DETECTION_DATE" DATE NULL ,
"EXT_CD" NVARCHAR2(255) NULL ,
"EXT_PB" NVARCHAR2(255) NULL ,
"EXT_HG" NVARCHAR2(255) NULL ,
"EXT_CRVI" NVARCHAR2(255) NULL ,
"EXT_PBB" NVARCHAR2(255) NULL ,
"EXT_PBDE" NVARCHAR2(255) NULL ,
"MATERIAL_NAME1" NVARCHAR2(255) NULL ,
"MATERIAL_SPEC1" NVARCHAR2(255) NULL ,
"MATERIAL_NAME2" NVARCHAR2(255) NULL ,
"MATERIAL_SPEC2" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"ATTACHMENT" CLOB NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_EP" IS '明细-环保资料';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."DOC_SUBMIT_LEVEL" IS '资料提交级别';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."MATERIAL_SUBMIT_LEVEL" IS '材料提交级别';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."PRODUCT_SPEC" IS '产品规格';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."DETECTION_ORG" IS '检测机构';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."REPORT_CODE" IS '报告编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."DETECTION_DATE" IS '检测日期';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."EXT_CD" IS 'Cd(<100ppm)';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."EXT_PB" IS 'Pb(<1000ppm)';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."EXT_HG" IS 'Hg(<1000ppm)';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."EXT_CRVI" IS 'CrVI(<1000ppm)';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."EXT_PBB" IS 'PBB(<1000ppm)';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."EXT_PBDE" IS 'PBDE(<1000ppm)';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."MATERIAL_NAME1" IS '一阶材料名称';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."MATERIAL_SPEC1" IS '一阶材料规格';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."MATERIAL_NAME2" IS '二阶材料名称';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."MATERIAL_SPEC2" IS '二阶材料规格';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_EP"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_ESD
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_ESD" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"IS_STATIC_ELEC" NUMBER(1) NULL ,
"DEVICE_CATEGORY" NVARCHAR2(255) NULL ,
"ESD_HBM_STANDARD" NVARCHAR2(255) NULL ,
"ESD_HBM_LEVEL" NVARCHAR2(255) NULL ,
"ESD_CDM_STANDARD" NVARCHAR2(255) NULL ,
"ESD_CDM_LEVEL" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_ESD" IS '明细-ESD';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."ID" IS 'ID主键';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."IS_STATIC_ELEC" IS '是否静电敏感件';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."DEVICE_CATEGORY" IS '器件类别';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."ESD_HBM_STANDARD" IS 'ESD HBM 标准';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."ESD_HBM_LEVEL" IS 'ESD HBM 等级';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."ESD_CDM_STANDARD" IS 'ESD CDM 标准';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."ESD_CDM_LEVEL" IS 'ESD CDM 等级';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ESD"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_INFO
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_INFO" (
"ID" NVARCHAR2(32) NOT NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"BRAND" NVARCHAR2(255) NULL ,
"MANUFACTURER_MODEL" NVARCHAR2(255) NULL ,
"SINGLE_WEIGHT" NVARCHAR2(255) NULL ,
"ORIGIN_PLACE" NVARCHAR2(255) NULL ,
"WAFER_FACTORY" NVARCHAR2(255) NULL ,
"SEAL_TEST_FACTORY" NVARCHAR2(255) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"STATUS" NUMBER(2) NULL ,
"MUST_FINISH_TIME" DATE NULL ,
"MATRTIL_GROUP" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"PURCHASER_SRM_CODE" NVARCHAR2(32) NULL ,
"SEND_TIME" DATE NULL ,
"REMARK" NVARCHAR2(255) NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_INFO" IS '明细-物料信息';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."ID" IS 'ID主键';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."ORDER_NO" IS 'SRM单据号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."MANUFACTURER_MODEL" IS '制造商型号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."SINGLE_WEIGHT" IS '单重';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."ORIGIN_PLACE" IS '原产地';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."WAFER_FACTORY" IS '晶圆厂';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."SEAL_TEST_FACTORY" IS '封测厂';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."SAP_ORDER_NO" IS 'SAP单据号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."STATUS" IS '状态（0未发送，1未确认，2已拒绝，3打样中，4待检，5合格，6不合格，7已作废）';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."MUST_FINISH_TIME" IS '要求完成时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."MATRTIL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."PURCHASER_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_INFO"."REMARK" IS '备注';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_MSL
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_MSL" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"IS_DAMP_DEVICE" NUMBER(1) NULL ,
"MSL_STANDARD" NVARCHAR2(255) NULL ,
"ESD_HBM_LEVEL" NVARCHAR2(255) NULL ,
"IS_DAMPPROOF_PACK" NUMBER(1) NULL ,
"IS_TEMP_INDICATE_CARD" NUMBER(1) DEFAULT ''  NULL ,
"IS_DRY_DOSE" NUMBER(1) NULL ,
"IS_TEMP_INDICATE_LABEL" NUMBER(1) NULL ,
"IS_MSL_WARN_LABEL" NUMBER(1) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_MSL" IS '明细-MSL';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."ID" IS 'ID主键';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."IS_DAMP_DEVICE" IS '是否潮敏器件';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."MSL_STANDARD" IS 'MSL标准';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."ESD_HBM_LEVEL" IS 'ESD HBM等级';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."IS_DAMPPROOF_PACK" IS '防潮包装袋';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."IS_TEMP_INDICATE_CARD" IS '温度指示卡';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."IS_DRY_DOSE" IS '干燥剂';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."IS_TEMP_INDICATE_LABEL" IS '温度指示标签';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."IS_MSL_WARN_LABEL" IS 'MSL警示标贴';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_MSL"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_ORDER
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_ORDER" (
"ID" NVARCHAR2(32) NOT NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"ORDER_STATUS" NUMBER(2) NULL ,
"SUPPLIER_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_NAME" NVARCHAR2(255) NULL ,
"SUPPLIER_ADDR" NVARCHAR2(255) NULL ,
"SEND_TIME" DATE NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE NULL ,
"MODIFY_TIME" DATE NULL ,
"CONTACT_PERSON" NVARCHAR2(255) NULL ,
"CONTACT_TEL" NVARCHAR2(255) NULL ,
"PURCHASER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_ORDER" IS '汇总-生成的认定单';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."ID" IS 'ID主键';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."ORDER_NO" IS '单据号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."ORDER_STATUS" IS '单据状态（0未发送，1未认定，2部分认定，3已认定，4已作废）';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."SUPPLIER_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."SUPPLIER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."SUPPLIER_ADDR" IS '供应商地址';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."MODIFY_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."CONTACT_PERSON" IS '联系人';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."CONTACT_TEL" IS '联系电话';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."PURCHASER_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."SAP_ORDER_NO" IS '源单据号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_ORDER"."MATERIAL_CODE" IS '物料号';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_PACK
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_PACK" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"PACKAGE_WAY" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"ATTACHMENT" CLOB NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_PACK" IS '明细-包装信息';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_PACK"."PACKAGE_WAY" IS '包装方式';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_PACK"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_PACK"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_SP
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_SP" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"PRODUCT_CREATE_DATE" DATE NULL ,
"PRODUCT_END_SUP_DATE" DATE NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_SP" IS '明细-产品供应保证';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SP"."PRODUCT_CREATE_DATE" IS '产品量产日期';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SP"."PRODUCT_END_SUP_DATE" IS '产品供应截至日期';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SP"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SP"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Table structure for T_BASE_SAMPLE_CONFIRM_SPEC
-- ----------------------------
CREATE TABLE "T_BASE_SAMPLE_CONFIRM_SPEC" (
"ID" NVARCHAR2(32) NOT NULL ,
"MATERIAL_CODE" NVARCHAR2(32) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_NO" NVARCHAR2(32) NULL ,
"SAP_ORDER_NO" NVARCHAR2(32) NULL ,
"SPECIFICATION_VERSION" NVARCHAR2(255) NULL ,
"SUPPLIER_SRM_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_SAP_CODE" NVARCHAR2(32) NULL ,
"ATTACHMENT" CLOB NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "T_BASE_SAMPLE_CONFIRM_SPEC" IS '明细-规格书';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."ID" IS 'ID主键';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."ORDER_NO" IS 'SRM单据号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."SAP_ORDER_NO" IS 'SAP单据号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."SPECIFICATION_VERSION" IS '规格书版本号';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."SUPPLIER_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_SAMPLE_CONFIRM_SPEC"."SUPPLIER_SAP_CODE" IS '供应商SAP编码';

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_COMFIRM_SILK
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_COMFIRM_SILK
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_COMFIRM_SILK" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_COMFIRM_SILK
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_COMFIRM_SILK" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_COMFIRM_WELD
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_COMFIRM_WELD
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_COMFIRM_WELD" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_COMFIRM_WELD
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_COMFIRM_WELD" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_AUTH
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_AUTH
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_AUTH" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_DATA
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_DATA
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_DATA" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_DATA
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_DATA" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_DLEVEL
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_DLEVEL
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_DLEVEL" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_DLEVEL
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_DLEVEL" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_EP
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_EP
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_EP" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_EP
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_EP" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_ESD
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_ESD
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_ESD" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_ESD
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_ESD" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_INFO
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_INFO
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_INFO" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_INFO
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_INFO" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_MSL
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_MSL
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_MSL" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_MSL
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_MSL" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_ORDER
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_ORDER
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_ORDER" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_ORDER
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_ORDER" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_PACK
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_PACK
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_PACK" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_PACK
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_PACK" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_SP
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_SP
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_SP" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_SP
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_SP" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table T_BASE_SAMPLE_CONFIRM_SPEC
-- ----------------------------

-- ----------------------------
-- Checks structure for table T_BASE_SAMPLE_CONFIRM_SPEC
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_SPEC" ADD CHECK ("ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table T_BASE_SAMPLE_CONFIRM_SPEC
-- ----------------------------
ALTER TABLE "T_BASE_SAMPLE_CONFIRM_SPEC" ADD PRIMARY KEY ("ID");
