/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.utils;

import com.els.base.core.utils.Assert;
import com.els.base.sample.entity.SampleComfirmData;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.beanutils.PropertyUtils;

public class SampleComfirmExcelUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(ServletOutputStream os) throws RowsExceededException, WriteException, IOException, ParseException {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(SampleComfirmData.class);
        List<String> dataList = Arrays.asList(propertyDescriptors).stream().map(propertyDescriptor -> propertyDescriptor.getName()).collect(Collectors.toList());
        Assert.isNotEmpty(dataList, "\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        List<TitleAndModelKey> titleAndModelKeys = SampleComfirmExcelUtils.transfromProDef(dataList);
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)os, titleAndModelKeys, null, (String)"\u5bfc\u5165\u6837\u54c1\u8ba4\u5b9a\u7533\u8bf7", null, (int)0);
        try {
            writableWorkbook.write();
            os.flush();
        }
        finally {
            writableWorkbook.close();
            os.close();
        }
    }

    private static List<TitleAndModelKey> transfromProDef(List<String> dataList) {
        Assert.isNotEmpty(dataList, "\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b", (String)"materialCategory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f7f\u7528\u673a\u578b", (String)"useModel"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }

    public static List<? extends SampleComfirmData> importFromExcel(InputStream in) throws Exception {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(SampleComfirmData.class);
        List<String> dataList = Arrays.asList(propertyDescriptors).stream().map(propertyDescriptor -> propertyDescriptor.getName()).collect(Collectors.toList());
        Assert.isNotEmpty(dataList, "\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        List<TitleAndModelKey> titleAndModelKeys = SampleComfirmExcelUtils.transfromProDef(dataList);
        List targetList = ExcelUtils.importExcelDataToMap((InputStream)in, (int)0, (int)1, (int)0, titleAndModelKeys, SampleComfirmData.class);
        return targetList;
    }
}

