/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.sample.entity.SampleComfirmAuth;
import com.els.base.sample.entity.SampleComfirmAuthExample;
import com.els.base.sample.entity.SampleComfirmData;
import com.els.base.sample.entity.SampleComfirmDataExample;
import com.els.base.sample.entity.SampleComfirmDlevel;
import com.els.base.sample.entity.SampleComfirmDlevelExample;
import com.els.base.sample.entity.SampleComfirmEp;
import com.els.base.sample.entity.SampleComfirmEpExample;
import com.els.base.sample.entity.SampleComfirmEsd;
import com.els.base.sample.entity.SampleComfirmEsdExample;
import com.els.base.sample.entity.SampleComfirmInfo;
import com.els.base.sample.entity.SampleComfirmInfoExample;
import com.els.base.sample.entity.SampleComfirmMsl;
import com.els.base.sample.entity.SampleComfirmMslExample;
import com.els.base.sample.entity.SampleComfirmOrder;
import com.els.base.sample.entity.SampleComfirmOrderExample;
import com.els.base.sample.entity.SampleComfirmPack;
import com.els.base.sample.entity.SampleComfirmPackExample;
import com.els.base.sample.entity.SampleComfirmSilk;
import com.els.base.sample.entity.SampleComfirmSilkExample;
import com.els.base.sample.entity.SampleComfirmSp;
import com.els.base.sample.entity.SampleComfirmSpExample;
import com.els.base.sample.entity.SampleComfirmSpec;
import com.els.base.sample.entity.SampleComfirmSpecExample;
import com.els.base.sample.entity.SampleComfirmWeld;
import com.els.base.sample.entity.SampleComfirmWeldExample;
import com.els.base.sample.enums.SampleComfirmInfoStatus;
import com.els.base.sample.enums.SampleComfirmOrderDataStatus;
import com.els.base.sample.enums.SampleComfirmOrderStatus;
import com.els.base.sample.service.SampleComfirmAuthService;
import com.els.base.sample.service.SampleComfirmDataService;
import com.els.base.sample.service.SampleComfirmDlevelService;
import com.els.base.sample.service.SampleComfirmEpService;
import com.els.base.sample.service.SampleComfirmEsdService;
import com.els.base.sample.service.SampleComfirmInfoService;
import com.els.base.sample.service.SampleComfirmMslService;
import com.els.base.sample.service.SampleComfirmOrderService;
import com.els.base.sample.service.SampleComfirmPackService;
import com.els.base.sample.service.SampleComfirmSilkService;
import com.els.base.sample.service.SampleComfirmSpService;
import com.els.base.sample.service.SampleComfirmSpecService;
import com.els.base.sample.service.SampleComfirmWeldService;
import com.els.base.sample.service.SampleConfirmService;
import com.els.base.sample.vo.GroupMaterialVO;
import com.els.base.sample.vo.SampleComfirmInfoVO;
import com.els.base.sample.vo.SampleComfirmOrderVO;
import com.els.base.sample.vo.SampleComfirmQualifiedVO;
import com.els.base.sample.vo.SampleComfirmSendVO;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSampleComfirmService")
public class SampleConfirmServiceImpl
implements SampleConfirmService {
    @Resource
    protected SampleComfirmOrderService sampleComfirmOrderService;
    @Resource
    protected SampleComfirmInfoService sampleComfirmInfoService;
    @Resource
    protected SampleComfirmDataService sampleComfirmDataService;
    @Resource
    protected SampleComfirmAuthService sampleComfirmAuthService;
    @Resource
    protected SampleComfirmDlevelService sampleComfirmDlevelService;
    @Resource
    protected SampleComfirmEpService sampleComfirmEpService;
    @Resource
    protected SampleComfirmEsdService sampleComfirmEsdService;
    @Resource
    protected SampleComfirmMslService sampleComfirmMslService;
    @Resource
    protected SampleComfirmPackService sampleComfirmPackService;
    @Resource
    protected SampleComfirmSilkService sampleComfirmSilkService;
    @Resource
    protected SampleComfirmSpService sampleComfirmSpService;
    @Resource
    protected SampleComfirmSpecService sampleComfirmSpecService;
    @Resource
    protected SampleComfirmWeldService sampleComfirmWeldService;

    @Override
    public PageView<SampleComfirmOrderVO> queryByPageOfSupplier(SampleComfirmOrderExample example, int pageNo, int pageSize) {
        PageView<SampleComfirmOrderVO> pageView = new PageView<SampleComfirmOrderVO>(pageNo, pageSize);
        PageView pageData = this.sampleComfirmOrderService.queryObjByPage(example);
        List sampleComfirmOrders = pageData.getQueryResult();
        ArrayList<SampleComfirmOrderVO> list = new ArrayList<SampleComfirmOrderVO>();
        if (sampleComfirmOrders != null && !sampleComfirmOrders.isEmpty()) {
            for (SampleComfirmOrder sampleComfirmOrder : sampleComfirmOrders) {
                SampleComfirmOrderVO vo = new SampleComfirmOrderVO();
                BeanUtils.copyProperties((Object)sampleComfirmOrder, (Object)vo);
                String orderNo = vo.getOrderNo();
                SampleComfirmInfoExample example2 = new SampleComfirmInfoExample();
                SampleComfirmInfoExample.Criteria criteria = example2.createCriteria();
                criteria.andOrderNoEqualTo(orderNo);
                List sampleList = this.sampleComfirmInfoService.queryAllObjByExample(example2);
                if (sampleList != null && !sampleList.isEmpty()) {
                    int unsendedTotal = 0;
                    int unconfirmedTotal = 0;
                    int qualifiedTotal = 0;
                    int unqualifiedTotal = 0;
                    int obsoletedTotal = 0;
                    int allTotal = sampleList.size();
                    for (SampleComfirmInfo sample : sampleList) {
                        String materialCode = sample.getMaterialCode();
                        if (sample.getSendTime() != null) {
                            vo.setPublishTime(sample.getSendTime());
                            vo.setPublishPerson(sample.getSendPerson());
                        }
                        switch (sample.getStatus()) {
                            case 0: {
                                String tmp0 = vo.getSampleUnsend();
                                if (StringUtils.isEmpty((CharSequence)tmp0)) {
                                    vo.setSampleUnsend(materialCode);
                                } else {
                                    vo.setSampleUnsend(tmp0 + " , " + materialCode);
                                }
                                ++unsendedTotal;
                                break;
                            }
                            case 1: {
                                String tmp1 = vo.getSampleUncomfirmed();
                                if (StringUtils.isEmpty((CharSequence)tmp1)) {
                                    vo.setSampleUncomfirmed(materialCode);
                                } else {
                                    vo.setSampleUncomfirmed(tmp1 + " , " + materialCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 2: {
                                String tmp2 = vo.getSampleRefused();
                                if (StringUtils.isEmpty((CharSequence)tmp2)) {
                                    vo.setSampleRefused(materialCode);
                                } else {
                                    vo.setSampleRefused(tmp2 + " , " + materialCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 3: {
                                String tmp3 = vo.getSampleDoing();
                                if (StringUtils.isEmpty((CharSequence)tmp3)) {
                                    vo.setSampleDoing(materialCode);
                                } else {
                                    vo.setSampleDoing(tmp3 + " , " + materialCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 4: {
                                String tmp4 = vo.getSampleWaitTest();
                                if (StringUtils.isEmpty((CharSequence)tmp4)) {
                                    vo.setSampleWaitTest(materialCode);
                                } else {
                                    vo.setSampleWaitTest(tmp4 + " , " + materialCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 5: {
                                String tmp5 = vo.getSampleQualified();
                                if (StringUtils.isEmpty((CharSequence)tmp5)) {
                                    vo.setSampleQualified(materialCode);
                                } else {
                                    vo.setSampleQualified(tmp5 + " , " + materialCode);
                                }
                                ++qualifiedTotal;
                                break;
                            }
                            case 6: {
                                String tmp6 = vo.getSampleUnqualified();
                                if (StringUtils.isEmpty((CharSequence)tmp6)) {
                                    vo.setSampleUnqualified(materialCode);
                                } else {
                                    vo.setSampleUnqualified(tmp6 + " , " + materialCode);
                                }
                                ++unqualifiedTotal;
                                break;
                            }
                            case 7: {
                                String tmp7 = vo.getSampleObsoleted();
                                if (StringUtils.isEmpty((CharSequence)tmp7)) {
                                    vo.setSampleObsoleted(materialCode);
                                } else {
                                    vo.setSampleObsoleted(tmp7 + " , " + materialCode);
                                }
                                ++obsoletedTotal;
                            }
                        }
                    }
                    if (unsendedTotal == allTotal) {
                        vo.setOrderStatus(SampleComfirmOrderStatus.UNSEND.getValue());
                    }
                    if (unconfirmedTotal == allTotal) {
                        vo.setOrderStatus(SampleComfirmOrderStatus.UNCOMFIRMORDER.getValue());
                    }
                    if (qualifiedTotal + unqualifiedTotal > 0 && qualifiedTotal + unqualifiedTotal < allTotal) {
                        vo.setOrderStatus(SampleComfirmOrderStatus.PART_COMFIRMORDERED.getValue());
                    }
                    if (qualifiedTotal + unqualifiedTotal == allTotal) {
                        vo.setOrderStatus(SampleComfirmOrderStatus.COMFIRMORDERED.getValue());
                    }
                    if (obsoletedTotal == allTotal) {
                        vo.setOrderStatus(SampleComfirmOrderStatus.OBSOLETED.getValue());
                    }
                }
                list.add(vo);
            }
        }
        pageView.setRowCount(pageData.getRowCount());
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    public PageView<SampleComfirmInfoVO> queryByPageOfSample(SampleComfirmInfoExample example, int pageNo, int pageSize) {
        PageView<SampleComfirmInfoVO> pageView = new PageView<SampleComfirmInfoVO>(pageNo, pageSize);
        PageView<GroupMaterialVO> pageData = this.sampleComfirmInfoService.groupMaterialSelectByPage(example, pageNo, pageSize);
        ArrayList<SampleComfirmInfoVO> list = new ArrayList<SampleComfirmInfoVO>();
        List<GroupMaterialVO> sampleComfirmInfos = pageData.getQueryResult();
        if (sampleComfirmInfos != null && !sampleComfirmInfos.isEmpty()) {
            for (GroupMaterialVO sampleComfirmInfo : sampleComfirmInfos) {
                SampleComfirmInfoVO vo = new SampleComfirmInfoVO();
                BeanUtils.copyProperties((Object)sampleComfirmInfo, (Object)vo);
                SampleComfirmInfoExample example2 = new SampleComfirmInfoExample();
                SampleComfirmInfoExample.Criteria criteria2 = example2.createCriteria();
                criteria2.andSapOrderNoEqualTo(sampleComfirmInfo.getSapOrderNo());
                criteria2.andMaterialCodeEqualTo(sampleComfirmInfo.getMaterialCode());
                List tempList = this.sampleComfirmInfoService.queryAllObjByExample(example2);
                if (tempList != null && !tempList.isEmpty()) {
                    int unsendedTotal = 0;
                    int unconfirmedTotal = 0;
                    int qualifiedTotal = 0;
                    int unqualifiedTotal = 0;
                    int obsoletedTotal = 0;
                    int allTotal = tempList.size();
                    for (SampleComfirmInfo sample : tempList) {
                        String supplierSrmCode = sample.getSupplierSrmCode();
                        switch (sample.getStatus()) {
                            case 0: {
                                String tmp0 = vo.getSampleUnsend();
                                if (StringUtils.isEmpty((CharSequence)tmp0)) {
                                    vo.setSampleUnsend(supplierSrmCode);
                                } else {
                                    vo.setSampleUnsend(tmp0 + " , " + supplierSrmCode);
                                }
                                ++unsendedTotal;
                                break;
                            }
                            case 1: {
                                String tmp1 = vo.getSampleUncomfirmed();
                                if (StringUtils.isEmpty((CharSequence)tmp1)) {
                                    vo.setSampleUncomfirmed(supplierSrmCode);
                                } else {
                                    vo.setSampleUncomfirmed(tmp1 + " , " + supplierSrmCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 2: {
                                String tmp2 = vo.getSampleRefused();
                                if (StringUtils.isEmpty((CharSequence)tmp2)) {
                                    vo.setSampleRefused(supplierSrmCode);
                                } else {
                                    vo.setSampleRefused(tmp2 + " , " + supplierSrmCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 3: {
                                String tmp3 = vo.getSampleDoing();
                                if (StringUtils.isEmpty((CharSequence)tmp3)) {
                                    vo.setSampleDoing(supplierSrmCode);
                                } else {
                                    vo.setSampleDoing(tmp3 + " , " + supplierSrmCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 4: {
                                String tmp4 = vo.getSampleWaitTest();
                                if (StringUtils.isEmpty((CharSequence)tmp4)) {
                                    vo.setSampleWaitTest(supplierSrmCode);
                                } else {
                                    vo.setSampleWaitTest(tmp4 + " , " + supplierSrmCode);
                                }
                                ++unconfirmedTotal;
                                break;
                            }
                            case 5: {
                                String tmp5 = vo.getSampleQualified();
                                if (StringUtils.isEmpty((CharSequence)tmp5)) {
                                    vo.setSampleQualified(supplierSrmCode);
                                } else {
                                    vo.setSampleQualified(tmp5 + " , " + supplierSrmCode);
                                }
                                ++qualifiedTotal;
                                break;
                            }
                            case 6: {
                                String tmp6 = vo.getSampleUnqualified();
                                if (StringUtils.isEmpty((CharSequence)tmp6)) {
                                    vo.setSampleUnqualified(supplierSrmCode);
                                } else {
                                    vo.setSampleUnqualified(tmp6 + " , " + supplierSrmCode);
                                }
                                ++unqualifiedTotal;
                                break;
                            }
                            case 7: {
                                String tmp7 = vo.getSampleObsoleted();
                                if (StringUtils.isEmpty((CharSequence)tmp7)) {
                                    vo.setSampleObsoleted(supplierSrmCode);
                                } else {
                                    vo.setSampleObsoleted(tmp7 + " , " + supplierSrmCode);
                                }
                                ++obsoletedTotal;
                            }
                        }
                    }
                    if (unsendedTotal > 0) {
                        vo.setStatus(SampleComfirmOrderStatus.UNSEND.getValue());
                    }
                    if (unconfirmedTotal > 0 && vo.getStatus() == null) {
                        vo.setStatus(SampleComfirmOrderStatus.UNCOMFIRMORDER.getValue());
                    }
                    if (qualifiedTotal + unqualifiedTotal > 0 && qualifiedTotal + unqualifiedTotal < allTotal) {
                        vo.setStatus(SampleComfirmOrderStatus.PART_COMFIRMORDERED.getValue());
                    }
                    if (qualifiedTotal + unqualifiedTotal == allTotal) {
                        vo.setStatus(SampleComfirmOrderStatus.COMFIRMORDERED.getValue());
                    }
                    if (qualifiedTotal + obsoletedTotal == allTotal) {
                        vo.setStatus(SampleComfirmOrderStatus.COMFIRMORDERED.getValue());
                    }
                    if (obsoletedTotal == allTotal) {
                        vo.setStatus(SampleComfirmOrderStatus.OBSOLETED.getValue());
                    }
                }
                list.add(vo);
            }
        }
        pageView.setRowCount(pageData.getRowCount());
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    public PageView<SampleComfirmInfo> supQueryByPageOfSample(SampleComfirmInfoExample example, int pageNo, int pageSize) {
        return this.sampleComfirmInfoService.queryObjByPage(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"sampleComfirm"}, allEntries=true)
    public void purSendBySupplier(List<String> orderNos, String loginName, String userName) {
        if (orderNos == null || orderNos.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        orderNos.forEach(orderNo -> this.sampleComfirmOrderService.modifySampleComfirmOrderStatus((String)orderNo, SampleComfirmOrderStatus.UNCOMFIRMORDER));
        SampleComfirmInfoExample example = new SampleComfirmInfoExample();
        SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoIn((List)orderNos);
        List<SampleComfirmInfo> samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
        this.purSendSample(samples, loginName, userName);
    }

    @Override
    public void purSendBySample(List<SampleComfirmSendVO> list, String loginName, String userName) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SampleComfirmSendVO vo : list) {
            SampleComfirmInfoExample example = new SampleComfirmInfoExample();
            SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
            criteria.andSapOrderNoEqualTo(vo.getSapOrderNo());
            criteria.andMaterialCodeEqualTo(vo.getMaterialCode());
            criteria.andStatusEqualTo(SampleComfirmInfoStatus.UNSEND.getValue());
            List<SampleComfirmInfo> samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
            this.purSendSample(samples, loginName, userName);
        }
    }

    private void purSendSample(List<SampleComfirmInfo> samples, String loginName, String userName) {
        if (samples == null) {
            return;
        }
        for (SampleComfirmInfo entity : samples) {
            if (entity.getStatus().intValue() == SampleComfirmInfoStatus.UNSEND.getValue()) continue;
            throw new CommonException("\u6837\u54c1[" + entity.getMaterialCode() + "]\u5904\u4e8e[" + SampleComfirmInfoStatus.UNSEND.getDesc(entity.getStatus()) + "]\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
        }
        for (SampleComfirmInfo entity : samples) {
            entity.setStatus(SampleComfirmInfoStatus.UNCOMFIRMED.getValue());
            entity.setSendTime(new Date());
            entity.setPurchaserSrmCode(loginName);
            entity.setSendPerson(userName);
            this.sampleComfirmInfoService.modifyObj(entity);
        }
    }

    @Override
    public void purObsoleteBySupplier(List<String> orderNos, String loginName) {
        if (orderNos == null || orderNos.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SampleComfirmInfoExample example = new SampleComfirmInfoExample();
        SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoIn((List)orderNos);
        List<SampleComfirmInfo> samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
        this.purObsoleteSample(samples, loginName);
        for (SampleComfirmInfo entity : samples) {
            this.obsoleteBackSample(entity.getSapOrderNo(), entity.getMaterialCode());
        }
        orderNos.forEach(orderNo -> this.sampleComfirmOrderService.modifySampleComfirmOrderStatus((String)orderNo, SampleComfirmOrderStatus.OBSOLETED));
    }

    @Override
    public void purObsoleteBySample(List<SampleComfirmSendVO> list, String loginName) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SampleComfirmSendVO vo : list) {
            SampleComfirmInfoExample example = new SampleComfirmInfoExample();
            SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
            criteria.andSapOrderNoEqualTo(vo.getSapOrderNo());
            criteria.andMaterialCodeEqualTo(vo.getMaterialCode());
            List<SampleComfirmInfo> samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
            this.purObsoleteSample(samples, loginName);
            this.obsoleteBackSample(vo.getSapOrderNo(), vo.getMaterialCode());
        }
    }

    private void obsoleteBackSample(String sapOrderNo, String materialCode) {
        SampleComfirmDataExample exampleData = new SampleComfirmDataExample();
        SampleComfirmDataExample.Criteria criteriaData = exampleData.createCriteria();
        criteriaData.andSapOrderNoEqualTo(sapOrderNo);
        criteriaData.andMaterialCodeEqualTo(materialCode);
        List sampleComfirmDatas = this.sampleComfirmDataService.queryAllObjByExample(exampleData);
        if (sampleComfirmDatas != null) {
            for (SampleComfirmData data : sampleComfirmDatas) {
                data.setOrderStatus(SampleComfirmOrderDataStatus.UNCOMFIRMORDER.getValue());
                this.sampleComfirmDataService.modifyObj(data);
            }
        }
    }

    private void purObsoleteSample(List<SampleComfirmInfo> samples, String loginName) {
        if (samples == null) {
            return;
        }
        boolean haveObsoleted = true;
        for (SampleComfirmInfo entity : samples) {
            boolean flag = true;
            if (entity.getStatus().intValue() == SampleComfirmInfoStatus.OBSOLETED.getValue()) {
                flag = false;
            } else if (entity.getStatus().intValue() == SampleComfirmInfoStatus.QUALIFIED.getValue()) {
                flag = false;
            } else if (entity.getStatus().intValue() == SampleComfirmInfoStatus.UNQUALIFIED.getValue()) {
                flag = false;
            }
            if (!flag) continue;
            entity.setStatus(SampleComfirmInfoStatus.OBSOLETED.getValue());
            entity.setPurchaserSrmCode(loginName);
            this.sampleComfirmInfoService.modifyObj(entity);
            haveObsoleted = false;
        }
        if (haveObsoleted) {
            throw new CommonException("\u6ca1\u6709\u7b26\u5408\u4f5c\u5e9f\u7684\u5355\u636e\u72b6\u6001");
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"sampleComfirm"}, allEntries=true)
    public void supConfirmSample(List<SampleComfirmSendVO> list, String loginName) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int currentStatus = SampleComfirmInfoStatus.UNCOMFIRMED.getValue();
        int changeStatus = SampleComfirmInfoStatus.SAMPLE_DOING.getValue();
        for (SampleComfirmSendVO vo : list) {
            SampleComfirmInfoExample example = new SampleComfirmInfoExample();
            SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
            criteria.andSapOrderNoEqualTo(vo.getSapOrderNo());
            criteria.andMaterialCodeEqualTo(vo.getMaterialCode());
            criteria.andOrderNoEqualTo(vo.getSrmOrderNo());
            List samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
            if (samples == null) continue;
            for (SampleComfirmInfo entity : samples) {
                if (entity.getStatus() == currentStatus) {
                    entity.setStatus(changeStatus);
                    entity.setRemark(vo.getRemark());
                    entity.setSupplierSrmCode(loginName);
                    entity.setConfirmTime(new Date());
                    this.sampleComfirmInfoService.modifyObj(entity);
                    continue;
                }
                throw new CommonException("\u6837\u54c1[" + entity.getMaterialCode() + "]\u5904\u4e8e[" + SampleComfirmInfoStatus.UNSEND.getDesc(entity.getStatus()) + "]\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
        }
    }

    @Override
    public void purComfirmSample(List<SampleComfirmQualifiedVO> list, int status, String loginName) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<String> orderNoList = new HashSet<String>();
        for (SampleComfirmQualifiedVO vo : list) {
            SampleComfirmInfoExample sampleInfoExample = new SampleComfirmInfoExample();
            SampleComfirmInfoExample.Criteria sampleInfoCriteria = sampleInfoExample.createCriteria();
            sampleInfoCriteria.andSapOrderNoEqualTo(vo.getSapOrderNo());
            sampleInfoCriteria.andMaterialCodeEqualTo(vo.getMaterialCode());
            sampleInfoCriteria.andSupplierSrmCodeEqualTo(vo.getSupplierSrmCode());
            sampleInfoCriteria.andOrderNoEqualTo(vo.getSrmOrderNo());
            List sampleInfoList = this.sampleComfirmInfoService.queryAllObjByExample(sampleInfoExample);
            if (sampleInfoList == null || sampleInfoList.isEmpty()) {
                String errMsg = MessageFormat.format("\u627e\u4e0d\u5230\u4f9b\u5e94\u5546[{0}],\u7269\u6599[{1}]\uff0c\u5355\u53f7\u4e3a[{2}]\u7684\u8ba4\u5b9a\u5355\u3002", vo.getSupplierSrmCode(), vo.getMaterialCode(), vo.getSrmOrderNo());
                throw new CommonException(errMsg);
            }
            for (SampleComfirmInfo entity : sampleInfoList) {
                if (entity.getStatus().intValue() != SampleComfirmInfoStatus.WAIT_TEST.getValue()) {
                    String errMsg = MessageFormat.format("\u6837\u54c1[{0}]\u5904\u4e8e[{1}]\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c", entity.getMaterialCode(), SampleComfirmInfoStatus.UNSEND.getDesc(entity.getStatus()));
                    throw new CommonException(errMsg);
                }
                entity.setStatus(status);
                this.sampleComfirmInfoService.modifyObj(entity);
            }
            orderNoList.add(vo.getSrmOrderNo());
        }
        for (String orderNo : orderNoList) {
            SampleComfirmOrderStatus comfirmOrderStatus = this.querySampleComfirmOrderStatus(orderNo);
            if (comfirmOrderStatus == null) continue;
            this.sampleComfirmOrderService.modifySampleComfirmOrderStatus(orderNo, comfirmOrderStatus);
        }
    }

    private SampleComfirmOrderStatus querySampleComfirmOrderStatus(String orderNo) {
        SampleComfirmInfoExample sampleInfoExample2 = new SampleComfirmInfoExample();
        SampleComfirmInfoExample.Criteria sampleInfoCriteria2 = sampleInfoExample2.createCriteria();
        sampleInfoCriteria2.andOrderNoEqualTo(orderNo);
        List sampleInfoList2 = this.sampleComfirmInfoService.queryAllObjByExample(sampleInfoExample2);
        if (CollectionUtils.isEmpty(sampleInfoList2)) {
            String errMsg = MessageFormat.format("\u8ba4\u5b9a\u5355[{0}]\u4e0d\u5b58\u5728", orderNo);
            throw new CommonException(errMsg);
        }
        int confirmTotal = 0;
        for (SampleComfirmInfo info : sampleInfoList2) {
            if (info.getStatus().intValue() != SampleComfirmInfoStatus.QUALIFIED.getValue() && info.getStatus().intValue() != SampleComfirmInfoStatus.UNQUALIFIED.getValue()) continue;
            ++confirmTotal;
        }
        if (confirmTotal == 0) {
            return null;
        }
        if (confirmTotal < sampleInfoList2.size()) {
            return SampleComfirmOrderStatus.PART_COMFIRMORDERED;
        }
        return SampleComfirmOrderStatus.COMFIRMORDERED;
    }

    @Override
    public void supRefuseSample(List<SampleComfirmSendVO> list, String loginName) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int currentStatus = SampleComfirmInfoStatus.UNCOMFIRMED.getValue();
        int changeStatus = SampleComfirmInfoStatus.REFUSED.getValue();
        for (SampleComfirmSendVO vo : list) {
            SampleComfirmInfoExample example = new SampleComfirmInfoExample();
            SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
            criteria.andSapOrderNoEqualTo(vo.getSapOrderNo());
            criteria.andMaterialCodeEqualTo(vo.getMaterialCode());
            criteria.andOrderNoEqualTo(vo.getSrmOrderNo());
            List samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
            if (samples == null) continue;
            for (SampleComfirmInfo entity : samples) {
                if (entity.getStatus() == currentStatus) {
                    entity.setStatus(changeStatus);
                    entity.setRemark(vo.getRemark());
                    entity.setSupplierSrmCode(loginName);
                    this.sampleComfirmInfoService.modifyObj(entity);
                    continue;
                }
                throw new CommonException("\u6837\u54c1[" + entity.getMaterialCode() + "]\u5904\u4e8e[" + SampleComfirmInfoStatus.UNSEND.getDesc(entity.getStatus()) + "]\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
        }
    }

    @Override
    public PageView<SampleComfirmOrder> purDetailSupplierInfo(int pageNo, int pageSize, String sapOrderNo, String materialCode) {
        if (sapOrderNo == null || materialCode == null) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SampleComfirmOrderExample example = new SampleComfirmOrderExample();
        example.setOrderByClause("ORDER_NO DESC, SUPPLIER_SRM_CODE ASC");
        example.setPageView(new PageView<SampleComfirmOrder>(pageNo, pageSize));
        SampleComfirmInfoExample sampleInfoExample = new SampleComfirmInfoExample();
        SampleComfirmInfoExample.Criteria sampleInfoCriteria = sampleInfoExample.createCriteria();
        sampleInfoCriteria.andSapOrderNoEqualTo(sapOrderNo);
        sampleInfoCriteria.andMaterialCodeEqualTo(materialCode);
        List sampleInfoList = this.sampleComfirmInfoService.queryAllObjByExample(sampleInfoExample);
        if (sampleInfoList == null || sampleInfoList.isEmpty()) {
            return null;
        }
        ArrayList<String> orderNos = new ArrayList<String>();
        for (SampleComfirmInfo sampleInfo : sampleInfoList) {
            orderNos.add(sampleInfo.getOrderNo());
        }
        SampleComfirmOrderExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoIn(orderNos);
        PageView<SampleComfirmOrder> pageData = this.sampleComfirmOrderService.queryObjByPage(example);
        List sampleComfirmOrderList = pageData.getQueryResult();
        if (sampleComfirmOrderList == null || sampleComfirmOrderList.isEmpty()) {
            return null;
        }
        for (SampleComfirmOrder sampleComfirmOrder : sampleComfirmOrderList) {
            for (SampleComfirmInfo sampleInfo : sampleInfoList) {
                if (!sampleComfirmOrder.getOrderNo().equals(sampleInfo.getOrderNo())) continue;
                sampleComfirmOrder.setOrderStatus(sampleInfo.getStatus());
            }
        }
        return pageData;
    }

    @Override
    public void supSubmitSample(List<SampleComfirmSendVO> list, String loginName) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int currentStatus = SampleComfirmInfoStatus.SAMPLE_DOING.getValue();
        int changeStatus = SampleComfirmInfoStatus.WAIT_TEST.getValue();
        for (SampleComfirmSendVO vo : list) {
            SampleComfirmInfoExample example = new SampleComfirmInfoExample();
            SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
            criteria.andSapOrderNoEqualTo(vo.getSapOrderNo());
            criteria.andMaterialCodeEqualTo(vo.getMaterialCode());
            criteria.andOrderNoEqualTo(vo.getSrmOrderNo());
            List samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
            if (samples == null) continue;
            for (SampleComfirmInfo entity : samples) {
                if (entity.getStatus() == currentStatus) {
                    entity.setStatus(changeStatus);
                    entity.setRemark(vo.getRemark());
                    entity.setSupplierSrmCode(loginName);
                    entity.setDatelanded(new Date());
                    entity.setSubmitTime(new Date());
                    this.sampleComfirmInfoService.modifyObj(entity);
                    continue;
                }
                throw new CommonException("\u6837\u54c1[" + entity.getMaterialCode() + "]\u5904\u4e8e[" + SampleComfirmInfoStatus.UNSEND.getDesc(entity.getStatus()) + "]\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
        }
    }

    private void validTabAuth(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmAuthExample example = new SampleComfirmAuthExample();
        SampleComfirmAuthExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmAuthService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmAuth sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u8ba4\u8bc1\u4fe1\u606f\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabDlevel(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmDlevelExample example = new SampleComfirmDlevelExample();
        SampleComfirmDlevelExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmDlevelService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmDlevel sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u5668\u4ef6\u7b49\u7ea7\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabEp(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmEpExample example = new SampleComfirmEpExample();
        SampleComfirmEpExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmEpService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmEp sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u73af\u4fdd\u8d44\u6599\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabEsd(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmEsdExample example = new SampleComfirmEsdExample();
        SampleComfirmEsdExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmEsdService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmEsd sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("ESD\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabMsl(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmMslExample example = new SampleComfirmMslExample();
        SampleComfirmMslExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmMslService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmMsl sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("MSL\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabPack(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmPackExample example = new SampleComfirmPackExample();
        SampleComfirmPackExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmPackService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmPack sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u5305\u88c5\u4fe1\u606f\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabSilk(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmSilkExample example = new SampleComfirmSilkExample();
        SampleComfirmSilkExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmSilkService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmSilk sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u4ea7\u54c1\u4e1d\u5370\uff0f\u6807\u7b7e\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabSp(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmSpExample example = new SampleComfirmSpExample();
        SampleComfirmSpExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmSpService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmSp sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u4ea7\u54c1\u4f9b\u5e94\u4fdd\u8bc1\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabSpec(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmSpecExample example = new SampleComfirmSpecExample();
        SampleComfirmSpecExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmSpecService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmSpec sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u89c4\u683c\u4e66\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void validTabWeld(String sapOrderNo, String materialCode, String supplierSrmCode) {
        SampleComfirmWeldExample example = new SampleComfirmWeldExample();
        SampleComfirmWeldExample.Criteria criteria = example.createCriteria();
        criteria.andSapOrderNoEqualTo(sapOrderNo);
        criteria.andMaterialCodeEqualTo(materialCode);
        criteria.andSupplierSrmCodeEqualTo(supplierSrmCode);
        List list = this.sampleComfirmWeldService.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SampleComfirmWeld sample : list) {
            if (sample.getConfirmStatus() != 0) continue;
            throw new CommonException("\u710a\u63a5\u4fe1\u606f\u8fd8\u6ca1\u6709\u6253\u6837\uff0c\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private void changeSampleStatus(List<SampleComfirmSendVO> list, String loginName, int currentStatus, int changeStatus) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SampleComfirmSendVO vo : list) {
            SampleComfirmInfoExample example = new SampleComfirmInfoExample();
            SampleComfirmInfoExample.Criteria criteria = example.createCriteria();
            criteria.andSapOrderNoEqualTo(vo.getSapOrderNo());
            criteria.andMaterialCodeEqualTo(vo.getMaterialCode());
            criteria.andSupplierSrmCodeEqualTo(loginName);
            List samples = this.sampleComfirmInfoService.queryAllObjByExample(example);
            if (samples == null) continue;
            for (SampleComfirmInfo entity : samples) {
                if (entity.getStatus() == currentStatus) {
                    entity.setStatus(changeStatus);
                    entity.setRemark(vo.getRemark());
                    entity.setSupplierSrmCode(loginName);
                    this.sampleComfirmInfoService.modifyObj(entity);
                    continue;
                }
                throw new CommonException("\u6837\u54c1[" + entity.getMaterialCode() + "]\u5904\u4e8e[" + SampleComfirmInfoStatus.UNSEND.getDesc(entity.getStatus()) + "]\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
        }
    }
}

