/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.sample.dao.SampleComfirmOrderMapper;
import com.els.base.sample.entity.SampleComfirmOrder;
import com.els.base.sample.entity.SampleComfirmOrderExample;
import com.els.base.sample.enums.SampleComfirmOrderStatus;
import com.els.base.sample.service.SampleComfirmOrderService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultSampleComfirmOrderService")
public class SampleComfirmOrderServiceImpl
implements SampleComfirmOrderService {
    @Resource
    protected SampleComfirmOrderMapper sampleComfirmOrderMapper;

    @Override
    @CacheEvict(value={"sampleComfirmOrder"}, allEntries=true)
    public void addObj(SampleComfirmOrder t) {
        this.sampleComfirmOrderMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"sampleComfirmOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.sampleComfirmOrderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"sampleComfirmOrder"}, allEntries=true)
    public void modifyObj(SampleComfirmOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.sampleComfirmOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"sampleComfirmOrder"}, keyGenerator="redisKeyGenerator")
    public SampleComfirmOrder queryObjById(String id) {
        return this.sampleComfirmOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"sampleComfirmOrder"}, keyGenerator="redisKeyGenerator")
    public List<SampleComfirmOrder> queryAllObjByExample(SampleComfirmOrderExample example) {
        return this.sampleComfirmOrderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"sampleComfirmOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<SampleComfirmOrder> queryObjByPage(SampleComfirmOrderExample example) {
        PageView<SampleComfirmOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.sampleComfirmOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"sampleComfirmOrder"}, allEntries=true)
    public void modifySampleComfirmOrderStatus(String orderNo, SampleComfirmOrderStatus statu) {
        SampleComfirmOrderExample example = new SampleComfirmOrderExample();
        example.createCriteria().andOrderNoEqualTo(orderNo);
        List<SampleComfirmOrder> sampleComfirmOrders = this.sampleComfirmOrderMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(sampleComfirmOrders)) {
            return;
        }
        SampleComfirmOrder temp = new SampleComfirmOrder();
        temp.setId(sampleComfirmOrders.get(0).getId());
        temp.setOrderStatus(statu.getValue());
        this.sampleComfirmOrderMapper.updateByPrimaryKeySelective(temp);
    }
}

