/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.sample.entity.SampleComfirmInfo;
import com.els.base.sample.entity.SampleComfirmInfoExample;
import com.els.base.sample.entity.SampleComfirmOrder;
import com.els.base.sample.entity.SampleComfirmOrderExample;
import com.els.base.sample.enums.SampleComfirmInfoStatus;
import com.els.base.sample.service.SampleComfirmInfoService;
import com.els.base.sample.service.SampleComfirmOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6c47\u603b-\u751f\u6210\u7684\u8ba4\u5b9a\u5355")
@Controller
@RequestMapping(value={"sampleComfirmOrder"})
public class SampleComfirmOrderController {
    @Resource
    protected SampleComfirmOrderService sampleComfirmOrderService;
    @Resource
    protected SampleComfirmInfoService sampleComfirmInfoService;

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6c47\u603b-\u751f\u6210\u7684\u8ba4\u5b9a\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<SampleComfirmOrder> sampleComfirmOrderList) {
        if (CollectionUtils.isEmpty(sampleComfirmOrderList)) {
            throw new CommonException("data \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        for (SampleComfirmOrder sampleComfirmOrder : sampleComfirmOrderList) {
            this.sampleComfirmOrderService.modifyObj(sampleComfirmOrder);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6837\u54c1\u8ba4\u5b9a\u5355-\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SampleComfirmOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmOrder>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SampleComfirmOrderExample example = new SampleComfirmOrderExample();
        example.setPageView(new PageView<SampleComfirmOrder>(pageNo, pageSize));
        if (wapper != null) {
            SampleComfirmOrderExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.sampleComfirmOrderService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u660e\u7ec6-\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="sapOrderNo", required=true, value="\u6e90\u5355\u636e\u53f7", paramType="query", dataType="String"), @ApiImplicitParam(name="materialCode", required=true, value="\u7269\u6599\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/detail/supplierInfo"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmOrder>> detailSupplierInfo(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) String sapOrderNo, @RequestParam(required=true) String materialCode) {
        SampleComfirmOrderExample example = new SampleComfirmOrderExample();
        example.setPageView(new PageView<SampleComfirmOrder>(pageNo, pageSize));
        SampleComfirmInfoExample sampleInfoExample = new SampleComfirmInfoExample();
        SampleComfirmInfoExample.Criteria sampleInfoCriteria = sampleInfoExample.createCriteria();
        sampleInfoCriteria.andSapOrderNoEqualTo(sapOrderNo);
        sampleInfoCriteria.andMaterialCodeEqualTo(materialCode);
        List sampleInfoList = this.sampleComfirmInfoService.queryAllObjByExample(sampleInfoExample);
        if (sampleInfoList == null || !sampleInfoList.isEmpty()) {
            return ResponseResult.success(null);
        }
        ArrayList<String> orderNos = new ArrayList<String>();
        for (SampleComfirmInfo sampleInfo : sampleInfoList) {
            orderNos.add(sampleInfo.getOrderNo());
        }
        SampleComfirmOrderExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoIn(orderNos);
        PageView pageData = this.sampleComfirmOrderService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546-\u660e\u7ec6-\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="sapOrderNo", required=true, value="\u6e90\u5355\u636e\u53f7", paramType="query", dataType="String"), @ApiImplicitParam(name="materialCode", required=true, value="\u7269\u6599\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/sup/detail/supplierInfo"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmOrder>> supDetailSupplierInfo(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) String sapOrderNo, @RequestParam(required=true) String materialCode, @RequestParam(required=true) String orderNo) {
        SampleComfirmOrderExample example = new SampleComfirmOrderExample();
        example.setPageView(new PageView<SampleComfirmOrder>(pageNo, pageSize));
        SampleComfirmInfoExample sampleInfoExample = new SampleComfirmInfoExample();
        SampleComfirmInfoExample.Criteria sampleInfoCriteria = sampleInfoExample.createCriteria();
        sampleInfoCriteria.andSapOrderNoEqualTo(sapOrderNo);
        sampleInfoCriteria.andMaterialCodeEqualTo(materialCode);
        sampleInfoCriteria.andOrderNoEqualTo(orderNo);
        sampleInfoCriteria.andSupplierSrmCodeEqualTo(CompanyUtils.currentCompany().getCompanyCode());
        List sampleInfoList = this.sampleComfirmInfoService.queryAllObjByExample(sampleInfoExample);
        if (sampleInfoList == null || sampleInfoList.isEmpty()) {
            return ResponseResult.success(null);
        }
        SampleComfirmOrderExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(orderNo);
        System.out.println("\u67e5\u8be2");
        PageView pageData = this.sampleComfirmOrderService.queryObjByPage(example);
        List orderList = pageData.getQueryResult();
        if (orderList == null || orderList.isEmpty()) {
            return ResponseResult.success(pageData);
        }
        for (SampleComfirmOrder entity : orderList) {
            for (SampleComfirmInfo sampleInfo : sampleInfoList) {
                if (!entity.getOrderNo().equals(sampleInfo.getOrderNo())) continue;
                if (sampleInfo.getStatus().intValue() == SampleComfirmInfoStatus.OBSOLETED.getValue()) {
                    entity.setOrderStatus(4);
                    continue;
                }
                if (sampleInfo.getStatus().intValue() == SampleComfirmInfoStatus.QUALIFIED.getValue()) {
                    entity.setOrderStatus(3);
                    continue;
                }
                if (sampleInfo.getStatus().intValue() == SampleComfirmInfoStatus.UNQUALIFIED.getValue()) {
                    entity.setOrderStatus(3);
                    continue;
                }
                entity.setOrderStatus(1);
            }
        }
        return ResponseResult.success(pageData);
    }
}

