/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.sample.entity.SampleComfirmPack;
import com.els.base.sample.entity.SampleComfirmPackExample;
import com.els.base.sample.service.SampleComfirmPackService;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u660e\u7ec6-\u5305\u88c5\u4fe1\u606f")
@Controller
@RequestMapping(value={"sampleComfirmPack"})
public class SampleComfirmPackController {
    @Resource
    protected SampleComfirmPackService sampleComfirmPackService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u660e\u7ec6-\u5305\u88c5\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<SampleComfirmPack> sampleComfirmPackList) {
        if (CollectionUtils.isEmpty(sampleComfirmPackList)) {
            throw new CommonException("\u7f3a\u5c11\u53c2\u6570\u3002");
        }
        for (SampleComfirmPack sampleComfirmPack : sampleComfirmPackList) {
            this.sampleComfirmPackService.addObj(sampleComfirmPack);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u660e\u7ec6-\u5305\u88c5\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<SampleComfirmPack> sampleComfirmPackList) throws JsonProcessingException {
        if (CollectionUtils.isEmpty(sampleComfirmPackList)) {
            throw new CommonException("\u7f3a\u5c11\u53c2\u6570\u3002");
        }
        for (SampleComfirmPack sampleComfirmPack : sampleComfirmPackList) {
            List<FileData> fileDateList = sampleComfirmPack.getFileDateList();
            if (CollectionUtils.isNotEmpty(fileDateList)) {
                String writeValueAsString = JsonUtils.writeValueAsString(fileDateList);
                sampleComfirmPack.setAttachment(writeValueAsString);
            }
            sampleComfirmPack.setConfirmStatus(Constant.YES_INT);
            this.sampleComfirmPackService.updateByPrimaryKey(sampleComfirmPack);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u660e\u7ec6-\u5305\u88c5\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sampleComfirmPackService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u660e\u7ec6-\u5305\u88c5\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SampleComfirmPack", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmPack>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SampleComfirmPackExample example = new SampleComfirmPackExample();
        example.setOrderByClause("ORDER_NO DESC, SUPPLIER_SRM_CODE ASC");
        example.setPageView(new PageView<SampleComfirmPack>(pageNo, pageSize));
        if (wapper != null) {
            SampleComfirmPackExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.sampleComfirmPackService.queryObjByPage(example);
        List data = pageData.getQueryResult();
        for (int i = 0; CollectionUtils.isNotEmpty(data) && i < data.size(); ++i) {
            ((SampleComfirmPack)data.get(i)).disablePropertiesIfNotSent();
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u660e\u7ec6-\u5305\u88c5\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SampleComfirmPack", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageBySupplier"})
    @ResponseBody
    public ResponseResult<PageView<SampleComfirmPack>> findByPageBySupplier(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SampleComfirmPackExample example = new SampleComfirmPackExample();
        SampleComfirmPackExample.Criteria criteria = example.createCriteria();
        criteria.andSupplierSrmCodeEqualTo(CompanyUtils.currentCompany().getCompanyCode());
        example.setPageView(new PageView<SampleComfirmPack>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.sampleComfirmPackService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

