/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.sample.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.sample.dao.SampleComfirmAuthMapper;
import com.els.base.sample.entity.SampleComfirmAuth;
import com.els.base.sample.entity.SampleComfirmAuthExample;
import com.els.base.sample.enums.SampleComfirmAuthWay;
import com.els.base.sample.service.SampleComfirmAuthService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultSampleComfirmAuthService")
public class SampleComfirmAuthServiceImpl
implements SampleComfirmAuthService {
    @Resource
    protected SampleComfirmAuthMapper sampleComfirmAuthMapper;

    @Override
    @CacheEvict(value={"sampleComfirmAuth"}, allEntries=true)
    public void addObj(SampleComfirmAuth t) {
        this.sampleComfirmAuthMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"sampleComfirmAuth"}, allEntries=true)
    public void deleteObjById(String id) {
        this.sampleComfirmAuthMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"sampleComfirmAuth"}, allEntries=true)
    public void modifyObj(SampleComfirmAuth t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.sampleComfirmAuthMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"sampleComfirmAuth"}, keyGenerator="redisKeyGenerator")
    public SampleComfirmAuth queryObjById(String id) {
        return this.sampleComfirmAuthMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"sampleComfirmAuth"}, keyGenerator="redisKeyGenerator")
    public List<SampleComfirmAuth> queryAllObjByExample(SampleComfirmAuthExample example) {
        return this.sampleComfirmAuthMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"sampleComfirmAuth"}, keyGenerator="redisKeyGenerator")
    public PageView<SampleComfirmAuth> queryObjByPage(SampleComfirmAuthExample example) {
        PageView<SampleComfirmAuth> pageView = example.getPageView();
        pageView.setQueryResult(this.sampleComfirmAuthMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"sampleComfirmAuth"}, allEntries=true)
    public void updateByPrimaryKey(SampleComfirmAuth t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (SampleComfirmAuthWay.BLUETOOTH.getValue().equals(t.getAuthWay())) {
            t.setAuthName(null);
            t.setAuthCode(null);
            t.setBeginIndate(null);
            t.setEndIndate(null);
            t.setBomAttachment(null);
        } else {
            t.setDid(null);
            t.setQdlAttachment(null);
            t.setRfTestReport(null);
        }
        if (CollectionUtils.isEmpty(t.getFileDateList())) {
            t.setBomAttachment(null);
        }
        this.sampleComfirmAuthMapper.updateByPrimaryKey(t);
    }
}

