/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.kn.common;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.kn.file.entity.CommonFile;
import com.els.base.kn.file.service.CommonFileService;
import com.els.base.kn.sample.entity.SampleCbcResponseExample;
import com.els.base.kn.sample.entity.SampleMaterialReportExample;
import com.els.base.kn.sample.entity.SamplePackingRequireExample;
import com.els.base.kn.sample.entity.SampleProcessRequireExample;
import com.els.base.kn.sample.entity.SampleShapeRequireExample;
import com.els.base.kn.sample.entity.SampleSizeReportExample;
import com.els.base.kn.sample.entity.SampleTestReportExample;
import com.els.base.kn.sample.entity.SampleTestRequireExample;
import com.els.base.kn.sample.service.SampleCbcResponseService;
import com.els.base.kn.sample.service.SampleMaterialReportService;
import com.els.base.kn.sample.service.SamplePackingRequireService;
import com.els.base.kn.sample.service.SampleProcessRequireService;
import com.els.base.kn.sample.service.SampleShapeRequireService;
import com.els.base.kn.sample.service.SampleSizeReportService;
import com.els.base.kn.sample.service.SampleTestReportService;
import com.els.base.kn.sample.service.SampleTestRequireService;
import com.els.base.sample.entity.SampleComfirmInfo;
import com.els.base.sample.entity.SampleComfirmInfoExample;
import com.els.base.sample.enums.SampleComfirmInfoStatus;
import com.els.base.sample.service.SampleComfirmInfoService;
import com.els.base.sample.vo.SampleComfirmSendVO;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SampleEditAspect {
    private Logger logger = LoggerFactory.getLogger(SampleEditAspect.class);
    private final CommonFileService commonFileService;
    private final SampleCbcResponseService sampleCbcResponseService;
    private final SampleMaterialReportService sampleMaterialReportService;
    private final SamplePackingRequireService samplePackingRequireService;
    private final SampleProcessRequireService sampleProcessRequireService;
    private final SampleShapeRequireService sampleShapeRequireService;
    private final SampleSizeReportService sampleSizeReportService;
    private final SampleTestReportService sampleTestReportService;
    private final SampleTestRequireService sampleTestRequireService;
    private final SampleComfirmInfoService sampleComfirmInfoService;

    @Autowired
    public SampleEditAspect(CommonFileService commonFileService, SampleCbcResponseService sampleCbcResponseService, SampleMaterialReportService sampleMaterialReportService, SamplePackingRequireService samplePackingRequireService, SampleProcessRequireService sampleProcessRequireService, SampleShapeRequireService sampleShapeRequireService, SampleSizeReportService sampleSizeReportService, SampleTestReportService sampleTestReportService, SampleTestRequireService sampleTestRequireService, SampleComfirmInfoService sampleComfirmInfoService) {
        this.commonFileService = commonFileService;
        this.sampleCbcResponseService = sampleCbcResponseService;
        this.sampleMaterialReportService = sampleMaterialReportService;
        this.samplePackingRequireService = samplePackingRequireService;
        this.sampleProcessRequireService = sampleProcessRequireService;
        this.sampleShapeRequireService = sampleShapeRequireService;
        this.sampleSizeReportService = sampleSizeReportService;
        this.sampleTestReportService = sampleTestReportService;
        this.sampleTestRequireService = sampleTestRequireService;
        this.sampleComfirmInfoService = sampleComfirmInfoService;
    }

    @After(value="execution(* com.els.base.kn.sample.controller.*.edit(..))")
    public void editAfter(JoinPoint joinPoint) {
        this.logger.info("\u8bd5\u6837\u6807\u7b7e\u4fee\u6539\u4e4b\u540e\u8c03\u7528 start");
        this.logger.info("\u62e6\u622a\u5230\u7684\u65b9\u6cd5:{}", (Object)joinPoint.getSignature().getDeclaringTypeName());
        Object object = joinPoint.getArgs()[0];
        String attachment = (String)ReflectUtils.getValue((Object)object, (String)"attachment");
        this.logger.info("attachment:{}", (Object)attachment);
        if (StringUtils.isNotEmpty((String)attachment)) {
            CommonFile commonFile = new CommonFile();
            commonFile.setAttachment(attachment);
            commonFile.setCompanyCode(SpringSecurityUtils.getLoginUserName());
            FileData fileData = this.getFileData(attachment);
            commonFile.setFileName(fileData.getFileName());
            commonFile.setFileId(fileData.getId());
            this.commonFileService.addObj(commonFile);
        }
    }

    private FileData getFileData(String attachment) {
        try {
            return (FileData)new ObjectMapper().readValue(attachment, FileData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("\u8bd5\u6837\u6807\u7b7e\u4fee\u6539-json\u8f6c\u6362\u6210\u5bf9\u8c61\u5931\u8d25!attachment:{}", (Object)attachment);
            throw new CommonException("\u4fdd\u5b58\u5931\u8d25\uff0cjson\u8f6c\u6362\u5f02\u5e38");
        }
    }

    @Before(value="execution(* com.els.base.sample.web.controller.SampleComfirmController.supSubmitSample(..))")
    public void submitSampleBefore(JoinPoint joinPoint) {
        List params;
        List<Object> objects = Arrays.asList(joinPoint.getArgs());
        Object o = objects.get(0);
        try {
            params = (List)o;
        }
        catch (Exception e) {
            this.logger.error("\u53c2\u6570\u8f6c\u6362\u5f02\u5e38");
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)params)) {
            params.forEach(sampleComfirmSendVO -> {
                SampleComfirmInfoExample sampleComfirmInfoExample = new SampleComfirmInfoExample();
                sampleComfirmInfoExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
                List sampleComfirmInfos = this.sampleComfirmInfoService.queryAllObjByExample((IExample)sampleComfirmInfoExample);
                if (CollectionUtils.isNotEmpty((Collection)sampleComfirmInfos)) {
                    if (SampleComfirmInfoStatus.SAMPLE_DOING.getValue() != ((SampleComfirmInfo)sampleComfirmInfos.get(0)).getStatus().intValue()) {
                        this.logger.error("\u8ba4\u5b9a\u5355\u72b6\u6001\u9519\u8bef:{}", (Object)((SampleComfirmInfo)sampleComfirmInfos.get(0)).getStatus());
                    } else {
                        this.logger.info("\u5f00\u59cb\u5224\u65ad\u662f\u5426\u4e0a\u4f20\u6587\u4ef6\u3002\u3002\u3002");
                        this.checkData((SampleComfirmSendVO)sampleComfirmSendVO);
                    }
                }
            });
        }
    }

    private void checkData(SampleComfirmSendVO sampleComfirmSendVO) {
        SampleCbcResponseExample sampleCbcResponseExample = new SampleCbcResponseExample();
        sampleCbcResponseExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List sampleCbcResponses = this.sampleCbcResponseService.queryAllObjByExample((IExample)sampleCbcResponseExample);
        if (CollectionUtils.isNotEmpty((Collection)sampleCbcResponses)) {
            sampleCbcResponses.forEach(sampleCbcResponse -> {
                if (Constant.YES_INT.equals(sampleCbcResponse.getIsNeedUpload()) && StringUtils.isEmpty((String)sampleCbcResponse.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + sampleCbcResponse.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + sampleCbcResponse.getMaterialCode() + "\u3011\u7684\u3010CBC\u54cd\u5e94\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
        SampleMaterialReportExample sampleMaterialReportExample = new SampleMaterialReportExample();
        sampleMaterialReportExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List sampleMaterialReports = this.sampleMaterialReportService.queryAllObjByExample((IExample)sampleMaterialReportExample);
        if (CollectionUtils.isNotEmpty((Collection)sampleMaterialReports)) {
            sampleMaterialReports.forEach(sampleMaterialReport -> {
                if (Constant.YES_INT.equals(sampleMaterialReport.getIsNeedUpload()) && StringUtils.isEmpty((String)sampleMaterialReport.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + sampleMaterialReport.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + sampleMaterialReport.getMaterialCode() + "\u3011\u7684\u3010\u6750\u8d28\u62a5\u544a\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
        SamplePackingRequireExample samplePackingRequireExample = new SamplePackingRequireExample();
        samplePackingRequireExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List samplePackingRequires = this.samplePackingRequireService.queryAllObjByExample((IExample)samplePackingRequireExample);
        if (CollectionUtils.isNotEmpty((Collection)samplePackingRequires)) {
            samplePackingRequires.forEach(samplePackingRequire -> {
                if (Constant.YES_INT.equals(samplePackingRequire.getIsNeedUpload()) && StringUtils.isEmpty((String)samplePackingRequire.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + samplePackingRequire.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + samplePackingRequire.getMaterialCode() + "\u3011\u7684\u3010\u5305\u88c5\u8981\u6c42\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
        SampleProcessRequireExample sampleProcessRequireExample = new SampleProcessRequireExample();
        sampleProcessRequireExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List sampleProcessRequires = this.sampleProcessRequireService.queryAllObjByExample((IExample)sampleProcessRequireExample);
        if (CollectionUtils.isNotEmpty((Collection)sampleProcessRequires)) {
            sampleProcessRequires.forEach(sampleProcessRequire -> {
                if (Constant.YES_INT.equals(sampleProcessRequire.getIsNeedUpload()) && StringUtils.isEmpty((String)sampleProcessRequire.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + sampleProcessRequire.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + sampleProcessRequire.getMaterialCode() + "\u3011\u7684\u3010\u5de5\u827a\u8981\u6c42\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
        SampleShapeRequireExample sampleShapeRequireExample = new SampleShapeRequireExample();
        sampleShapeRequireExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List sampleShapeRequires = this.sampleShapeRequireService.queryAllObjByExample((IExample)sampleShapeRequireExample);
        if (CollectionUtils.isNotEmpty((Collection)sampleShapeRequires)) {
            sampleShapeRequires.forEach(sampleShapeRequire -> {
                if (Constant.YES_INT.equals(sampleShapeRequire.getIsNeedUpload()) && StringUtils.isEmpty((String)sampleShapeRequire.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + sampleShapeRequire.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + sampleShapeRequire.getMaterialCode() + "\u3011\u7684\u3010\u578b\u5f0f\u5b9e\u9a8c\u8981\u6c42\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
        SampleSizeReportExample sampleSizeReportExample = new SampleSizeReportExample();
        sampleSizeReportExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List sampleSizeReports = this.sampleSizeReportService.queryAllObjByExample((IExample)sampleSizeReportExample);
        if (CollectionUtils.isNotEmpty((Collection)sampleSizeReports)) {
            sampleSizeReports.forEach(sampleSizeReport -> {
                if (Constant.YES_INT.equals(sampleSizeReport.getIsNeedUpload()) && StringUtils.isEmpty((String)sampleSizeReport.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + sampleSizeReport.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + sampleSizeReport.getMaterialCode() + "\u3011\u7684\u3010\u5168\u5c3a\u5bf8\u62a5\u544a\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
        SampleTestReportExample sampleTestReportExample = new SampleTestReportExample();
        sampleTestReportExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List sampleTestReports = this.sampleTestReportService.queryAllObjByExample((IExample)sampleTestReportExample);
        if (CollectionUtils.isNotEmpty((Collection)sampleTestReports)) {
            sampleTestReports.forEach(sampleTestReport -> {
                if (Constant.YES_INT.equals(sampleTestReport.getIsNeedUpload()) && StringUtils.isEmpty((String)sampleTestReport.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + sampleTestReport.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + sampleTestReport.getMaterialCode() + "\u3011\u7684\u3010\u5b9e\u9a8c\u62a5\u544a\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
        SampleTestRequireExample sampleTestRequireExample = new SampleTestRequireExample();
        sampleTestRequireExample.createCriteria().andSapOrderNoEqualTo(sampleComfirmSendVO.getSapOrderNo()).andOrderNoEqualTo(sampleComfirmSendVO.getSrmOrderNo()).andMaterialCodeEqualTo(sampleComfirmSendVO.getMaterialCode());
        List sampleTestRequires = this.sampleTestRequireService.queryAllObjByExample((IExample)sampleTestRequireExample);
        if (CollectionUtils.isNotEmpty((Collection)sampleTestRequires)) {
            sampleTestRequires.forEach(sampleTestRequire -> {
                if (Constant.YES_INT.equals(sampleTestRequire.getIsNeedUpload()) && StringUtils.isEmpty((String)sampleTestRequire.getAttachment())) {
                    throw new CommonException("\u5355\u636e\u53f7:\u3010" + sampleTestRequire.getOrderNo() + "\u3011\u7269\u6599\u7f16\u7801:\u3010" + sampleTestRequire.getMaterialCode() + "\u3011\u7684\u3010\u68c0\u9a8c\u8981\u6c42\u3011\u672a\u4e0a\u4f20\u76f8\u5173\u6587\u4ef6");
                }
            });
        }
    }
}

