CREATE TABLE `T_BASE_SCHEDULE_JOB_LOG`
(
    `ID`                varchar(32) NOT NULL COMMENT '定时任务Id',
    `JOB_NAME`          varchar(100) DEFAULT NULL COMMENT '定时任务名称',
    `JOB_CODE`          varchar(100) DEFAULT NULL COMMENT 'job唯一代码',
    `DESCRIPTOPN`       varchar(255) DEFAULT NULL COMMENT '定时任务描述',
    `JOB_CLASS`         varchar(100) DEFAULT NULL COMMENT '定时任务完整类名称',
    `JOB_METHOD`        varchar(50)  DEFAULT NULL COMMENT '定时任务方法名称',
    `JOB_STATE`         int(11)      DEFAULT '0' COMMENT 'job状态,1正常运行，2运行异常',
    `CRON_EXPRESSION`   varchar(50)  DEFAULT NULL COMMENT '定时任务的Corn表达式',
    `IS_ENABLE`         int(11)      DEFAULT '1' COMMENT '是否启用，1启用，0禁用',
    `IS_CONCURRENT`     int(11)      DEFAULT '0' COMMENT '能否并发运行，1可以，0不可以',
    `CREATE_TIME`       datetime     DEFAULT NULL COMMENT '创建时间',
    `UPDATE_TIME`       datetime     DEFAULT NULL COMMENT '更新时间',
    `JOB_METHOD_PARAMS` varchar(255) DEFAULT NULL COMMENT '定时任务方法参数',
    `JOB_GROUP`         varchar(255) DEFAULT NULL COMMENT '定时任务组',
    `TIMES`             bigint(20)   DEFAULT NULL COMMENT '定时任务执行消耗的时间',
    `JOB_ID`            varchar(255) DEFAULT NULL COMMENT '定时任务关联ID',
    `INSTANCE_NAME`     varchar(255) DEFAULT NULL COMMENT '实例名称',
    PRIMARY KEY (`ID`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='定时任务执行历史';


CREATE TABLE `T_BASE_SCHEDULE_JOB`
(
    `ID`                varchar(32)  NOT NULL,
    `JOB_NAME`          varchar(100) NOT NULL,
    `JOB_CODE`          varchar(100) NOT NULL,
    `DESCRIPTOPN`       varchar(255)          DEFAULT NULL,
    `JOB_CLASS`         varchar(100) NOT NULL,
    `JOB_METHOD`        varchar(50)  NOT NULL,
    `JOB_STATE`         int(11)      NOT NULL DEFAULT '0',
    `CRON_EXPRESSION`   varchar(50)  NOT NULL,
    `IS_ENABLE`         int(11)               DEFAULT '1',
    `IS_CONCURRENT`     int(11)      NOT NULL DEFAULT '0',
    `CREATE_TIME`       datetime(6)  NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `UPDATE_TIME`       datetime(6)           DEFAULT NULL,
    `JOB_METHOD_PARAMS` varchar(255)          DEFAULT NULL COMMENT '定时任务方法参数',
    `JOB_GROUP`         varchar(255)          DEFAULT NULL COMMENT '定时任务组'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;
