/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.config;

import com.els.base.schedule.plugin.QuartzManager;
import com.els.base.schedule.plugin.impl.QuartzManagerImpl;
import com.els.base.utils.SpringContextHolder;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class ScheduleConfiguration {
    private static final String DEFAULT_EMPTY_CONFIG = "DEFAULT";
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;
    @Value(value="${org.quartz.scheduler.instanceName:DefaultScheduler}")
    protected String instanceName;
    @Value(value="${org.quartz.scheduler.instanceId:AUTO}")
    protected String instanceId;
    @Value(value="${org.quartz.jobStore.class:org.quartz.impl.jdbcjobstore.JobStoreTX}")
    protected String jobStoreClass;
    @Value(value="${org.quartz.jobStore.isClustered:true}")
    protected String isClustered;
    @Value(value="${org.quartz.jobStore.clusterCheckinInterval:15000}")
    protected String clusterCheckinInterval;
    @Value(value="${org.quartz.jobStore.maxMisfiresToHandleAtATime:1}")
    protected String maxMisfiresToHandleAtATime;
    @Value(value="${org.quartz.jobStore.misfireThreshold:12000}")
    protected String misfireThreshold;
    @Value(value="${org.quartz.jobStore.tablePrefix:QRTZ_}")
    protected String tablePrefix;
    @Value(value="${org.quartz.jobStore.selectWithLockSQL:SELECT * FROM {0}LOCKS WHERE SCHED_NAME = {1} AND LOCK_NAME = ? FOR UPDATE}")
    protected String selectWithLockSQL;
    @Value(value="${org.quartz.scheduler.instanceIdGenerator.class:com.els.base.schedule.utils.CommonInstanceIdGenerator}")
    protected String instanceIdGeneratorClass;
    @Value(value="${org.quartz.jobStore.driverDelegateClass:DEFAULT}")
    protected String driverDelegateClass;

    @Bean(value={"stdSchedule"})
    public SchedulerFactoryBean schedulerFactoryBean(DataSource dataSource, SpringContextHolder springContextHolder) throws IOException {
        Properties prop = new Properties();
        prop.put("org.quartz.scheduler.instanceId", this.instanceId);
        prop.put("org.quartz.scheduler.instanceName", this.instanceName);
        prop.put("org.quartz.scheduler.instanceIdGenerator.class", this.instanceIdGeneratorClass);
        prop.put("org.quartz.jobStore.class", this.jobStoreClass);
        prop.put("org.quartz.jobStore.isClustered", this.isClustered);
        prop.put("org.quartz.jobStore.clusterCheckinInterval", this.clusterCheckinInterval);
        prop.put("org.quartz.jobStore.maxMisfiresToHandleAtATime", this.maxMisfiresToHandleAtATime);
        prop.put("org.quartz.jobStore.misfireThreshold", this.misfireThreshold);
        prop.put("org.quartz.jobStore.tablePrefix", this.tablePrefix);
        prop.put("org.quartz.jobStore.selectWithLockSQL", this.selectWithLockSQL);
        if (!DEFAULT_EMPTY_CONFIG.equals(this.driverDelegateClass)) {
            prop.put("org.quartz.jobStore.driverDelegateClass", this.driverDelegateClass);
        }
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        factory.setQuartzProperties(prop);
        factory.setOverwriteExistingJobs(true);
        factory.setAutoStartup(false);
        factory.setDataSource(dataSource);
        factory.setTaskExecutor((Executor)this.defaultThreadPool);
        factory.setJobFactory((JobFactory)new SpringBeanJobFactory());
        return factory;
    }

    @Autowired
    @Bean(value={"quartzManager"})
    public QuartzManager getQuartzManager(Scheduler stdScheduler) {
        return new QuartzManagerImpl(stdScheduler);
    }
}

