package com.els.base.schedule.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.schedule.dao.ScheduleJobMapper;
import com.els.base.schedule.entity.ScheduleJob;
import com.els.base.schedule.entity.ScheduleJobExample;
import com.els.base.schedule.service.ScheduleJobService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultScheduleJobService")
public class ScheduleJobServiceImpl implements ScheduleJobService {
    @Resource
    protected ScheduleJobMapper scheduleJobMapper;

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    @Override
    public void addObj(ScheduleJob t) {
        this.scheduleJobMapper.insertSelective(t);
    }

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.scheduleJobMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    @Override
    public void modifyObj(ScheduleJob t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.scheduleJobMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="scheduleJob", keyGenerator="redisKeyGenerator")
    @Override
    public ScheduleJob queryObjById(String id) {
        return this.scheduleJobMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="scheduleJob", keyGenerator="redisKeyGenerator")
    @Override
    public List<ScheduleJob> queryAllObjByExample(ScheduleJobExample example) {
        return this.scheduleJobMapper.selectByExample(example);
    }

    @Cacheable(value="scheduleJob", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ScheduleJob> queryObjByPage(ScheduleJobExample example) {
        PageView<ScheduleJob> pageView = example.getPageView();
        pageView.setQueryResult(this.scheduleJobMapper.selectByExampleByPage(example));
        return pageView;
    }
}