/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.plugin.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.schedule.entity.ScheduleJob;
import com.els.base.schedule.entity.ScheduleJobExample;
import com.els.base.schedule.plugin.QuartzManager;
import com.els.base.schedule.service.ScheduleJobService;
import com.els.base.utils.SpringContextHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;

public class QuartzManagerImpl
implements QuartzManager {
    private static final Logger logger = LoggerFactory.getLogger(QuartzManagerImpl.class);
    @Autowired
    protected ScheduleJobService scheduleJobService;
    @Value(value="#{sysConfig['job.is.enable']}")
    protected String isJobEnalbe;
    private static StdScheduler scheduler = null;

    public void setScheduler(StdScheduler stdScheduler) {
        scheduler = stdScheduler;
    }

    public StdScheduler getScheduler() {
        return scheduler;
    }

    @Override
    public void runJobNow(ScheduleJob job) throws SchedulerException, ClassNotFoundException, NoSuchMethodException {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(job.getJobClass());
            Object excutionBean = SpringContextHolder.getOneBean(clazz);
            Method method = clazz.getDeclaredMethod(job.getJobMethod(), new Class[0]);
            method.invoke(excutionBean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pauseJob(ScheduleJob job) throws SchedulerException {
        JobKey jobKey = JobKey.jobKey((String)job.getJobCode(), (String)"DEFAULT");
        if (scheduler.checkExists(jobKey)) {
            scheduler.pauseJob(jobKey);
        }
        ScheduleJob tmp = new ScheduleJob();
        tmp.setId(job.getId());
        tmp.setJobState(ScheduleJob.JOB_STATE_PAUSE);
        this.scheduleJobService.modifyObj(tmp);
    }

    @Override
    public void resumeJob(ScheduleJob job) throws SchedulerException, ClassNotFoundException, NoSuchMethodException, ParseException {
        if (!this.checkSwitch()) {
            throw new CommonException("\u672c\u5e94\u7528\uff0c\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\uff0c\u8bf7\u5728 conf.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\u5f00\u542f", "base_fail");
        }
        JobKey jobKey = JobKey.jobKey((String)job.getJobCode(), (String)"DEFAULT");
        if (scheduler.checkExists(jobKey)) {
            scheduler.resumeJob(jobKey);
        } else {
            this.addJob(job);
        }
        ScheduleJob tmp = new ScheduleJob();
        tmp.setId(job.getId());
        tmp.setJobState(ScheduleJob.JOB_STATE_NORMAL);
        this.scheduleJobService.modifyObj(tmp);
    }

    @Override
    public void deleteJob(ScheduleJob job) throws SchedulerException {
        JobKey jobKey = JobKey.jobKey((String)job.getJobCode(), (String)"DEFAULT");
        scheduler.deleteJob(jobKey);
        ScheduleJob tmp = new ScheduleJob();
        tmp.setId(job.getId());
        tmp.setJobState(ScheduleJob.JOB_STATE_NORMAL);
        this.scheduleJobService.modifyObj(tmp);
    }

    @Override
    public void updateJobCron(ScheduleJob job) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)job.getJobCode(), (String)"DEFAULT");
        CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
        trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
    }

    @Override
    public List<ScheduleJob> getAllJob() throws SchedulerException {
        GroupMatcher matcher = GroupMatcher.anyJobGroup();
        Set jobKeys = scheduler.getJobKeys(matcher);
        ArrayList<String> jobCodeList = new ArrayList<String>();
        for (JobKey jobKey : jobKeys) {
            jobCodeList.add(jobKey.getName());
        }
        ScheduleJobExample jobExample = new ScheduleJobExample();
        jobExample.createCriteria().andJobCodeIn(jobCodeList);
        return this.scheduleJobService.queryAllObjByExample((IExample)jobExample);
    }

    @Override
    public List<ScheduleJob> getRunningJob() throws SchedulerException {
        List executingJobs = scheduler.getCurrentlyExecutingJobs();
        ArrayList<String> jobCodeList = new ArrayList<String>(executingJobs.size());
        for (JobExecutionContext executingJob : executingJobs) {
            JobDetail jobDetail = executingJob.getJobDetail();
            JobKey jobKey = jobDetail.getKey();
            jobCodeList.add(jobKey.getName());
        }
        ScheduleJobExample jobExample = new ScheduleJobExample();
        jobExample.createCriteria().andJobCodeIn(jobCodeList);
        return this.scheduleJobService.queryAllObjByExample((IExample)jobExample);
    }

    @Override
    public boolean isCronCorrect(String cronStr) {
        return CronExpression.isValidExpression((String)cronStr);
    }

    public void addJob(ScheduleJob job) throws ClassNotFoundException, NoSuchMethodException, SchedulerException, ParseException {
        if (!this.checkSwitch()) {
            throw new CommonException("\u672c\u5e94\u7528\uff0c\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\uff0c\u8bf7\u5728 conf.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\u5f00\u542f", "base_fail");
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> objClass = classLoader.loadClass(job.getJobClass());
        Object excutionBean = SpringContextHolder.getOneBean(objClass);
        MethodInvokingJobDetailFactoryBean jobDetail = new MethodInvokingJobDetailFactoryBean();
        jobDetail.setName(job.getJobCode());
        jobDetail.setGroup("DEFAULT");
        jobDetail.setTargetClass(objClass);
        jobDetail.setTargetObject(excutionBean);
        jobDetail.setTargetMethod(job.getJobMethod());
        jobDetail.setConcurrent(Constant.YES_INT.equals(job.getIsConcurrent()));
        jobDetail.afterPropertiesSet();
        jobDetail.getObject().getKey();
        CronTriggerFactoryBean trigger = new CronTriggerFactoryBean();
        trigger.setBeanName(job.getJobCode());
        trigger.setGroup("DEFAULT");
        trigger.setJobDetail(jobDetail.getObject());
        trigger.setCronExpression(job.getCronExpression());
        trigger.afterPropertiesSet();
        scheduler.scheduleJob(jobDetail.getObject(), (Trigger)trigger.getObject());
    }

    @PostConstruct
    protected void init() {
        if (!this.checkSwitch()) {
            return;
        }
        ScheduleJobExample scheduleJobExample = new ScheduleJobExample();
        scheduleJobExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List list = this.scheduleJobService.queryAllObjByExample((IExample)scheduleJobExample);
        for (int i = 0; i < list.size(); ++i) {
            ScheduleJob job = (ScheduleJob)list.get(i);
            if (!Constant.YES_INT.equals(job.getIsEnable())) continue;
            try {
                this.addJob(job);
                ScheduleJob tmp = new ScheduleJob();
                tmp.setId(job.getId());
                tmp.setJobState(ScheduleJob.JOB_STATE_NORMAL);
                this.scheduleJobService.modifyObj(tmp);
                continue;
            }
            catch (Exception e) {
                logger.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                ScheduleJob tmp = new ScheduleJob();
                tmp.setId(job.getId());
                tmp.setJobState(ScheduleJob.JOB_STATE_EXCEPTION);
                this.scheduleJobService.modifyObj(tmp);
            }
        }
    }

    public boolean checkSwitch() {
        return "true".equals(this.isJobEnalbe);
    }
}

