/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.schedule.entity.ScheduleJob;
import com.els.base.schedule.entity.ScheduleJobExample;
import com.els.base.schedule.plugin.QuartzManager;
import com.els.base.schedule.service.ScheduleJobService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.quartz.SchedulerException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5b9a\u65f6\u4efb\u52a1")
@Controller
@RequestMapping(value={"scheduleJob"})
public class ScheduleJobController {
    @Resource
    protected ScheduleJobService scheduleJobService;
    @Resource
    protected QuartzManager quartzManager;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ScheduleJob scheduleJob) {
        this.scheduleJobService.addObj(scheduleJob);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ScheduleJob scheduleJob) throws SchedulerException {
        if (StringUtils.isBlank((String)scheduleJob.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        ScheduleJob tmp = (ScheduleJob)this.scheduleJobService.queryObjById(scheduleJob.getId());
        if (ScheduleJob.JOB_STATE_NORMAL.equals(tmp.getJobState())) {
            throw new CommonException("job \u5df2\u542f\u52a8\uff0c\u65e0\u6cd5\u4fee\u6539", "base_fail");
        }
        if (!this.quartzManager.isCronCorrect(scheduleJob.getCronExpression())) {
            throw new CommonException("cron \u8868\u8fbe\u5f0f\u9519\u8bef", "expression_error");
        }
        if (StringUtils.isBlank((String)scheduleJob.getCronExpression()) || StringUtils.isBlank((String)scheduleJob.getJobCode())) {
            throw new CommonException("cron\u8868\u8fbe\u5f0f \u4e0e jobcode\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"cron\u8868\u8fbe\u5f0f \u4e0e jobcode"});
        }
        if (!(scheduleJob.getCronExpression().equals(tmp.getCronExpression()) && scheduleJob.getJobCode().equals(tmp.getJobCode()) && scheduleJob.getIsConcurrent().equals(tmp.getIsConcurrent()))) {
            this.quartzManager.deleteJob(tmp);
        }
        this.scheduleJobService.modifyObj(scheduleJob);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.scheduleJobService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ScheduleJob>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) QueryParamWapper queryParams) {
        ScheduleJobExample example = new ScheduleJobExample();
        example.setPageView((PageView<ScheduleJob>)new PageView(pageNo, pageSize));
        ScheduleJobExample.Criteria criteria = example.createCriteria();
        if (queryParams != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParams);
        }
        return ResponseResult.success((Object)this.scheduleJobService.queryObjByPage((IExample)example));
    }

    @ApiOperation(httpMethod="GET", value="\u73b0\u5728\u6267\u884c\u4efb\u52a1")
    @RequestMapping(value={"service/runJobNow"})
    @ResponseBody
    public ResponseResult<String> runJobNow(String id) throws SchedulerException {
        ScheduleJob job = (ScheduleJob)this.scheduleJobService.queryObjById(id);
        try {
            this.quartzManager.runJobNow(job);
        }
        catch (ClassNotFoundException e) {
            throw new CommonException("\u627e\u4e0d\u5230\u8be5bean", "base_fail");
        }
        catch (NoSuchMethodException e) {
            throw new CommonException("\u627e\u4e0d\u5230\u8be5\u65b9\u6cd5", "not_found_fun");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u505c\u6b62\u4efb\u52a1")
    @RequestMapping(value={"service/pauseJob"})
    @ResponseBody
    public ResponseResult<String> pauseJob(String id) {
        ScheduleJob job = (ScheduleJob)this.scheduleJobService.queryObjById(id);
        try {
            this.quartzManager.pauseJob(job);
            ScheduleJob tmp = new ScheduleJob();
            tmp.setId(id);
            tmp.setIsEnable(Constant.NO_INT);
            this.scheduleJobService.modifyObj(tmp);
        }
        catch (SchedulerException e) {
            throw new CommonException("job \u505c\u6b62\u4efb\u52a1\u5931\u8d25", "base_fail");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u52a8\u4efb\u52a1")
    @RequestMapping(value={"service/resumeJob"})
    @ResponseBody
    public ResponseResult<String> resumeJob(String id) {
        ScheduleJob job = (ScheduleJob)this.scheduleJobService.queryObjById(id);
        try {
            this.quartzManager.resumeJob(job);
            ScheduleJob tmp = new ScheduleJob();
            tmp.setId(id);
            tmp.setIsEnable(Constant.YES_INT);
            this.scheduleJobService.modifyObj(tmp);
        }
        catch (ClassNotFoundException | NoSuchMethodException | ParseException | SchedulerException e) {
            throw new CommonException("job \u542f\u52a8\u4efb\u52a1\u5931\u8d25", "base_fail");
        }
        return ResponseResult.success();
    }
}

